/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.OGLUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL2;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class ToolTipRenderer {
    private boolean useSystemLookAndFeel;
    private Font font;
    private Color textColor;
    private Color interiorColor;
    private Color outlineColor;
    private double opacity;
    private double outlineWidth;
    private Insets insets;

    public ToolTipRenderer(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.useSystemLookAndFeel = false;
        this.font = font;
        this.textColor = Color.WHITE;
        this.interiorColor = Color.BLACK;
        this.outlineColor = Color.WHITE;
        this.outlineWidth = 1.0;
        this.opacity = 1.0;
        this.insets = new Insets(1, 1, 1, 1);
    }

    public ToolTipRenderer(boolean bl) {
        this(Font.decode("Arial-PLAIN-12"));
        this.setUseSystemLookAndFeel(bl);
    }

    public ToolTipRenderer() {
        this(Font.decode("Arial-PLAIN-12"));
    }

    public static Color getContrastingColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        Color color2 = Color.getHSBColor(0.0f, 0.0f, (fArray[2] + 0.5f) % 1.0f);
        return new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), color.getAlpha());
    }

    public boolean isUseSystemLookAndFeel() {
        return this.useSystemLookAndFeel;
    }

    public void setUseSystemLookAndFeel(boolean bl) {
        this.useSystemLookAndFeel = bl;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.font = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.textColor = color;
    }

    public Color getInteriorColor() {
        return this.interiorColor;
    }

    public void setInteriorColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorColor = color;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineColor = color;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity < 0 or opacity > 1");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.opacity = d;
    }

    public double getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineWidth = d;
    }

    public Insets getInsets() {
        return (Insets)this.insets.clone();
    }

    public void setInsets(Insets insets) {
        if (insets == null) {
            String string = Logging.getMessage("nullValue.InsetsIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.insets = (Insets)insets.clone();
    }

    public void render(DrawContext drawContext, String string, int n, int n2) {
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().fine(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().fine(string3);
            throw new IllegalArgumentException(string3);
        }
        this.doRender(drawContext, string, n, n2);
    }

    protected ToolTipAttributes getAttributes() {
        return new ToolTipAttributes(this.getFont(), this.getTextColor(), this.getInteriorColor(), this.getOutlineColor(), this.getOpacity(), this.getOpacity(), this.getOpacity(), this.getOutlineWidth(), this.getInsets());
    }

    protected ToolTipAttributes getSystemLookAndFeelAttributes() {
        Font font = UIManager.getFont("ToolTip.font");
        Color color = UIManager.getColor("ToolTip.foreground");
        Color color2 = UIManager.getColor("ToolTip.background");
        Color color3 = UIManager.getColor("ToolTip.foreground");
        double d = this.getOpacity();
        double d2 = this.getOpacity();
        double d3 = this.getOpacity();
        double d4 = this.getOutlineWidth();
        Insets insets = null;
        Border border = UIManager.getBorder("ToolTip.border");
        if (border instanceof LineBorder) {
            color3 = ((LineBorder)border).getLineColor();
            d4 = ((LineBorder)border).getThickness();
        }
        if (border != null) {
            insets = border.getBorderInsets(null);
        }
        if (font == null) {
            font = this.getFont();
        }
        if (color == null) {
            color = this.getTextColor();
        }
        if (color2 == null) {
            color2 = this.getInteriorColor();
        }
        if (color3 == null) {
            color3 = this.getOutlineColor();
        }
        if (insets == null) {
            insets = this.getInsets();
        }
        return new ToolTipAttributes(font, color, color2, color3, d, d2, d3, d4, insets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRender(DrawContext drawContext, String string, int n, int n2) {
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        this.beginRendering(drawContext, oGLStackHandler);
        try {
            this.draw(drawContext, drawContext.getView().getViewport(), string, n, n2);
        }
        finally {
            this.endRendering(drawContext, oGLStackHandler);
        }
    }

    protected void draw(DrawContext drawContext, Rectangle rectangle, String string, int n, int n2) {
        ToolTipAttributes toolTipAttributes = this.isUseSystemLookAndFeel() ? this.getSystemLookAndFeelAttributes() : this.getAttributes();
        this.drawToolTip(drawContext, rectangle, string, n, n2, toolTipAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawToolTip(DrawContext drawContext, Rectangle rectangle, String string, int n, int n2, ToolTipAttributes toolTipAttributes) {
        Rectangle2D rectangle2D = this.computeTextBounds(drawContext, string, toolTipAttributes.getFont());
        Rectangle2D rectangle2D2 = this.computeBackgroundBounds(drawContext, rectangle2D.getWidth(), rectangle2D.getHeight(), toolTipAttributes.getInsets());
        Point point = this.adjustDrawPointToViewport(n, n2, rectangle2D2, rectangle);
        Point2D point2D = this.computeTextTranslation(drawContext, rectangle2D, toolTipAttributes.getInsets());
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushModelview(gL2);
        try {
            gL2.glTranslated(point.getX() + rectangle2D2.getX(), point.getY() + rectangle2D2.getY(), 0.0);
            this.drawToolTipInterior(drawContext, rectangle2D2.getWidth(), rectangle2D2.getHeight(), toolTipAttributes);
            this.drawToolTipOutline(drawContext, rectangle2D2.getWidth(), rectangle2D2.getHeight(), toolTipAttributes);
            gL2.glTranslated(point2D.getX(), point2D.getY(), 0.0);
            this.drawToolTipText(drawContext, string, 0, 0, toolTipAttributes);
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    protected void beginRendering(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 28677;
        oGLStackHandler.pushAttrib(gL2, n);
        oGLStackHandler.pushTextureIdentity(gL2);
        oGLStackHandler.pushProjectionIdentity(gL2);
        Rectangle rectangle = drawContext.getView().getViewport();
        gL2.glOrtho((double)rectangle.x, (double)(rectangle.x + rectangle.width), (double)rectangle.y, (double)(rectangle.y + rectangle.height), -1.0, 1.0);
        oGLStackHandler.pushModelviewIdentity(gL2);
        gL2.glEnable(3008);
        gL2.glAlphaFunc(516, 0.0f);
        gL2.glEnable(3042);
        OGLUtil.applyBlending(gL2, true);
        gL2.glDisable(2884);
        gL2.glDisable(2929);
        gL2.glDisable(2896);
        gL2.glDisable(3553);
    }

    protected void endRendering(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        oGLStackHandler.pop(gL2);
    }

    protected void drawToolTipInterior(DrawContext drawContext, double d, double d2, ToolTipAttributes toolTipAttributes) {
        GL2 gL2 = drawContext.getGL().getGL2();
        this.applyColor(drawContext, toolTipAttributes.getInteriorColor(), toolTipAttributes.getInteriorOpacity());
        gL2.glRectd(0.0, 0.0, d, d2);
    }

    protected void drawToolTipOutline(DrawContext drawContext, double d, double d2, ToolTipAttributes toolTipAttributes) {
        GL2 gL2 = drawContext.getGL().getGL2();
        this.applyColor(drawContext, toolTipAttributes.getOutlineColor(), toolTipAttributes.getOutlineOpacity());
        gL2.glLineWidth((float)this.getOutlineWidth());
        double d3 = 0.5;
        gL2.glBegin(2);
        gL2.glVertex2d(d3, d3);
        gL2.glVertex2d(d - d3, d3);
        gL2.glVertex2d(d - d3, d2 - d3);
        gL2.glVertex2d(d3, d2 - d3);
        gL2.glEnd();
    }

    protected void drawToolTipText(DrawContext drawContext, String string, int n, int n2, ToolTipAttributes toolTipAttributes) {
        Color color = this.modulateColorOpacity(toolTipAttributes.getTextColor(), toolTipAttributes.getTextOpacity());
        TextRenderer textRenderer = this.getTextRenderer(drawContext, toolTipAttributes.getFont());
        textRenderer.begin3DRendering();
        textRenderer.setColor(color);
        textRenderer.draw(string, n, n2);
        textRenderer.end3DRendering();
    }

    protected TextRenderer getTextRenderer(DrawContext drawContext, Font font) {
        return OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
    }

    protected void applyColor(DrawContext drawContext, Color color, double d) {
        if (drawContext.isPickingMode()) {
            return;
        }
        double d2 = d * ((double)color.getAlpha() / 255.0);
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLUtil.applyColor(gL2, color, d2, true);
    }

    protected Color modulateColorOpacity(Color color, double d) {
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[3] = fArray[3] * (float)d;
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    protected Rectangle2D computeTextBounds(DrawContext drawContext, String string, Font font) {
        TextRenderer textRenderer = this.getTextRenderer(drawContext, font);
        return textRenderer.getBounds(string);
    }

    protected Point2D computeTextTranslation(DrawContext drawContext, Rectangle2D rectangle2D, Insets insets) {
        return new Point2D.Double((double)insets.left - rectangle2D.getX(), (double)insets.bottom + rectangle2D.getY() + rectangle2D.getHeight());
    }

    protected Rectangle2D computeBackgroundBounds(DrawContext drawContext, double d, double d2, Insets insets) {
        return new Rectangle2D.Double(0.0, 0.0, d + (double)(insets.left + insets.right), d2 + (double)(insets.top + insets.bottom));
    }

    protected Point adjustDrawPointToViewport(int n, int n2, Rectangle2D rectangle2D, Rectangle rectangle) {
        if ((double)n + rectangle2D.getMaxX() > rectangle.getWidth()) {
            n = (int)(rectangle.getWidth() - rectangle2D.getWidth()) - 1;
        } else if (n < 0) {
            n = 0;
        }
        if ((double)n2 + rectangle2D.getMaxY() > rectangle.getHeight()) {
            n2 = (int)(rectangle.getHeight() - rectangle2D.getHeight()) - 1;
        } else if (n2 < 0) {
            n2 = 0;
        }
        return new Point(n, n2);
    }

    protected static class ToolTipAttributes {
        protected Font font;
        protected Color textColor;
        protected Color interiorColor;
        protected Color outlineColor;
        protected double textOpacity;
        protected double interiorOpacity;
        protected double outlineOpacity;
        protected double borderWidth;
        protected Insets insets;

        public ToolTipAttributes(Font font, Color color, Color color2, Color color3, double d, double d2, double d3, double d4, Insets insets) {
            this.font = font;
            this.textColor = color;
            this.interiorColor = color2;
            this.outlineColor = color3;
            this.textOpacity = d;
            this.interiorOpacity = d2;
            this.outlineOpacity = d3;
            this.borderWidth = d4;
            this.insets = insets;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Color getTextColor() {
            return this.textColor;
        }

        public void setTextColor(Color color) {
            this.textColor = color;
        }

        public Color getInteriorColor() {
            return this.interiorColor;
        }

        public void setInteriorColor(Color color) {
            this.interiorColor = color;
        }

        public Color getOutlineColor() {
            return this.outlineColor;
        }

        public void setOutlineColor(Color color) {
            this.outlineColor = color;
        }

        public double getTextOpacity() {
            return this.textOpacity;
        }

        public void setTextOpacity(double d) {
            this.textOpacity = d;
        }

        public double getInteriorOpacity() {
            return this.interiorOpacity;
        }

        public void setInteriorOpacity(double d) {
            this.interiorOpacity = d;
        }

        public double getOutlineOpacity() {
            return this.outlineOpacity;
        }

        public void setOutlineOpacity(double d) {
            this.outlineOpacity = d;
        }

        public double getBorderWidth() {
            return this.borderWidth;
        }

        public void setBorderWidth(double d) {
            this.borderWidth = d;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void setInsets(Insets insets) {
            this.insets = insets;
        }
    }
}

