/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.terrain.SectorGeometry;
import gov.nasa.worldwind.util.Logging;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;

public abstract class SurfaceTileRenderer
implements Disposable {
    private static final int DEFAULT_ALPHA_TEXTURE_SIZE = 1024;
    protected Texture alphaTexture;
    protected Texture outlineTexture;
    private boolean showImageTileOutlines = false;

    @Override
    public void dispose() {
        GLContext gLContext = GLContext.getCurrent();
        if (gLContext == null || gLContext.getGL() == null) {
            return;
        }
        GL gL = gLContext.getGL();
        if (this.alphaTexture != null) {
            this.alphaTexture.destroy(gL);
        }
        this.alphaTexture = null;
        if (this.outlineTexture != null) {
            this.outlineTexture.destroy(gL);
        }
        this.outlineTexture = null;
    }

    public boolean isShowImageTileOutlines() {
        return this.showImageTileOutlines;
    }

    public void setShowImageTileOutlines(boolean bl) {
        this.showImageTileOutlines = bl;
    }

    public void renderTile(DrawContext drawContext, SurfaceTile surfaceTile) {
        if (surfaceTile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        ArrayList<SurfaceTile> arrayList = new ArrayList<SurfaceTile>(1);
        arrayList.add(surfaceTile);
        this.renderTiles(drawContext, arrayList);
        arrayList.clear();
    }

    protected abstract void preComputeTextureTransform(DrawContext var1, SectorGeometry var2, Transform var3);

    protected abstract void computeTextureTransform(DrawContext var1, SurfaceTile var2, Transform var3);

    protected abstract Iterable<SurfaceTile> getIntersectingTiles(DrawContext var1, SectorGeometry var2, Iterable<? extends SurfaceTile> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTiles(DrawContext drawContext, Iterable<? extends SurfaceTile> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.TileIterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 33985;
        boolean bl = this.showImageTileOutlines && drawContext.getGLRuntimeCapabilities().getNumTextureUnits() > 2;
        gL2.glPushAttrib(28929);
        try {
            this.alphaTexture = drawContext.getTextureCache().getTexture(this);
            if (this.alphaTexture == null) {
                this.initAlphaTexture(drawContext, 1024);
                drawContext.getTextureCache().put(this, this.alphaTexture);
            }
            if (bl && this.outlineTexture == null) {
                this.initOutlineTexture(drawContext, 128);
            }
            gL2.glEnable(2929);
            gL2.glDepthFunc(515);
            gL2.glEnable(3008);
            gL2.glAlphaFunc(516, 0.01f);
            gL2.glActiveTexture(33984);
            gL2.glEnable(3553);
            gL2.glMatrixMode(5890);
            gL2.glPushMatrix();
            if (!drawContext.isPickingMode()) {
                gL2.glTexEnvi(8960, 8704, 8448);
            } else {
                gL2.glTexEnvf(8960, 8704, 34160.0f);
                gL2.glTexEnvf(8960, 34176, 34168.0f);
                gL2.glTexEnvf(8960, 34161, 7681.0f);
            }
            int n2 = 2;
            if (bl) {
                n2 = 3;
                n = 33986;
                gL2.glActiveTexture(33985);
                gL2.glEnable(3553);
                gL2.glMatrixMode(5890);
                gL2.glPushMatrix();
                gL2.glTexEnvi(8960, 8704, 260);
            }
            gL2.glActiveTexture(n);
            gL2.glEnable(3553);
            gL2.glMatrixMode(5890);
            gL2.glPushMatrix();
            gL2.glTexEnvi(8960, 8704, 8448);
            drawContext.getSurfaceGeometry().beginRendering(drawContext);
            Transform transform = new Transform();
            for (SectorGeometry sectorGeometry : drawContext.getSurfaceGeometry()) {
                Iterable<SurfaceTile> iterable2 = this.getIntersectingTiles(drawContext, sectorGeometry, iterable);
                if (iterable2 == null) continue;
                sectorGeometry.beginRendering(drawContext, n2);
                this.preComputeTextureTransform(drawContext, sectorGeometry, transform);
                for (SurfaceTile surfaceTile : iterable2) {
                    gL2.glActiveTexture(33984);
                    if (!surfaceTile.bind(drawContext)) continue;
                    gL2.glMatrixMode(5890);
                    gL2.glLoadIdentity();
                    surfaceTile.applyInternalTransform(drawContext, true);
                    this.computeTextureTransform(drawContext, surfaceTile, transform);
                    gL2.glScaled(transform.HScale, transform.VScale, 1.0);
                    gL2.glTranslated(transform.HShift, transform.VShift, 0.0);
                    if (bl) {
                        gL2.glActiveTexture(33985);
                        this.outlineTexture.bind((GL)gL2);
                        gL2.glMatrixMode(5890);
                        gL2.glLoadIdentity();
                        gL2.glScaled(transform.HScale, transform.VScale, 1.0);
                        gL2.glTranslated(transform.HShift, transform.VShift, 0.0);
                    }
                    gL2.glActiveTexture(n);
                    this.alphaTexture.bind((GL)gL2);
                    gL2.glMatrixMode(5890);
                    gL2.glLoadIdentity();
                    gL2.glScaled(transform.HScale, transform.VScale, 1.0);
                    gL2.glTranslated(transform.HShift, transform.VShift, 0.0);
                    sectorGeometry.renderMultiTexture(drawContext, n2);
                }
                sectorGeometry.endRendering(drawContext);
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.ExceptionWhileRenderingLayer", this.getClass().getName()), exception);
        }
        finally {
            drawContext.getSurfaceGeometry().endRendering(drawContext);
            gL2.glActiveTexture(n);
            gL2.glMatrixMode(5890);
            gL2.glPopMatrix();
            gL2.glDisable(3553);
            if (bl) {
                gL2.glActiveTexture(33985);
                gL2.glMatrixMode(5890);
                gL2.glPopMatrix();
                gL2.glDisable(3553);
            }
            gL2.glActiveTexture(33984);
            gL2.glMatrixMode(5890);
            gL2.glPopMatrix();
            gL2.glDisable(3553);
            gL2.glTexEnvf(8960, 8704, 8448.0f);
            if (drawContext.isPickingMode()) {
                gL2.glTexEnvf(8960, 34176, 5890.0f);
                gL2.glTexEnvf(8960, 34161, 8448.0f);
            }
            gL2.glPopAttrib();
        }
    }

    private static void fillByteBuffer(ByteBuffer byteBuffer, byte by) {
        for (int i = 0; i < byteBuffer.capacity(); ++i) {
            byteBuffer.put(by);
        }
    }

    protected void initAlphaTexture(DrawContext drawContext, int n) {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)(n * n));
        SurfaceTileRenderer.fillByteBuffer(byteBuffer, (byte)-1);
        GL gL = drawContext.getGL();
        TextureData textureData = new TextureData(gL.getGLProfile(), 6406, n, n, 0, 6406, 5121, false, false, false, byteBuffer.rewind(), null);
        this.alphaTexture = TextureIO.newTexture((TextureData)textureData);
        this.alphaTexture.bind(gL);
        this.alphaTexture.setTexParameteri(gL, 10240, 9728);
        this.alphaTexture.setTexParameteri(gL, 10241, 9728);
        this.alphaTexture.setTexParameteri(gL, 10242, 33069);
        this.alphaTexture.setTexParameteri(gL, 10243, 33069);
    }

    protected void initOutlineTexture(DrawContext drawContext, int n) {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)(n * n));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                byte by = i == 0 || j == 0 || i == n - 1 || j == n - 1 ? (byte)-1 : 0;
                byteBuffer.put(i * n + j, by);
            }
        }
        GL gL = drawContext.getGL();
        TextureData textureData = new TextureData(gL.getGLProfile(), 6409, n, n, 0, 6409, 5121, false, false, false, byteBuffer.rewind(), null);
        this.outlineTexture = TextureIO.newTexture((TextureData)textureData);
        this.outlineTexture.bind(gL);
        this.outlineTexture.setTexParameteri(gL, 10240, 9728);
        this.outlineTexture.setTexParameteri(gL, 10241, 9728);
        this.outlineTexture.setTexParameteri(gL, 10242, 33071);
        this.outlineTexture.setTexParameteri(gL, 10243, 33071);
    }

    protected static class Transform {
        double HScale;
        double VScale;
        double HShift;
        double VShift;
        double rotationDegrees;

        protected Transform() {
        }
    }
}

