/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.util.texture.TextureCoords;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceIcon;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;

public class SurfaceIcons
extends SurfaceIcon {
    private Iterable<? extends LatLon> locations;

    public SurfaceIcons(Object object, Iterable<? extends LatLon> iterable) {
        super(object);
        this.setLocations(iterable);
    }

    public Iterable<? extends LatLon> getLocations() {
        return this.locations;
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        this.locations = iterable;
        this.onPropertyChanged();
    }

    @Override
    protected List<Sector> computeSectors(DrawContext drawContext) {
        if (this.locations == null || !this.locations.iterator().hasNext()) {
            return null;
        }
        Sector sector = Sector.boundingSector(this.locations);
        double d = Math.min(sector.getMinLatitude().cos(), sector.getMaxLatitude().cos());
        d = Math.max(d, 0.01);
        Rectangle2D.Double double_ = this.computeDrawDimension(drawContext, sector.getCentroid());
        double d2 = Math.sqrt(((RectangularShape)double_).getWidth() * ((RectangularShape)double_).getWidth() + ((RectangularShape)double_).getHeight() * ((RectangularShape)double_).getHeight());
        double d3 = d2 / 2.0 / drawContext.getGlobe().getRadius();
        double d4 = d2 / 2.0 / drawContext.getGlobe().getRadius() / d;
        Angle angle = sector.getMinLatitude().subtractRadians(d3);
        Angle angle2 = sector.getMaxLatitude().addRadians(d3);
        Angle angle3 = sector.getMinLongitude().subtractRadians(d4);
        Angle angle4 = sector.getMaxLongitude().addRadians(d3);
        return this.computeNormalizedSectors(new Sector(angle, angle2, angle3, angle4));
    }

    @Override
    protected void drawIcon(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (this.locations == null) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glMatrixMode(5888);
        double d = 1.0;
        TextureCoords textureCoords = new TextureCoords(0.0f, 0.0f, 1.0f, 1.0f);
        if (!this.isMaintainAppearance()) {
            d = this.computeDrawScale(drawContext, surfaceTileDrawContext, null);
        }
        Iterable<? extends LatLon> iterable = this.computeDrawLocations(drawContext, surfaceTileDrawContext);
        for (LatLon latLon : iterable) {
            gL2.glPushMatrix();
            if (this.isMaintainAppearance()) {
                d = this.computeDrawScale(drawContext, surfaceTileDrawContext, latLon);
            }
            this.applyDrawTransform(drawContext, surfaceTileDrawContext, latLon, d);
            gL2.glScaled((double)this.imageWidth, (double)this.imageHeight, 1.0);
            drawContext.drawUnitQuad(textureCoords);
            gL2.glPopMatrix();
        }
    }

    protected Iterable<? extends LatLon> computeDrawLocations(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        double d = Math.pow(this.computeSafeRadius((DrawContext)drawContext, (SurfaceTileDrawContext)surfaceTileDrawContext).degrees, 2.0);
        for (LatLon latLon : this.getLocations()) {
            if (!(this.computeLocationDistanceDegreesSquared(surfaceTileDrawContext.getSector(), latLon) <= d)) continue;
            arrayList.add(latLon);
        }
        return arrayList;
    }

    protected Angle computeSafeRadius(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        double d = this.computeDrawPixelSize(drawContext, surfaceTileDrawContext);
        Angle angle = this.computeSectorRadius(surfaceTileDrawContext.getSector());
        Angle angle2 = this.computeIconRadius(drawContext, d, surfaceTileDrawContext.getSector());
        return angle.add(angle2);
    }

    protected Angle computeSectorRadius(Sector sector) {
        double d = sector.getDeltaLatRadians();
        double d2 = sector.getDeltaLonRadians();
        return Angle.fromRadians(Math.sqrt(d * d + d2 * d2) / 2.0);
    }

    protected Angle computeIconRadius(DrawContext drawContext, double d, Sector sector) {
        double d2 = Math.min(sector.getMinLatitude().cos(), sector.getMaxLatitude().cos());
        if (d2 < 0.001) {
            return Angle.POS180;
        }
        Rectangle2D.Double double_ = this.computeDrawDimension(d);
        double d3 = ((RectangularShape)double_).getHeight() / drawContext.getGlobe().getRadius();
        double d4 = ((RectangularShape)double_).getWidth() / drawContext.getGlobe().getRadius() / d2;
        return Angle.fromRadians(Math.sqrt(d3 * d3 + d4 * d4) / 2.0);
    }

    protected double computeLocationDistanceDegreesSquared(Sector sector, LatLon latLon) {
        double d = this.computeHemisphereOffset(sector, latLon);
        double d2 = latLon.getLatitude().degrees - sector.getCentroid().getLatitude().degrees;
        double d3 = latLon.getLongitude().degrees - sector.getCentroid().getLongitude().degrees + d;
        return d2 * d2 + d3 * d3;
    }
}

