/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationRenderer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.logging.Level;
import javax.media.opengl.GL2;

public class BasicAnnotationRenderer
implements AnnotationRenderer {
    protected PickSupport pickSupport = new PickSupport();

    protected static boolean isAnnotationValid(Annotation annotation, boolean bl) {
        if (annotation == null || annotation.getText() == null) {
            return false;
        }
        if (bl && annotation instanceof Locatable) {
            return ((Locatable)((Object)annotation)).getPosition() != null;
        }
        return true;
    }

    @Override
    public void pick(DrawContext drawContext, Iterable<Annotation> iterable, Point point, Layer layer) {
        this.drawMany(drawContext, iterable, layer);
    }

    @Override
    public void pick(DrawContext drawContext, Annotation annotation, Vec4 vec4, Point point, Layer layer) {
        if (!BasicAnnotationRenderer.isAnnotationValid(annotation, false)) {
            return;
        }
        this.drawOne(drawContext, annotation, vec4, layer);
    }

    @Override
    public void render(DrawContext drawContext, Iterable<Annotation> iterable, Layer layer) {
        this.drawMany(drawContext, iterable, layer);
    }

    @Override
    public void render(DrawContext drawContext, Annotation annotation, Vec4 vec4, Layer layer) {
        if (!BasicAnnotationRenderer.isAnnotationValid(annotation, false)) {
            return;
        }
        this.drawOne(drawContext, annotation, vec4, layer);
    }

    protected void drawMany(DrawContext drawContext, Iterable<Annotation> iterable, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.AnnotationIterator");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<Annotation> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        double d = drawContext.getView().getEyePosition().getElevation();
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            if (!BasicAnnotationRenderer.isAnnotationValid(annotation, true) || !annotation.getAttributes().isVisible() || drawContext.isPickingMode() && !this.isAtPickRange(drawContext, annotation) || d < annotation.getMinActiveAltitude() || d > annotation.getMaxActiveAltitude()) continue;
            double d2 = 1.0;
            if (annotation instanceof Locatable) {
                Vec4 vec4 = this.getAnnotationDrawPoint(drawContext, annotation);
                if (vec4 == null) continue;
                d2 = annotation.isAlwaysOnTop() ? 0.0 : drawContext.getView().getEyePoint().distanceTo3(vec4);
            }
            drawContext.addOrderedRenderable(new OrderedAnnotation(annotation, layer, d2));
        }
    }

    protected void drawOne(DrawContext drawContext, Annotation annotation, Vec4 vec4, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (!annotation.getAttributes().isVisible()) {
            return;
        }
        if (drawContext.isPickingMode() && !this.isAtPickRange(drawContext, annotation)) {
            return;
        }
        double d = drawContext.getView().getEyePosition().getElevation();
        if (d < annotation.getMinActiveAltitude() || d > annotation.getMaxActiveAltitude()) {
            return;
        }
        double d2 = 1.0;
        if (annotation instanceof Locatable) {
            if (vec4 == null) {
                Position position = ((Locatable)((Object)annotation)).getPosition();
                if (!drawContext.getVisibleSector().contains(position.getLatitude(), position.getLongitude())) {
                    return;
                }
                vec4 = this.getAnnotationDrawPoint(drawContext, annotation);
                if (vec4 == null) {
                    return;
                }
            }
            if (!drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
                return;
            }
            double d3 = drawContext.getView().getHorizonDistance();
            double d4 = d2 = annotation.isAlwaysOnTop() ? 0.0 : drawContext.getView().getEyePoint().distanceTo3(vec4);
            if (d2 > d3) {
                return;
            }
        }
        drawContext.addOrderedRenderable(new OrderedAnnotation(annotation, layer, d2));
    }

    protected boolean isAtPickRange(DrawContext drawContext, Annotation annotation) {
        Rectangle rectangle = annotation.getBounds(drawContext);
        return rectangle != null && drawContext.getPickFrustums().intersectsAny(rectangle);
    }

    protected Vec4 getAnnotationDrawPoint(DrawContext drawContext, Annotation annotation) {
        Vec4 vec4 = null;
        if (annotation instanceof Locatable) {
            Position position = ((Locatable)((Object)annotation)).getPosition();
            if (position.getElevation() < drawContext.getGlobe().getMaxElevation()) {
                vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(position.getLatitude(), position.getLongitude(), position.getElevation());
            }
            if (vec4 == null) {
                vec4 = drawContext.getGlobe().computePointFromPosition(position);
            }
        }
        return vec4;
    }

    protected void beginDrawAnnotations(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 63749;
        oGLStackHandler.pushAttrib(gL2, n);
        oGLStackHandler.pushProjectionIdentity(gL2);
        gL2.glOrtho(0.0, (double)drawContext.getView().getViewport().width, 0.0, (double)drawContext.getView().getViewport().height, -1.0, 1.0);
        oGLStackHandler.pushTextureIdentity(gL2);
        oGLStackHandler.pushModelviewIdentity(gL2);
        gL2.glEnable(3008);
        gL2.glAlphaFunc(516, 0.0f);
        if (!drawContext.isDeepPickingEnabled()) {
            gL2.glEnable(2929);
        }
        gL2.glDepthMask(false);
        gL2.glDisable(2896);
        gL2.glDisable(2884);
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(3042);
            OGLUtil.applyBlending(gL2, true);
        } else {
            this.pickSupport.beginPicking(drawContext);
        }
    }

    protected void endDrawAnnotations(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
        }
        oGLStackHandler.pop(gL2);
    }

    protected class OrderedAnnotation
    implements OrderedRenderable {
        protected Annotation annotation;
        protected double eyeDistance;
        protected Layer layer;

        public OrderedAnnotation(Annotation annotation, double d) {
            this.annotation = annotation;
            this.eyeDistance = d;
        }

        public OrderedAnnotation(Annotation annotation, Layer layer, double d) {
            this.annotation = annotation;
            this.eyeDistance = d;
            this.layer = layer;
        }

        @Override
        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void render(DrawContext drawContext) {
            OGLStackHandler oGLStackHandler = new OGLStackHandler();
            BasicAnnotationRenderer.this.beginDrawAnnotations(drawContext, oGLStackHandler);
            try {
                this.doRender(drawContext, this);
                while (drawContext.peekOrderedRenderables() instanceof OrderedAnnotation) {
                    OrderedAnnotation orderedAnnotation = (OrderedAnnotation)drawContext.pollOrderedRenderables();
                    this.doRender(drawContext, orderedAnnotation);
                }
            }
            catch (WWRuntimeException wWRuntimeException) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingAnnotation", wWRuntimeException);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingAnnotation", exception);
            }
            finally {
                BasicAnnotationRenderer.this.endDrawAnnotations(drawContext, oGLStackHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pick(DrawContext drawContext, Point point) {
            OGLStackHandler oGLStackHandler = new OGLStackHandler();
            BasicAnnotationRenderer.this.pickSupport.clearPickList();
            BasicAnnotationRenderer.this.beginDrawAnnotations(drawContext, oGLStackHandler);
            try {
                this.annotation.setPickSupport(BasicAnnotationRenderer.this.pickSupport);
                this.doRender(drawContext, this);
                while (drawContext.peekOrderedRenderables() instanceof OrderedAnnotation) {
                    OrderedAnnotation orderedAnnotation = (OrderedAnnotation)drawContext.pollOrderedRenderables();
                    orderedAnnotation.annotation.setPickSupport(BasicAnnotationRenderer.this.pickSupport);
                    this.doRender(drawContext, orderedAnnotation);
                }
            }
            catch (WWRuntimeException wWRuntimeException) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhilePickingAnnotation", wWRuntimeException);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhilePickingAnnotation", exception);
            }
            finally {
                BasicAnnotationRenderer.this.endDrawAnnotations(drawContext, oGLStackHandler);
                BasicAnnotationRenderer.this.pickSupport.resolvePick(drawContext, point, this.layer);
                BasicAnnotationRenderer.this.pickSupport.clearPickList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRender(DrawContext drawContext, OrderedAnnotation orderedAnnotation) {
            Layer layer = drawContext.getCurrentLayer();
            try {
                drawContext.setCurrentLayer(orderedAnnotation.layer);
                orderedAnnotation.annotation.renderNow(drawContext);
            }
            finally {
                drawContext.setCurrentLayer(layer);
            }
        }
    }
}

