/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.ogc.kml.KMLAlias;
import gov.nasa.worldwind.ogc.kml.KMLBalloonStyle;
import gov.nasa.worldwind.ogc.kml.KMLBoundary;
import gov.nasa.worldwind.ogc.kml.KMLCamera;
import gov.nasa.worldwind.ogc.kml.KMLChange;
import gov.nasa.worldwind.ogc.kml.KMLCoordinatesParser;
import gov.nasa.worldwind.ogc.kml.KMLCreate;
import gov.nasa.worldwind.ogc.kml.KMLData;
import gov.nasa.worldwind.ogc.kml.KMLDelete;
import gov.nasa.worldwind.ogc.kml.KMLDocument;
import gov.nasa.worldwind.ogc.kml.KMLExtendedData;
import gov.nasa.worldwind.ogc.kml.KMLFolder;
import gov.nasa.worldwind.ogc.kml.KMLGroundOverlay;
import gov.nasa.worldwind.ogc.kml.KMLIcon;
import gov.nasa.worldwind.ogc.kml.KMLIconStyle;
import gov.nasa.worldwind.ogc.kml.KMLImagePyramid;
import gov.nasa.worldwind.ogc.kml.KMLItemIcon;
import gov.nasa.worldwind.ogc.kml.KMLLabelStyle;
import gov.nasa.worldwind.ogc.kml.KMLLatLonAltBox;
import gov.nasa.worldwind.ogc.kml.KMLLatLonBox;
import gov.nasa.worldwind.ogc.kml.KMLLineString;
import gov.nasa.worldwind.ogc.kml.KMLLineStyle;
import gov.nasa.worldwind.ogc.kml.KMLLinearRing;
import gov.nasa.worldwind.ogc.kml.KMLLink;
import gov.nasa.worldwind.ogc.kml.KMLListStyle;
import gov.nasa.worldwind.ogc.kml.KMLLocation;
import gov.nasa.worldwind.ogc.kml.KMLLod;
import gov.nasa.worldwind.ogc.kml.KMLLookAt;
import gov.nasa.worldwind.ogc.kml.KMLModel;
import gov.nasa.worldwind.ogc.kml.KMLMultiGeometry;
import gov.nasa.worldwind.ogc.kml.KMLNetworkLink;
import gov.nasa.worldwind.ogc.kml.KMLNetworkLinkControl;
import gov.nasa.worldwind.ogc.kml.KMLOrientation;
import gov.nasa.worldwind.ogc.kml.KMLPair;
import gov.nasa.worldwind.ogc.kml.KMLPhotoOverlay;
import gov.nasa.worldwind.ogc.kml.KMLPlacemark;
import gov.nasa.worldwind.ogc.kml.KMLPoint;
import gov.nasa.worldwind.ogc.kml.KMLPolyStyle;
import gov.nasa.worldwind.ogc.kml.KMLPolygon;
import gov.nasa.worldwind.ogc.kml.KMLRegion;
import gov.nasa.worldwind.ogc.kml.KMLResourceMap;
import gov.nasa.worldwind.ogc.kml.KMLScale;
import gov.nasa.worldwind.ogc.kml.KMLSchema;
import gov.nasa.worldwind.ogc.kml.KMLSchemaData;
import gov.nasa.worldwind.ogc.kml.KMLScreenOverlay;
import gov.nasa.worldwind.ogc.kml.KMLSimpleData;
import gov.nasa.worldwind.ogc.kml.KMLSimpleField;
import gov.nasa.worldwind.ogc.kml.KMLSnippet;
import gov.nasa.worldwind.ogc.kml.KMLStyle;
import gov.nasa.worldwind.ogc.kml.KMLStyleMap;
import gov.nasa.worldwind.ogc.kml.KMLStyleUrl;
import gov.nasa.worldwind.ogc.kml.KMLTimeSpan;
import gov.nasa.worldwind.ogc.kml.KMLTimeStamp;
import gov.nasa.worldwind.ogc.kml.KMLUpdate;
import gov.nasa.worldwind.ogc.kml.KMLVec2;
import gov.nasa.worldwind.ogc.kml.KMLViewVolume;
import gov.nasa.worldwind.ogc.kml.gx.GXParserContext;
import gov.nasa.worldwind.util.xml.BasicXMLEventParserContext;
import gov.nasa.worldwind.util.xml.atom.AtomParserContext;
import gov.nasa.worldwind.util.xml.xal.XALParserContext;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;

public class KMLParserContext
extends BasicXMLEventParserContext {
    protected KMLCoordinatesParser coordinatesParser;
    protected static QName COORDINATES = new QName("Coordinates");
    protected static final String[] StringFields = new String[]{"address", "altitudeMode", "begin", "bgColor", "color", "colorMode", "cookie", "description", "displayMode", "displayName", "end", "expires", "gridOrigin", "href", "httpQuery", "key", "labelColor", "linkDescription", "linkName", "listItemType", "message", "name", "phoneNumber", "refreshMode", "schemaUrl", "shape", "snippet", "sourceHref", "state", "targetHref", "text", "textColor", "type", "value", "viewFormat", "viewRefreshMode", "when", "DocumentSource"};
    protected static final String[] DoubleFields = new String[]{"altitude", "bottomFov", "east", "heading", "latitude", "leftFov", "longitude", "maxAltitude", "minAltitude", "minFadeExtent", "maxFadeExtent", "minLodPixels", "maxLodPixels", "minRefreshPeriod", "maxSessionLength", "near", "north", "range", "refreshInterval", "rightFov", "roll", "rotation", "scale", "south", "tilt", "topFov", "viewRefreshTime", "viewBoundScale", "west", "width", "x", "y", "z"};
    protected static final String[] IntegerFields = new String[]{"drawOrder", "maxHeight", "maxLines", "maxSnippetLines", "maxWidth", "tileSize"};
    protected static final String[] BooleanFields = new String[]{"extrude", "fill", "flyToView", "open", "outline", "refreshVisibility", "tessellate", "visibility"};

    public KMLParserContext(String string) {
        this(null, string);
    }

    public KMLParserContext(XMLEventReader xMLEventReader, String string) {
        super(xMLEventReader, string != null ? string : "http://www.opengis.net/kml/2.2");
    }

    public KMLParserContext(KMLParserContext kMLParserContext) {
        super(kMLParserContext);
    }

    @Override
    protected void initializeParsers() {
        super.initializeParsers();
        this.parsers.put(COORDINATES, new KMLCoordinatesParser());
        this.initializeVersion2dot2Parsers();
        this.initializeCompanionParsers();
        this.initializeVersion2dot1Parsers();
        this.initializeVersion2dot0Parsers();
    }

    protected void initializeVersion2dot2Parsers() {
        this.initializeParsers("http://www.opengis.net/kml/2.2");
        this.initializeParsers("http://earth.google.com/kml/2.2");
    }

    protected void initializeParsers(String string) {
        this.parsers.put(new QName(string, "Alias"), new KMLAlias(string));
        this.parsers.put(new QName(string, "BalloonStyle"), new KMLBalloonStyle(string));
        this.parsers.put(new QName(string, "Camera"), new KMLCamera(string));
        this.parsers.put(new QName(string, "Change"), new KMLChange(string));
        this.parsers.put(new QName(string, "coordinates"), this.getCoordinatesParser());
        this.parsers.put(new QName(string, "Create"), new KMLCreate(string));
        this.parsers.put(new QName(string, "Data"), new KMLData(string));
        this.parsers.put(new QName(string, "Delete"), new KMLDelete(string));
        this.parsers.put(new QName(string, "Document"), new KMLDocument(string));
        this.parsers.put(new QName(string, "ExtendedData"), new KMLExtendedData(string));
        this.parsers.put(new QName(string, "Folder"), new KMLFolder(string));
        this.parsers.put(new QName(string, "GroundOverlay"), new KMLGroundOverlay(string));
        this.parsers.put(new QName(string, "Icon"), new KMLIcon(string));
        this.parsers.put(new QName(string, "IconStyle"), new KMLIconStyle(string));
        this.parsers.put(new QName(string, "ImagePyramid"), new KMLImagePyramid(string));
        this.parsers.put(new QName(string, "innerBoundaryIs"), new KMLBoundary(string));
        this.parsers.put(new QName(string, "ItemIcon"), new KMLItemIcon(string));
        this.parsers.put(new QName(string, "hotSpot"), new KMLVec2(string));
        this.parsers.put(new QName(string, "LabelStyle"), new KMLLabelStyle(string));
        this.parsers.put(new QName(string, "LatLonBox"), new KMLLatLonBox(string));
        this.parsers.put(new QName(string, "LatLonAltBox"), new KMLLatLonAltBox(string));
        this.parsers.put(new QName(string, "LinearRing"), new KMLLinearRing(string));
        this.parsers.put(new QName(string, "LineString"), new KMLLineString(string));
        this.parsers.put(new QName(string, "LineStyle"), new KMLLineStyle(string));
        this.parsers.put(new QName(string, "Link"), new KMLLink(string));
        this.parsers.put(new QName(string, "linkSnippet"), new KMLSnippet(string));
        this.parsers.put(new QName(string, "ListStyle"), new KMLListStyle(string));
        this.parsers.put(new QName(string, "Location"), new KMLLocation(string));
        this.parsers.put(new QName(string, "Lod"), new KMLLod(string));
        this.parsers.put(new QName(string, "LookAt"), new KMLLookAt(string));
        this.parsers.put(new QName(string, "Model"), new KMLModel(string));
        this.parsers.put(new QName(string, "MultiGeometry"), new KMLMultiGeometry(string));
        this.parsers.put(new QName(string, "NetworkLink"), new KMLNetworkLink(string));
        this.parsers.put(new QName(string, "NetworkLinkControl"), new KMLNetworkLinkControl(string));
        this.parsers.put(new QName(string, "Orientation"), new KMLOrientation(string));
        this.parsers.put(new QName(string, "outerBoundaryIs"), new KMLBoundary(string));
        this.parsers.put(new QName(string, "overlayXY"), new KMLVec2(string));
        this.parsers.put(new QName(string, "Pair"), new KMLPair(string));
        this.parsers.put(new QName(string, "PhotoOverlay"), new KMLPhotoOverlay(string));
        this.parsers.put(new QName(string, "Placemark"), new KMLPlacemark(string));
        this.parsers.put(new QName(string, "Point"), new KMLPoint(string));
        this.parsers.put(new QName(string, "Polygon"), new KMLPolygon(string));
        this.parsers.put(new QName(string, "PolyStyle"), new KMLPolyStyle(string));
        this.parsers.put(new QName(string, "Region"), new KMLRegion(string));
        this.parsers.put(new QName(string, "ResourceMap"), new KMLResourceMap(string));
        this.parsers.put(new QName(string, "rotationXY"), new KMLVec2(string));
        this.parsers.put(new QName(string, "Scale"), new KMLScale(string));
        this.parsers.put(new QName(string, "Schema"), new KMLSchema(string));
        this.parsers.put(new QName(string, "SchemaData"), new KMLSchemaData(string));
        this.parsers.put(new QName(string, "ScreenOverlay"), new KMLScreenOverlay(string));
        this.parsers.put(new QName(string, "screenXY"), new KMLVec2(string));
        this.parsers.put(new QName(string, "SimpleData"), new KMLSimpleData(string));
        this.parsers.put(new QName(string, "SimpleField"), new KMLSimpleField(string));
        this.parsers.put(new QName(string, "size"), new KMLVec2(string));
        this.parsers.put(new QName(string, "Snippet"), new KMLSnippet(string));
        this.parsers.put(new QName(string, "Style"), new KMLStyle(string));
        this.parsers.put(new QName(string, "StyleMap"), new KMLStyleMap(string));
        this.parsers.put(new QName(string, "styleUrl"), new KMLStyleUrl(string));
        this.parsers.put(new QName(string, "TimeSpan"), new KMLTimeSpan(string));
        this.parsers.put(new QName(string, "TimeStamp"), new KMLTimeStamp(string));
        this.parsers.put(new QName(string, "Update"), new KMLUpdate(string));
        this.parsers.put(new QName(string, "Url"), new KMLLink(string));
        this.parsers.put(new QName(string, "ViewVolume"), new KMLViewVolume(string));
        this.addStringParsers(string, StringFields);
        this.addDoubleParsers(string, DoubleFields);
        this.addIntegerParsers(string, IntegerFields);
        this.addBooleanParsers(string, BooleanFields);
    }

    protected void initializeVersion2dot1Parsers() {
        this.initializeParsers("http://earth.google.com/kml/2.1");
    }

    protected void initializeVersion2dot0Parsers() {
        String string = "http://earth.google.com/kml/2.0";
        for (Map.Entry entry : this.parsers.entrySet()) {
            this.parsers.put(new QName(string, ((QName)entry.getKey()).getLocalPart()), entry.getValue());
        }
    }

    protected void initializeCompanionParsers() {
        this.parsers.putAll(GXParserContext.getDefaultParsers());
        this.parsers.putAll(AtomParserContext.getDefaultParsers());
        this.parsers.putAll(XALParserContext.getDefaultParsers());
    }

    public KMLCoordinatesParser getCoordinatesParser() {
        if (this.coordinatesParser == null) {
            this.coordinatesParser = (KMLCoordinatesParser)this.getParser(COORDINATES);
        }
        return this.coordinatesParser;
    }
}

