/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada;

import gov.nasa.worldwind.ogc.collada.ColladaAbstractObject;
import gov.nasa.worldwind.ogc.collada.ColladaFloatArray;
import gov.nasa.worldwind.ogc.collada.ColladaParam;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class ColladaAccessor
extends ColladaAbstractObject {
    protected List<ColladaParam> params = new ArrayList<ColladaParam>();

    public ColladaAccessor(String string) {
        super(string);
    }

    public String getSource() {
        return (String)this.getField("source");
    }

    public int getCount() {
        Integer n = (Integer)this.getField("count");
        return n != null ? n : 0;
    }

    public int getOffset() {
        Integer n = (Integer)this.getField("offset");
        return n != null ? n : 0;
    }

    public int getStride() {
        Integer n = (Integer)this.getField("stride");
        return n != null ? n : 1;
    }

    public int size() {
        int n = 0;
        for (ColladaParam colladaParam : this.params) {
            if (WWUtil.isEmpty(colladaParam.getName())) continue;
            ++n;
        }
        return n * this.getCount();
    }

    public float[] getFloats() {
        String string = this.getSource();
        if (string == null) {
            return null;
        }
        Object object = this.getRoot().resolveReference(string);
        if (object == null) {
            return null;
        }
        if (!(object instanceof ColladaFloatArray)) {
            return null;
        }
        float[] fArray = ((ColladaFloatArray)object).getFloats();
        if (fArray == null) {
            return null;
        }
        int n = this.getOffset();
        int n2 = 0;
        int n3 = this.getStride();
        if (n3 > this.params.size()) {
            n2 = n3 - this.params.size();
        }
        float[] fArray2 = new float[this.size()];
        int n4 = 0;
        block0: for (int i = 0; i < this.getCount() && n < fArray.length; n += n2, ++i) {
            for (ColladaParam colladaParam : this.params) {
                if (n >= fArray.length) continue block0;
                if (!WWUtil.isEmpty(colladaParam.getName())) {
                    fArray2[n4++] = fArray[n];
                }
                ++n;
            }
        }
        return fArray2;
    }

    @Override
    public void setField(String string, Object object) {
        if (string.equals("param")) {
            this.params.add((ColladaParam)object);
        } else {
            super.setField(string, object);
        }
    }

    @Override
    protected void doAddEventAttribute(Attribute attribute, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        boolean bl;
        String string = attribute.getName().getLocalPart();
        boolean bl2 = bl = "count".equals(string) || "offset".equals(string) || "stride".equals(string);
        if (bl) {
            this.setField(string, (Object)WWUtil.makeInteger(attribute.getValue()));
        } else {
            super.doAddEventAttribute(attribute, xMLEventParserContext, xMLEvent, objectArray);
        }
    }
}

