/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class OGCBoundingBox
extends AbstractXMLEventParser {
    private String crs;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private double resx;
    private double resy;

    public static OGCBoundingBox createFromStrings(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        OGCBoundingBox oGCBoundingBox = new OGCBoundingBox(null);
        try {
            oGCBoundingBox.crs = string;
            oGCBoundingBox.minx = Double.parseDouble(string2);
            oGCBoundingBox.maxx = Double.parseDouble(string3);
            oGCBoundingBox.miny = Double.parseDouble(string4);
            oGCBoundingBox.maxy = Double.parseDouble(string5);
            oGCBoundingBox.resx = string6 != null && !string6.equals("") ? Double.parseDouble(string6) : 0.0;
            oGCBoundingBox.resy = string7 != null && !string7.equals("") ? Double.parseDouble(string7) : 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            String string8 = Logging.getMessage("XML.ImproperDataType");
            Logging.logger().severe(string8);
            throw numberFormatException;
        }
        return oGCBoundingBox;
    }

    public OGCBoundingBox(String string) {
        super(string);
    }

    @Override
    protected void doParseEventAttributes(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) {
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Object object;
            Attribute attribute = iterator.next();
            if (attribute.getName().getLocalPart().equals("CRS") && attribute.getValue() != null) {
                object = attribute.getValue();
                if (object == null) continue;
                this.setCRS((String)object);
                continue;
            }
            if (attribute.getName().getLocalPart().equals("minx") && attribute.getValue() != null) {
                object = WWUtil.convertStringToDouble(attribute.getValue());
                if (object == null) continue;
                this.setMinx((Double)object);
                continue;
            }
            if (attribute.getName().getLocalPart().equals("miny") && attribute.getValue() != null) {
                object = WWUtil.convertStringToDouble(attribute.getValue());
                if (object == null) continue;
                this.setMiny((Double)object);
                continue;
            }
            if (attribute.getName().getLocalPart().equals("maxx") && attribute.getValue() != null) {
                object = WWUtil.convertStringToDouble(attribute.getValue());
                if (object == null) continue;
                this.setMaxx((Double)object);
                continue;
            }
            if (attribute.getName().getLocalPart().equals("maxy") && attribute.getValue() != null) {
                object = WWUtil.convertStringToDouble(attribute.getValue());
                if (object == null) continue;
                this.setMaxy((Double)object);
                continue;
            }
            if (attribute.getName().getLocalPart().equals("resx") && attribute.getValue() != null) {
                object = WWUtil.convertStringToDouble(attribute.getValue());
                if (object == null) continue;
                this.setResx((Double)object);
                continue;
            }
            if (!attribute.getName().getLocalPart().equals("resy") || attribute.getValue() == null || (object = WWUtil.convertStringToDouble(attribute.getValue())) == null) continue;
            this.setResy((Double)object);
        }
    }

    public String getCRS() {
        return this.crs;
    }

    protected void setCRS(String string) {
        this.crs = string;
    }

    public double getMinx() {
        return this.minx;
    }

    protected void setMinx(double d) {
        this.minx = d;
    }

    public double getMaxx() {
        return this.maxx;
    }

    protected void setMaxx(double d) {
        this.maxx = d;
    }

    public double getMiny() {
        return this.miny;
    }

    protected void setMiny(double d) {
        this.miny = d;
    }

    public double getMaxy() {
        return this.maxy;
    }

    protected void setMaxy(double d) {
        this.maxy = d;
    }

    public double getResx() {
        return this.resx;
    }

    protected void setResx(double d) {
        this.resx = d;
    }

    public double getResy() {
        return this.resy;
    }

    protected void setResy(double d) {
        this.resy = d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.crs);
        stringBuilder.append(": minx = ");
        stringBuilder.append(this.minx);
        stringBuilder.append(" miny = ");
        stringBuilder.append(this.miny);
        stringBuilder.append(" maxx = ");
        stringBuilder.append(this.maxx);
        stringBuilder.append(" maxy = ");
        stringBuilder.append(this.maxy);
        stringBuilder.append(" resx = ");
        stringBuilder.append(this.resx);
        stringBuilder.append(" resy = ");
        stringBuilder.append(this.resy);
        return stringBuilder.toString();
    }
}

