/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.vpf.VPFBasicFeatureClassFactory;
import gov.nasa.worldwind.formats.vpf.VPFBoundingBox;
import gov.nasa.worldwind.formats.vpf.VPFBufferedRecordData;
import gov.nasa.worldwind.formats.vpf.VPFCoverage;
import gov.nasa.worldwind.formats.vpf.VPFDatabase;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClass;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClassSchema;
import gov.nasa.worldwind.formats.vpf.VPFLibrary;
import gov.nasa.worldwind.formats.vpf.VPFRecord;
import gov.nasa.worldwind.formats.vpf.VPFTableReader;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.FileFilter;
import java.nio.ByteBuffer;

public class VPFUtils {
    public static VPFBufferedRecordData readTable(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            return null;
        }
        try {
            VPFTableReader vPFTableReader = new VPFTableReader();
            return vPFTableReader.read(file);
        }
        catch (WWRuntimeException wWRuntimeException) {
            return null;
        }
    }

    public static VPFDatabase readDatabase(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            return null;
        }
        try {
            return VPFDatabase.fromFile(file.getPath());
        }
        catch (WWRuntimeException wWRuntimeException) {
            return null;
        }
    }

    public static VPFLibrary readLibrary(VPFDatabase vPFDatabase, String string) {
        if (vPFDatabase == null) {
            String string2 = Logging.getMessage("nullValue.DatabaseIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            return VPFLibrary.fromFile(vPFDatabase, string);
        }
        catch (WWRuntimeException wWRuntimeException) {
            return null;
        }
    }

    public static VPFCoverage readCoverage(VPFLibrary vPFLibrary, String string) {
        if (vPFLibrary == null) {
            String string2 = Logging.getMessage("nullValue.LibraryIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            return VPFCoverage.fromFile(vPFLibrary, string);
        }
        catch (WWRuntimeException wWRuntimeException) {
            return null;
        }
    }

    public static VPFFeatureClass[] readFeatureClasses(VPFCoverage vPFCoverage, FileFilter fileFilter) {
        if (vPFCoverage == null) {
            String string = Logging.getMessage("nullValue.CoverageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fileFilter == null) {
            String string = Logging.getMessage("nullValue.FilterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        VPFFeatureClassSchema[] vPFFeatureClassSchemaArray = vPFCoverage.getFeatureClasses(fileFilter);
        VPFFeatureClass[] vPFFeatureClassArray = new VPFFeatureClass[vPFFeatureClassSchemaArray.length];
        VPFBasicFeatureClassFactory vPFBasicFeatureClassFactory = new VPFBasicFeatureClassFactory();
        for (int i = 0; i < vPFFeatureClassSchemaArray.length; ++i) {
            vPFFeatureClassArray[i] = vPFBasicFeatureClassFactory.createFromSchema(vPFCoverage, vPFFeatureClassSchemaArray[i]);
        }
        return vPFFeatureClassArray;
    }

    public static String readDelimitedText(ByteBuffer byteBuffer, char c) {
        byte by;
        int n;
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = byteBuffer.remaining();
        for (n = 0; n < n2 && c != (char)(by = byteBuffer.get()); ++n) {
            stringBuilder.append((char)by);
        }
        return n < n2 ? stringBuilder.toString().trim() : null;
    }

    public static void checkAndSetValue(VPFRecord vPFRecord, String string, String string2, AVList aVList) {
        Object object;
        if (vPFRecord == null) {
            String string3 = Logging.getMessage("nullValue.RecordIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (aVList == null) {
            String string6 = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        if (vPFRecord.hasValue(string) && (object = vPFRecord.getValue(string)) != null) {
            aVList.setValue(string2, object);
        }
    }

    public static VPFBoundingBox getExtent(VPFRecord vPFRecord) {
        if (vPFRecord == null) {
            String string = Logging.getMessage("nullValue.RecordIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new VPFBoundingBox(((Number)vPFRecord.getValue("xmin")).doubleValue(), ((Number)vPFRecord.getValue("ymin")).doubleValue(), ((Number)vPFRecord.getValue("xmax")).doubleValue(), ((Number)vPFRecord.getValue("ymax")).doubleValue());
    }

    public static String getFeatureTypeName(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = WWIO.getSuffix(string);
        if (string3 == null) {
            return null;
        }
        string3 = "." + string3;
        if (string3.equalsIgnoreCase(".pft")) {
            return "P";
        }
        if (string3.equalsIgnoreCase(".lft")) {
            return "L";
        }
        if (string3.equalsIgnoreCase(".aft")) {
            return "A";
        }
        if (string3.equalsIgnoreCase(".tft")) {
            return "T";
        }
        if (string3.equalsIgnoreCase(".cft")) {
            return "C";
        }
        return null;
    }
}

