/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class GeoSymAttributeConverter {
    protected static String TYPE_POINT = "Point";
    protected static String TYPE_LINE_PLAIN = "LinePlain";
    protected static String TYPE_LINE_COMPLEX = "LineComplex";
    protected static String TYPE_AREA_PLAIN = "AreaPlain";
    protected static String TYPE_AREA_PATTERN = "AreaPattern";
    protected static final String OUT_DIR = "gsac-out";
    protected static final String OUT_ATTRS_PATH = "gsac-out/geosym/symasgn/ascii/geosym-line-area-attr.csv";
    protected static final String OUT_PATTERNS_PATH = "gsac-out/geosym/graphics/bin";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            GeoSymAttributeConverter.printUsage();
            return;
        }
        File[] fileArray = new File(stringArray[0]).listFiles();
        PrintStream printStream = null;
        try {
            File file = new File(OUT_ATTRS_PATH);
            file.getParentFile().mkdirs();
            printStream = new PrintStream(new FileOutputStream(file));
            printStream.println("# GeoSym line and area attributes");
            printStream.println("# GeoSym code, Feature type, Line width, Line color, Stipple pattern, Stipple factor, Fill color");
            printStream.println("#");
            for (File file2 : fileArray) {
                if (!file2.getName().toUpperCase().endsWith(".CGM")) continue;
                CGMFile cGMFile = new CGMFile(file2);
                if (!cGMFile.type.equals(TYPE_POINT)) {
                    printStream.println(cGMFile.toRecordString());
                }
                if (!cGMFile.type.equals(TYPE_AREA_PATTERN)) continue;
                GeoSymAttributeConverter.writeAreaPattern(cGMFile);
            }
            System.out.println("Done.");
            WWIO.closeStream(printStream, OUT_ATTRS_PATH);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            WWIO.closeStream(printStream, OUT_ATTRS_PATH);
        }
    }

    protected static void printUsage() {
        System.out.println("GeoSymAttributeConverter");
        System.out.println();
        System.out.println("Converts GeoSym line attributes, area attributes, and area patterns into a form usable by");
        System.out.println("World Wind VPF shapes. Outputs to \"gsac-out\" a comma-separated-value file");
        System.out.println("containing line and area attributes for VPF line and area shapes, and PNG files");
        System.out.println("containing area patterns for VPF area shapes.");
        System.out.println();
        System.out.println("Usage: java -cp worldwind.jar gov.nasa.worldwind.formats.vpf.GeoSymAttributeConverter [full path to \"GeoSymEd2Final/GRAPHICS/CTEXT\"]");
        System.out.println();
    }

    protected static void writeAreaPattern(CGMFile cGMFile) {
        String string = cGMFile.file.getName().toUpperCase().replace(".CGM", ".png");
        File file = new File(OUT_PATTERNS_PATH, string);
        try {
            file.getParentFile().mkdirs();
            ImageIO.write((RenderedImage)cGMFile.getPattern(), "png", file);
        }
        catch (Exception exception) {
            System.out.println("Could not save pattern " + string);
        }
    }

    protected static class CGMFile {
        protected File file;
        protected String content;
        protected String type;
        protected int[] colorTable;
        protected int[] patternTable;
        protected int lineCount = 0;
        protected int polylineCount = 0;
        protected int shapeCount = 0;
        protected int polygonCount = 0;
        protected int patternCount = 0;
        protected int pentagonCount = 0;
        protected int lineElementCount = 0;
        protected int lineColorIndex = -1;
        protected int fillColorIndex = -1;
        protected int lineWidth = -1;
        protected double scale = 1.0;
        protected short stipplePattern;
        protected int stippleFactor = 0;
        protected String edgeVis = "";

        public CGMFile(File file) {
            this.file = file;
            this.processCGMFile(file);
            if (this.type.equals(TYPE_LINE_COMPLEX)) {
                this.processStipplePattern();
            }
        }

        protected void processCGMFile(File file) {
            this.content = this.readTextFile(file).replaceAll("\r", "");
            String[] stringArray = this.content.split("\n");
            String string = "";
            for (String string2 : stringArray) {
                if (!string2.endsWith(";")) {
                    string2 = string2.trim() + " ";
                }
                if (!(string = string + string2).endsWith(";")) continue;
                this.processCGMLine(string);
                string = "";
            }
            this.type = this.getType();
        }

        protected void processCGMLine(String string) {
            if (string.startsWith("LINE ")) {
                if (this.getNumValues(string) == 4) {
                    ++this.lineCount;
                } else {
                    ++this.polylineCount;
                }
            } else if (string.startsWith("CIRCLE ")) {
                ++this.shapeCount;
            } else if (string.startsWith("ELLIPARC ")) {
                ++this.shapeCount;
            } else if (string.startsWith("POLYGONSET ")) {
                ++this.shapeCount;
            } else if (string.startsWith("POLYGON ")) {
                ++this.polygonCount;
                if (this.getNumValues(string) == 12) {
                    ++this.pentagonCount;
                }
            } else if (string.startsWith("PATTABLE ")) {
                ++this.patternCount;
                this.patternTable = this.getIntegerValues(string);
            } else if (string.startsWith("LINECOLR ")) {
                this.lineColorIndex = this.getIntegerValue(string);
            } else if (string.startsWith("FILLCOLR ")) {
                this.fillColorIndex = this.getIntegerValue(string);
            } else if (string.startsWith("LINEWIDTH ")) {
                this.lineWidth = this.getIntegerValue(string);
            } else if (string.contains("LineComponentElement")) {
                ++this.lineElementCount;
            } else if (string.startsWith("EDGEVIS ")) {
                this.edgeVis = this.getStringValue(string);
            } else if (string.startsWith("COLRTABLE ")) {
                this.colorTable = this.getIntegerValues(string);
            } else if (string.startsWith("COLRTABLE ")) {
                this.colorTable = this.getIntegerValues(string);
            } else if (string.startsWith("SCALEMODE ")) {
                this.scale = this.getScaleValue(string);
            }
        }

        protected int getIntegerValue(String string) {
            return Integer.parseInt(this.getStringValue(string));
        }

        protected int[] getIntegerValues(String string) {
            string = string.substring(0, string.length() - 1);
            String[] stringArray = string.split(" ");
            int[] nArray = new int[stringArray.length - 1];
            int n = 0;
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= 0) continue;
                nArray[n++] = Integer.parseInt(stringArray[i]);
            }
            return nArray;
        }

        protected String getStringValue(String string) {
            string = string.substring(0, string.length() - 1);
            return string.split(" ")[1];
        }

        protected double getScaleValue(String string) {
            string = string.substring(0, string.length() - 1);
            String[] stringArray = string.split(" ");
            return Double.parseDouble(stringArray[2]);
        }

        protected int getNumValues(String string) {
            return string.split(" ").length - 1;
        }

        protected String getColor(int n) {
            if (n < 0 || n * 3 + 3 > this.colorTable.length - 1) {
                return "#FFFFFF";
            }
            String string = String.format("#%02x%02x%02x", this.colorTable[n * 3 + 1], this.colorTable[n * 3 + 2], this.colorTable[n * 3 + 3]);
            if (string.length() > 7) {
                System.out.println("Color error: idx: " + n + ", color: " + string + ", components: " + String.format("%d %d %d", this.colorTable[n * 3 + 1], this.colorTable[n * 3 + 2], this.colorTable[n * 3 + 3]));
            }
            return string;
        }

        protected String getType() {
            if (this.patternCount > 0) {
                return TYPE_AREA_PATTERN;
            }
            if (this.polygonCount == 1 && this.pentagonCount == 1 && this.edgeVis.equals("OFF") && this.lineCount == 0 && this.polylineCount == 0 && this.shapeCount == 0) {
                return TYPE_AREA_PLAIN;
            }
            if (this.lineElementCount > 0) {
                return TYPE_LINE_COMPLEX;
            }
            if (this.lineCount == 1 && this.polylineCount == 0 && this.shapeCount == 0 && this.polygonCount == 0) {
                return TYPE_LINE_PLAIN;
            }
            return TYPE_POINT;
        }

        protected void processStipplePattern() {
            String[] stringArray;
            double d = 0.0;
            double d2 = 0.0;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (String string : stringArray = this.content.split("\n")) {
                if (string.contains("Component.1.Element")) {
                    if (!(d > 0.0)) continue;
                    arrayList.add(d);
                    d2 += d;
                    d = 0.0;
                    continue;
                }
                if (string.startsWith("APSATTR \"ElementType\"")) continue;
                if (string.startsWith("APSATTR \"ElementLength\"")) {
                    d = Double.parseDouble(this.getLastValue(string));
                    continue;
                }
                if (string.contains("Component.2") || string.startsWith("BEGAPS \"IC_ViewportTable\"")) break;
            }
            if (d > 0.0) {
                arrayList.add(d);
                d2 += d;
            }
            double d3 = d2 / 16.0;
            String string = "";
            char c = '1';
            for (Double d4 : arrayList) {
                int n = (int)Math.round(d4 / d3);
                for (int i = 0; i < n; ++i) {
                    string = string + c;
                }
                c = c == '1' ? (char)'0' : '1';
            }
            if (string.length() == 0 || !string.contains("0") || !string.contains("1")) {
                string = "1111110001111000";
            }
            while (string.length() < 16) {
                string = string + string.substring(string.length() - 1);
            }
            string = string.substring(0, 16);
            this.stipplePattern = (short)Integer.parseInt(string, 2);
            this.stippleFactor = (int)Math.max(1.0, Math.min(3.0, Math.ceil(d2 / 6.0)));
        }

        protected String getLastValue(String string) {
            String[] stringArray = string.replaceAll("\"", "").replaceAll(";", "").split("\\s");
            return stringArray[stringArray.length - 1];
        }

        protected BufferedImage getPattern() {
            if (this.patternTable == null) {
                return null;
            }
            Color color = Color.decode(this.getColor(this.fillColorIndex));
            int n = this.patternTable[1];
            int n2 = this.patternTable[2];
            int n3 = 4;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (this.patternTable[n3++] <= 0) continue;
                    bufferedImage.setRGB(j, i, color.getRGB());
                }
            }
            return bufferedImage;
        }

        public String toRecordString() {
            String string = this.file.getName().split("\\.")[0];
            String string2 = this.type;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            if (this.type.equals(TYPE_AREA_PATTERN) || this.type.equals(TYPE_AREA_PLAIN)) {
                string7 = this.getColor(this.fillColorIndex);
            } else if (this.type.equals(TYPE_LINE_PLAIN) || this.type.equals(TYPE_LINE_COMPLEX)) {
                string3 = this.lineWidth > 0 ? String.format("%.1f", (double)this.lineWidth * this.scale).replace(',', '.') : ".5";
                String string8 = string4 = this.lineColorIndex >= 0 ? this.getColor(this.lineColorIndex) : this.getColor(this.fillColorIndex);
                if (this.type.equals(TYPE_LINE_COMPLEX)) {
                    string5 = String.format("#%04x", this.stipplePattern);
                    string6 = "" + this.stippleFactor;
                }
            }
            return String.format("%s,%s,%s,%s,%s,%s,%s", string, string2, string3, string4, string5, string6, string7);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String readTextFile(File file) {
            if (file == null) {
                String string = Logging.getMessage("nullValue.FileIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                    stringBuilder.append(System.getProperty("line.separator"));
                }
            }
            catch (IOException iOException) {
                String string;
                try {
                    String string2 = Logging.getMessage("generic.ExceptionAttemptingToReadFile", file.getPath());
                    Logging.logger().log(Level.SEVERE, string2);
                    string = null;
                }
                catch (Throwable throwable) {
                    WWIO.closeStream(bufferedReader, file.getPath());
                    throw throwable;
                }
                WWIO.closeStream(bufferedReader, file.getPath());
                return string;
            }
            WWIO.closeStream(bufferedReader, file.getPath());
            return stringBuilder.toString();
        }
    }
}

