/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.Version;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.BufferWrapperRaster;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.formats.tiff.TiffIFDEntry;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class GeotiffWriter {
    private RandomAccessFile targetFile;
    private FileChannel theChannel;
    private static final int INTEGER_SIZEOF = 4;
    private static final int BufferedImage_TYPE_ELEVATION_SHORT16 = 9001;
    private static final int BufferedImage_TYPE_ELEVATION_FLOAT32 = 9002;

    public GeotiffWriter(String string) throws IOException {
        if (null == string || 0 == string.trim().length()) {
            String string2 = Logging.getMessage("generic.FileNameIsMissing");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.commonInitializer(new File(string));
    }

    public GeotiffWriter(File file) throws IOException {
        if (null == file) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.commonInitializer(file);
    }

    private void commonInitializer(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File(System.getProperty("user.dir"));
        }
        if (!file2.canWrite()) {
            String string = Logging.getMessage("generic.FolderNoWritePermission", file2.getAbsolutePath());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.targetFile = new RandomAccessFile(file, "rw");
        this.theChannel = this.targetFile.getChannel();
    }

    public void close() {
        try {
            this.targetFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(BufferedImage bufferedImage) throws IOException {
        this.write(bufferedImage, null);
    }

    public void write(DataRaster dataRaster) throws IOException, IllegalArgumentException {
        if (null == dataRaster) {
            String string = Logging.getMessage("nullValue.RasterIsNull");
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        if (dataRaster.getWidth() <= 0) {
            String string = Logging.getMessage("generic.InvalidWidth", dataRaster.getWidth());
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        if (dataRaster.getHeight() <= 0) {
            String string = Logging.getMessage("generic.InvalidHeight", dataRaster.getHeight());
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        if (dataRaster instanceof BufferedImageRaster) {
            this.write(((BufferedImageRaster)dataRaster).getBufferedImage(), dataRaster);
        } else if (dataRaster instanceof BufferWrapperRaster) {
            this.writeRaster((BufferWrapperRaster)dataRaster);
        }
    }

    public void write(BufferedImage bufferedImage, AVList aVList) throws IOException {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (0 == bufferedImage.getWidth() || 0 == bufferedImage.getHeight()) {
            String string = Logging.getMessage("generic.InvalidImageSize", bufferedImage.getWidth(), bufferedImage.getHeight());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == aVList || 0 == aVList.getValues().size()) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().finest(Logging.getMessage("GeotiffWriter.GeoKeysMissing", string));
            aVList = new AVListImpl();
        } else {
            this.validateParameters(aVList, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        int n = bufferedImage.getType();
        if (0 == n) {
            Object object;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl = false;
            if (null != bufferedImage.getColorModel()) {
                object = bufferedImage.getColorModel();
                n2 = ((ColorModel)object).getNumColorComponents();
                n3 = ((ColorModel)object).getNumComponents();
                n4 = ((ColorModel)object).getPixelSize();
                bl = ((ColorModel)object).hasAlpha();
                ColorSpace colorSpace = ((ColorModel)object).getColorSpace();
                if (null != colorSpace) {
                    n6 = colorSpace.getType();
                }
            }
            if (null != bufferedImage.getSampleModel()) {
                object = bufferedImage.getSampleModel();
                n5 = ((SampleModel)object).getDataType();
            }
            if (n5 == 4 && n4 == 32 && n3 == 1) {
                n = 9002;
            } else if (n5 == 2 && n4 == 16 && n3 == 1) {
                n = 9001;
            } else if (1003 == n6 && n4 == 8) {
                n = 10;
            } else if (n5 == 1 && 1003 == n6 && n4 == 16) {
                n = 11;
            } else if (5 == n6 && n4 == 24 && n2 == 3) {
                n = 5;
            } else if (5 == n6 && bl && n4 == 32 && n3 == 4) {
                n = 6;
            }
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.writeColorImage(bufferedImage, aVList);
                break;
            }
            case 10: 
            case 11: {
                this.writeGrayscaleImage(bufferedImage, aVList);
                break;
            }
            case 9001: 
            case 9002: {
                String string = Logging.getMessage("GeotiffWriter.FeatureNotImplementedd", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            default: {
                ColorModel colorModel = bufferedImage.getColorModel();
                SampleModel sampleModel = bufferedImage.getSampleModel();
                StringBuffer stringBuffer = new StringBuffer(Logging.getMessage("GeotiffWriter.UnsupportedType", n));
                stringBuffer.append("\n");
                stringBuffer.append("NumBands=").append(sampleModel.getNumBands()).append("\n");
                stringBuffer.append("NumDataElements=").append(sampleModel.getNumDataElements()).append("\n");
                stringBuffer.append("NumColorComponents=").append(colorModel.getNumColorComponents()).append("\n");
                stringBuffer.append("NumComponents=").append(colorModel.getNumComponents()).append("\n");
                stringBuffer.append("PixelSize=").append(colorModel.getPixelSize()).append("\n");
                stringBuffer.append("hasAlpha=").append(colorModel.hasAlpha());
                String string = stringBuffer.toString();
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
        }
    }

    private void writeColorImage(BufferedImage bufferedImage, AVList aVList) throws IOException {
        int n;
        Object[] objectArray;
        int n2 = bufferedImage.getRaster().getNumBands();
        this.writeTiffHeader();
        int n3 = bufferedImage.getHeight();
        int n4 = bufferedImage.getWidth();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n4 * n2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = (int)this.theChannel.position();
            nArray[i] = n4 * n2;
            objectArray = writableRaster.getPixels(0, i, bufferedImage.getWidth(), 1, (int[])null);
            byteBuffer.clear();
            for (n = 0; n < n4 * n2; ++n) {
                this.putUnsignedByte(byteBuffer, objectArray[n]);
            }
            byteBuffer.flip();
            this.theChannel.write(byteBuffer);
        }
        ArrayList<TiffIFDEntry> arrayList = new ArrayList<TiffIFDEntry>(10);
        arrayList.add(new TiffIFDEntry(256, 4, 1L, n4));
        arrayList.add(new TiffIFDEntry(257, 4, 1L, n3));
        arrayList.add(new TiffIFDEntry(284, 3, 1L, 1L));
        arrayList.add(new TiffIFDEntry(277, 3, 1L, n2));
        arrayList.add(new TiffIFDEntry(259, 4, 1L, 1L));
        arrayList.add(new TiffIFDEntry(262, 3, 1L, 2L));
        arrayList.add(new TiffIFDEntry(274, 3, 1L, 1L));
        long l = this.theChannel.position();
        objectArray = new short[n2];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = 8;
        }
        this.theChannel.write(ByteBuffer.wrap(this.getBytes((short[])objectArray)));
        arrayList.add(new TiffIFDEntry(258, 3, n2, l));
        l = this.theChannel.position();
        byteBuffer = ByteBuffer.allocateDirect(nArray2.length * 4);
        for (int n5 : nArray2) {
            byteBuffer.putInt(n5);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        arrayList.add(new TiffIFDEntry(273, 4, nArray2.length, l));
        arrayList.add(new TiffIFDEntry(278, 4, 1L, 1L));
        l = this.theChannel.position();
        byteBuffer.clear();
        for (int n5 : nArray) {
            byteBuffer.putInt(n5);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        arrayList.add(new TiffIFDEntry(279, 4, nArray.length, l));
        this.appendGeoTiff(arrayList, aVList);
        this.writeIFDs(arrayList);
    }

    private void writeGrayscaleImage(BufferedImage bufferedImage, AVList aVList) throws IOException {
        int n = bufferedImage.getType();
        int n2 = 11 == n ? 16 : 8;
        int n3 = bufferedImage.getSampleModel().getNumBands();
        int n4 = n3 * n2 / 8;
        this.writeTiffHeader();
        int n5 = bufferedImage.getHeight();
        int n6 = bufferedImage.getWidth();
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n6 * n4);
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i = 0; i < n5; ++i) {
            int n7;
            nArray2[i] = (int)this.theChannel.position();
            nArray[i] = n6 * n4;
            int[] nArray3 = writableRaster.getPixels(0, i, bufferedImage.getWidth(), 1, (int[])null);
            byteBuffer.clear();
            if (11 == n) {
                for (n7 = 0; n7 < n6 * n3; ++n7) {
                    this.putUnsignedShort(byteBuffer, nArray3[n7]);
                }
            } else if (10 == n) {
                for (n7 = 0; n7 < n6 * n3; ++n7) {
                    this.putUnsignedByte(byteBuffer, nArray3[n7]);
                }
            }
            byteBuffer.flip();
            this.theChannel.write(byteBuffer);
        }
        ArrayList<TiffIFDEntry> arrayList = new ArrayList<TiffIFDEntry>(10);
        arrayList.add(new TiffIFDEntry(256, 4, 1L, n6));
        arrayList.add(new TiffIFDEntry(257, 4, 1L, n5));
        arrayList.add(new TiffIFDEntry(258, 3, 1L, n2));
        arrayList.add(new TiffIFDEntry(259, 4, 1L, 1L));
        arrayList.add(new TiffIFDEntry(262, 3, 1L, 1L));
        arrayList.add(new TiffIFDEntry(339, 3, 1L, 1L));
        long l = this.theChannel.position();
        byteBuffer = ByteBuffer.allocateDirect(nArray2.length * 4);
        for (int n8 : nArray2) {
            byteBuffer.putInt(n8);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        arrayList.add(new TiffIFDEntry(273, 4, nArray2.length, l));
        arrayList.add(new TiffIFDEntry(277, 3, 1L, n3));
        arrayList.add(new TiffIFDEntry(278, 4, 1L, 1L));
        l = this.theChannel.position();
        byteBuffer.clear();
        for (int n8 : nArray) {
            byteBuffer.putInt(n8);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        arrayList.add(new TiffIFDEntry(279, 4, nArray.length, l));
        this.appendGeoTiff(arrayList, aVList);
        this.writeIFDs(arrayList);
    }

    private void writeTiffHeader() throws IOException {
        byte[] byArray = new byte[]{77, 77, 0, 42, 0, 0, 0, 0};
        this.theChannel.write(ByteBuffer.wrap(byArray));
    }

    private void appendGeoTiff(ArrayList<TiffIFDEntry> arrayList, AVList aVList) throws IOException, IllegalArgumentException {
        Object object;
        Object object2;
        if (null == aVList || 0 == aVList.getEntries().size()) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().finest(Logging.getMessage("GeotiffWriter.GeoKeysMissing", string));
            return;
        }
        long l = this.theChannel.position();
        if (aVList.hasKey("gov.nasa.worldwind.avkey.DisplayName") && null != (object2 = aVList.getStringValue("gov.nasa.worldwind.avkey.DisplayName")) && 0 < ((String)object2).trim().length()) {
            l = this.theChannel.position();
            object = ((String)object2).trim().getBytes();
            this.theChannel.write(ByteBuffer.wrap(object));
            arrayList.add(new TiffIFDEntry(269, 2, ((byte[])object).length, l));
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.Description") && null != (object2 = aVList.getStringValue("gov.nasa.worldwind.avkey.Description")) && 0 < ((String)object2).trim().length()) {
            l = this.theChannel.position();
            object = ((String)object2).trim().getBytes();
            this.theChannel.write(ByteBuffer.wrap(object));
            arrayList.add(new TiffIFDEntry(270, 2, ((byte[])object).length, l));
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.Version") && null != (object2 = aVList.getStringValue("gov.nasa.worldwind.avkey.Version")) && 0 < ((String)object2).trim().length()) {
            l = this.theChannel.position();
            object = ((String)object2).trim().getBytes();
            this.theChannel.write(ByteBuffer.wrap(object));
            arrayList.add(new TiffIFDEntry(305, 2, ((byte[])object).length, l));
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.DateTime") && null != (object2 = aVList.getStringValue("gov.nasa.worldwind.avkey.DateTime")) && 0 < ((String)object2).trim().length()) {
            l = this.theChannel.position();
            object = ((String)object2).getBytes();
            this.theChannel.write(ByteBuffer.wrap(object));
            arrayList.add(new TiffIFDEntry(306, 2, ((byte[])object).length, l));
        }
        if (aVList.hasKey("gov.nasa.worldwind.avKey.Sector")) {
            if (aVList.hasKey("gov.nasa.worldwind.avkey.PixelWidth") && aVList.hasKey("gov.nasa.worldwind.avkey.PixelHeight")) {
                l = this.theChannel.position();
                object2 = new double[]{(Double)aVList.getValue("gov.nasa.worldwind.avkey.PixelWidth"), (Double)aVList.getValue("gov.nasa.worldwind.avkey.PixelHeight"), GeotiffWriter.isElevation(aVList) ? 1.0 : 0.0};
                object = this.getBytes((double[])object2);
                this.theChannel.write(ByteBuffer.wrap(object));
                arrayList.add(new TiffIFDEntry(33550, 12, ((Object)object2).length, l));
            }
            if (aVList.hasKey("gov.nasa.worldwind.avkey.Width") && aVList.hasKey("gov.nasa.worldwind.avkey.Height")) {
                l = this.theChannel.position();
                double d = ((Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width")).intValue();
                double d2 = ((Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height")).intValue();
                Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
                double[] dArray = new double[]{0.0, 0.0, 0.0, sector.getMinLongitude().degrees, sector.getMaxLatitude().degrees, 0.0, d - 1.0, 0.0, 0.0, sector.getMaxLongitude().degrees, sector.getMaxLatitude().degrees, 0.0, d - 1.0, d2 - 1.0, 0.0, sector.getMaxLongitude().degrees, sector.getMinLatitude().degrees, 0.0, 0.0, d2 - 1.0, 0.0, sector.getMinLongitude().degrees, sector.getMinLatitude().degrees, 0.0};
                byte[] byArray = this.getBytes(dArray);
                this.theChannel.write(ByteBuffer.wrap(byArray));
                arrayList.add(new TiffIFDEntry(33922, 12, dArray.length, l));
            }
            if (aVList.hasKey("gov.nasa.worldwind.avkey.MissingDataFlag") || aVList.hasKey("gov.nasa.worldwind.avkey.MissingDataValue")) {
                l = this.theChannel.position();
                Object object3 = aVList.hasKey("gov.nasa.worldwind.avkey.MissingDataFlag") ? aVList.getValue("gov.nasa.worldwind.avkey.MissingDataFlag") : aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue");
                object = "" + object3 + "\u0000";
                byte[] byArray = object.getBytes();
                this.theChannel.write(ByteBuffer.wrap(byArray));
                arrayList.add(new TiffIFDEntry(42113, 2, byArray.length, l));
            }
            if (aVList.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem")) {
                String string = aVList.getStringValue("gov.nasa.worldwind.avkey.CoordinateSystem");
                if ("gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(string)) {
                    if (GeotiffWriter.isElevation(aVList)) {
                        this.writeGeographicElevationGeoKeys(arrayList, aVList);
                    } else {
                        this.writeGeographicImageGeoKeys(arrayList, aVList);
                    }
                } else {
                    if ("gov.nasa.worldwind.avkey.CoordinateSystem.Projected".equals(string)) {
                        object = Logging.getMessage("GeotiffWriter.FeatureNotImplementedd", string);
                        Logging.logger().severe((String)object);
                        throw new IllegalArgumentException((String)object);
                    }
                    object = Logging.getMessage("GeotiffWriter.UnknownCoordinateSystem", string);
                    Logging.logger().severe((String)object);
                    throw new IllegalArgumentException((String)object);
                }
            }
        }
    }

    protected void validateParameters(AVList aVList, int n, int n2) throws IllegalArgumentException {
        String string;
        int n3;
        if (null == aVList || 0 == aVList.getValues().size()) {
            String string2 = Logging.getMessage("nullValue.AVListIsNull");
            String string3 = Logging.getMessage("GeotiffWriter.GeoKeysMissing", string2);
            Logging.logger().finest(string3);
            throw new IllegalArgumentException(string3);
        }
        if (n <= 0 || n2 <= 0) {
            String string4 = Logging.getMessage("generic.InvalidImageSize", n, n2);
            Logging.logger().finest(string4);
            throw new IllegalArgumentException(string4);
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.Width")) {
            n3 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width");
            if (n3 != n) {
                String string5 = Logging.getMessage("GeotiffWriter.ImageWidthMismatch", n3, n);
                Logging.logger().severe(string5);
                throw new IllegalArgumentException(string5);
            }
        } else {
            aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.Height")) {
            n3 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height");
            if (n3 != n2) {
                String string6 = Logging.getMessage("GeotiffWriter.ImageHeightMismatch", n3, n2);
                Logging.logger().severe(string6);
                throw new IllegalArgumentException(string6);
            }
        } else {
            aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
        }
        Sector sector = null;
        if (aVList.hasKey("gov.nasa.worldwind.avKey.Sector")) {
            sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        }
        if (null == sector) {
            String string7 = Logging.getMessage("GeotiffWriter.NoSectorSpecified");
            Logging.logger().severe(string7);
            throw new IllegalArgumentException(string7);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem")) {
            string = Logging.getMessage("GeotiffWriter.GeoKeysMissing", "gov.nasa.worldwind.avkey.CoordinateSystem");
            Logging.logger().finest(string);
            aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic");
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Projection.EPSG.Code")) {
            if (GeotiffWriter.isGeographic(aVList)) {
                aVList.setValue("gov.nasa.worldwind.avkey.Projection.EPSG.Code", 4326);
            } else {
                string = Logging.getMessage("GeotiffWriter.GeoKeysMissing", "gov.nasa.worldwind.avkey.Projection.EPSG.Code");
                Logging.logger().finest(string);
                throw new IllegalArgumentException(string);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelWidth")) {
            if (GeotiffWriter.isGeographic(aVList)) {
                double d = sector.getDeltaLonDegrees() / (double)n;
                aVList.setValue("gov.nasa.worldwind.avkey.PixelWidth", d);
            } else {
                string = Logging.getMessage("GeotiffWriter.GeoKeysMissing", "gov.nasa.worldwind.avkey.PixelWidth");
                Logging.logger().finest(string);
                throw new IllegalArgumentException(string);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelHeight")) {
            if (GeotiffWriter.isGeographic(aVList)) {
                double d = sector.getDeltaLatDegrees() / (double)n2;
                aVList.setValue("gov.nasa.worldwind.avkey.PixelHeight", d);
            } else {
                String string8 = Logging.getMessage("GeotiffWriter.GeoKeysMissing", "gov.nasa.worldwind.avkey.PixelHeight");
                Logging.logger().finest(string8);
                throw new IllegalArgumentException(string8);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            String string9 = Logging.getMessage("GeotiffWriter.GeoKeysMissing", "gov.nasa.worldwind.avkey.PixelFormat");
            Logging.logger().finest(string9);
            throw new IllegalArgumentException(string9);
        }
        Object object = aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat");
        if (!"gov.nasa.worldwind.avkey.Elevation".equals(object) && !"gov.nasa.worldwind.avkey.Image".equals(object)) {
            String string10 = Logging.getMessage("Geotiff.UnknownGeoKeyValue", object, "gov.nasa.worldwind.avkey.PixelFormat");
            Logging.logger().severe(string10);
            throw new IllegalArgumentException(string10);
        }
        if ("gov.nasa.worldwind.avkey.Elevation".equals(aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
            if (!aVList.hasKey("gov.nasa.worldwind.avkey.DataType")) {
                object = Logging.getMessage("GeotiffWriter.GeoKeysMissing", "gov.nasa.worldwind.avkey.DataType");
                Logging.logger().finest((String)object);
                throw new IllegalArgumentException((String)object);
            }
            object = aVList.getStringValue("gov.nasa.worldwind.avkey.DataType");
            if (!"gov.nasa.worldwind.avkey.Float32".equals(object) && !"gov.nasa.worldwind.avkey.Int16".equals(object)) {
                String string11 = Logging.getMessage("Geotiff.UnknownGeoKeyValue", object, "gov.nasa.worldwind.avkey.DataType");
                Logging.logger().severe(string11);
                throw new IllegalArgumentException(string11);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Origin")) {
            object = new LatLon(sector.getMaxLatitude(), sector.getMinLongitude());
            aVList.setValue("gov.nasa.worldwind.avkey.Origin", object);
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.ByteOrder") && !"gov.nasa.worldwind.avkey.BigEndian".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.ByteOrder"))) {
            object = Logging.getMessage("generic.UnrecognizedByteOrder", aVList.getStringValue("gov.nasa.worldwind.avkey.ByteOrder"));
            Logging.logger().severe((String)object);
            throw new IllegalArgumentException((String)object);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.DateTime")) {
            object = String.format("%1$tY:%1$tm:%1$td %tT\u0000", Calendar.getInstance());
            aVList.setValue("gov.nasa.worldwind.avkey.DateTime", object);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Version")) {
            aVList.setValue("gov.nasa.worldwind.avkey.Version", Version.getVersion());
        }
    }

    private static boolean isElevation(AVList aVList) {
        return null != aVList && aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat") && "gov.nasa.worldwind.avkey.Elevation".equals(aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat"));
    }

    private static boolean isImage(AVList aVList) {
        return null != aVList && aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat") && "gov.nasa.worldwind.avkey.Image".equals(aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat"));
    }

    private static boolean isGeographic(AVList aVList) {
        return null != aVList && aVList.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem") && "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(aVList.getValue("gov.nasa.worldwind.avkey.CoordinateSystem"));
    }

    private static boolean isProjected(AVList aVList) {
        return null != aVList && aVList.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem") && "gov.nasa.worldwind.avkey.CoordinateSystem.Projected".equals(aVList.getValue("gov.nasa.worldwind.avkey.CoordinateSystem"));
    }

    private void writeGeographicImageGeoKeys(ArrayList<TiffIFDEntry> arrayList, AVList aVList) throws IOException {
        long l = this.theChannel.position();
        if (GeotiffWriter.isImage(aVList) && GeotiffWriter.isGeographic(aVList)) {
            int n = 4326;
            if (aVList.hasKey("gov.nasa.worldwind.avkey.Projection.EPSG.Code")) {
                n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Projection.EPSG.Code");
            }
            short[] sArray = new short[]{1, 1, 0, 0, 1024, 0, 1, 2, 1025, 0, 1, 1, 2048, 0, 1, (short)(0xFFFF & n), 2054, 0, 1, 9102};
            sArray[3] = (short)(sArray.length / 4);
            byte[] byArray = this.getBytes(sArray);
            this.theChannel.write(ByteBuffer.wrap(byArray));
            arrayList.add(new TiffIFDEntry(34735, 3, sArray.length, l));
        }
    }

    private void writeGeographicElevationGeoKeys(ArrayList<TiffIFDEntry> arrayList, AVList aVList) throws IOException {
        long l = this.theChannel.position();
        if (GeotiffWriter.isElevation(aVList) && GeotiffWriter.isGeographic(aVList)) {
            int n = 4326;
            if (aVList.hasKey("gov.nasa.worldwind.avkey.Projection.EPSG.Code")) {
                n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Projection.EPSG.Code");
            }
            int n2 = 9001;
            if (aVList.hasKey("gov.nasa.worldwind.avkey.ElevationUnit") && "gov.nasa.worldwind.avkey.Unit.Foot".equals(aVList.getValue("gov.nasa.worldwind.avkey.ElevationUnit"))) {
                n2 = 9002;
            }
            int n3 = 1;
            if (aVList.hasKey("gov.nasa.worldwind.avkey.RasterPixel") && "gov.nasa.worldwind.avkey.RasterPixelIsPoint".equals(aVList.getValue("gov.nasa.worldwind.avkey.RasterPixel"))) {
                n3 = 2;
            }
            short[] sArray = new short[]{1, 1, 0, 0, 1024, 0, 1, 2, 1025, 0, 1, (short)(0xFFFF & n3), 2048, 0, 1, (short)(0xFFFF & n), 2054, 0, 1, 9102, 4096, 0, 1, 5030, 4099, 0, 1, (short)(0xFFFF & n2)};
            sArray[3] = (short)(sArray.length / 4);
            byte[] byArray = this.getBytes(sArray);
            this.theChannel.write(ByteBuffer.wrap(byArray));
            arrayList.add(new TiffIFDEntry(34735, 3, sArray.length, l));
        }
    }

    private void writeIFDs(List<TiffIFDEntry> list) throws IOException {
        long l;
        long l2;
        this.theChannel.position(l += (l2 = (l = this.theChannel.position()) % 4L) == 0L ? 0L : 4L - l2);
        Collections.sort(list);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(list.size() * 12);
        this.putUnsignedShort(byteBuffer, list.size());
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        byteBuffer.clear();
        for (TiffIFDEntry tiffIFDEntry : list) {
            this.putUnsignedShort(byteBuffer, tiffIFDEntry.tag);
            this.putUnsignedShort(byteBuffer, tiffIFDEntry.type);
            this.putUnsignedInt(byteBuffer, tiffIFDEntry.count);
            if (tiffIFDEntry.type == 3 && tiffIFDEntry.count == 1L) {
                this.putUnsignedShort(byteBuffer, (int)tiffIFDEntry.valOffset);
                byteBuffer.putShort((short)0);
                continue;
            }
            this.putUnsignedInt(byteBuffer, tiffIFDEntry.valOffset);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        byteBuffer.clear();
        byteBuffer.putInt(0);
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        this.theChannel.position(4L);
        byteBuffer.clear();
        this.putUnsignedInt(byteBuffer, l);
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
    }

    private void putUnsignedByte(ByteBuffer byteBuffer, int n) {
        byteBuffer.put((byte)(n & 0xFF));
    }

    private void putUnsignedShort(ByteBuffer byteBuffer, int n) {
        byteBuffer.putShort((short)(n & 0xFFFF));
    }

    private void putUnsignedInt(ByteBuffer byteBuffer, long l) {
        byteBuffer.putInt((int)(l & 0xFFFFFFFFL));
    }

    private byte[] getBytes(double[] dArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (double d : dArray) {
                dataOutputStream.writeDouble(d);
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Logging.logger().finest(iOException.getMessage());
            return null;
        }
    }

    private byte[] getBytes(short[] sArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (short s : sArray) {
                dataOutputStream.writeShort(s);
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Logging.logger().finest(iOException.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeRaster(BufferWrapperRaster bufferWrapperRaster) throws IOException, IllegalArgumentException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (bufferWrapperRaster == null) {
            String string = Logging.getMessage("nullValue.RasterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (0 == bufferWrapperRaster.getWidth() || 0 == bufferWrapperRaster.getHeight()) {
            String string = Logging.getMessage("generic.InvalidImageSize", bufferWrapperRaster.getWidth(), bufferWrapperRaster.getHeight());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.validateParameters(bufferWrapperRaster, bufferWrapperRaster.getWidth(), bufferWrapperRaster.getHeight());
        if ("gov.nasa.worldwind.avkey.Elevation".equals(bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
            if ("gov.nasa.worldwind.avkey.Float32".equals(bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.DataType"))) {
                n7 = 1;
                n6 = 1;
                n5 = 3;
                n4 = 1;
                n3 = 32;
            } else {
                if (!"gov.nasa.worldwind.avkey.Int16".equals(bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.DataType"))) {
                    String string = Logging.getMessage("GeotiffWriter.UnsupportedType", bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.DataType"));
                    Logging.logger().severe(string);
                    throw new IllegalArgumentException(string);
                }
                n7 = 1;
                n6 = 1;
                n5 = 2;
                n4 = 1;
                n3 = 16;
            }
        } else {
            if (!"gov.nasa.worldwind.avkey.Image".equals(bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
                String string = Logging.getMessage("GeotiffWriter.UnsupportedType", bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.PixelFormat"));
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if ("gov.nasa.worldwind.avkey.Int8".equals(bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.DataType"))) {
                n7 = 1;
                n6 = 1;
                n5 = 1;
                n4 = 1;
                n3 = 8;
            } else if ("gov.nasa.worldwind.avkey.Int16".equals(bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.DataType"))) {
                n7 = 1;
                n6 = 1;
                n5 = 1;
                n4 = 1;
                n3 = 16;
            } else {
                if (!"gov.nasa.worldwind.avkey.Int32".equals(bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.DataType"))) {
                    String string = Logging.getMessage("GeotiffWriter.UnsupportedType", bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.DataType"));
                    Logging.logger().severe(string);
                    throw new IllegalArgumentException(string);
                }
                n7 = 3;
                n6 = 3;
                n5 = 1;
                n4 = 2;
                n3 = 24;
            }
        }
        int n8 = n7 * n3 / 8;
        this.writeTiffHeader();
        int n9 = bufferWrapperRaster.getHeight();
        int n10 = bufferWrapperRaster.getWidth();
        int[] nArray = new int[n9];
        int[] nArray2 = new int[n9];
        BufferWrapper bufferWrapper = bufferWrapperRaster.getBuffer();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n10 * n8);
        switch (n3) {
            case 8: {
                int n11;
                int n12;
                for (n12 = 0; n12 < n9; ++n12) {
                    nArray2[n12] = (int)this.theChannel.position();
                    nArray[n12] = n10 * n8;
                    byteBuffer.clear();
                    for (n11 = 0; n11 < n10 * n7; ++n11) {
                        byteBuffer.put(bufferWrapper.getByte(n11 + n12 * n10));
                    }
                    byteBuffer.flip();
                    this.theChannel.write(byteBuffer);
                }
                break;
            }
            case 16: {
                int n11;
                int n12;
                for (n12 = 0; n12 < n9; ++n12) {
                    nArray2[n12] = (int)this.theChannel.position();
                    nArray[n12] = n10 * n8;
                    byteBuffer.clear();
                    for (n11 = 0; n11 < n10 * n7; ++n11) {
                        byteBuffer.putShort(bufferWrapper.getShort(n11 + n12 * n10));
                    }
                    byteBuffer.flip();
                    this.theChannel.write(byteBuffer);
                }
                break;
            }
            case 32: {
                int n11;
                int n12;
                for (n12 = 0; n12 < n9; ++n12) {
                    nArray2[n12] = (int)this.theChannel.position();
                    nArray[n12] = n10 * n8;
                    byteBuffer.clear();
                    for (n11 = 0; n11 < n10 * n7; ++n11) {
                        byteBuffer.putFloat(bufferWrapper.getFloat(n11 + n12 * n10));
                    }
                    byteBuffer.flip();
                    this.theChannel.write(byteBuffer);
                }
                break;
            }
            case 24: {
                int n11;
                int n12;
                for (n12 = 0; n12 < n9; ++n12) {
                    nArray2[n12] = (int)this.theChannel.position();
                    nArray[n12] = n10 * n8;
                    byteBuffer.clear();
                    for (n11 = 0; n11 < n10; ++n11) {
                        int n13 = bufferWrapper.getInt(n11 + n12 * n10);
                        byte by = (byte)(0xFF & n13 >> 16);
                        n2 = (byte)(0xFF & n13 >> 8);
                        n = 0xFF & n13;
                        byteBuffer.put(by).put((byte)n2).put((byte)n);
                    }
                    byteBuffer.flip();
                    this.theChannel.write(byteBuffer);
                }
                break;
            }
        }
        ArrayList<TiffIFDEntry> arrayList = new ArrayList<TiffIFDEntry>(10);
        arrayList.add(new TiffIFDEntry(256, 4, 1L, n10));
        arrayList.add(new TiffIFDEntry(257, 4, 1L, n9));
        long l = this.theChannel.position();
        if (24 == n3) {
            short[] sArray = new short[n7];
            for (n2 = 0; n2 < n7; ++n2) {
                sArray[n2] = 8;
            }
            this.theChannel.write(ByteBuffer.wrap(this.getBytes(sArray)));
            arrayList.add(new TiffIFDEntry(258, 3, n7, l));
        } else {
            arrayList.add(new TiffIFDEntry(258, 3, 1L, n3));
        }
        arrayList.add(new TiffIFDEntry(259, 4, 1L, 1L));
        arrayList.add(new TiffIFDEntry(262, 3, 1L, n4));
        arrayList.add(new TiffIFDEntry(277, 3, 1L, n6));
        arrayList.add(new TiffIFDEntry(274, 3, 1L, 1L));
        arrayList.add(new TiffIFDEntry(284, 3, 1L, 1L));
        arrayList.add(new TiffIFDEntry(339, 3, 1L, n5));
        l = this.theChannel.position();
        byteBuffer = ByteBuffer.allocateDirect(nArray2.length * 4);
        for (int n14 : nArray2) {
            byteBuffer.putInt(n14);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        arrayList.add(new TiffIFDEntry(273, 4, nArray2.length, l));
        arrayList.add(new TiffIFDEntry(278, 4, 1L, 1L));
        l = this.theChannel.position();
        byteBuffer.clear();
        int[] nArray3 = nArray;
        n2 = nArray3.length;
        n = 0;
        while (true) {
            int n14;
            if (n >= n2) {
                byteBuffer.flip();
                this.theChannel.write(byteBuffer);
                arrayList.add(new TiffIFDEntry(279, 4, nArray.length, l));
                this.appendGeoTiff(arrayList, bufferWrapperRaster);
                this.writeIFDs(arrayList);
                return;
            }
            n14 = nArray3[n];
            byteBuffer.putInt(n14);
            ++n;
        }
    }
}

