/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFFrameStructure;
import gov.nasa.worldwind.formats.rpf.RPFFrameTransform;
import gov.nasa.worldwind.formats.rpf.RPFNonpolarFrameStructure;
import gov.nasa.worldwind.formats.rpf.RPFZone;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;

class RPFNonpolarFrameTransform
extends RPFFrameTransform {
    private final char zoneCode;
    private final String rpfDataType;
    private final double resolution;
    private final RPFNonpolarFrameStructure frameStructure;

    private RPFNonpolarFrameTransform(char c, String string, double d, RPFNonpolarFrameStructure rPFNonpolarFrameStructure) {
        this.zoneCode = c;
        this.rpfDataType = string;
        this.resolution = d;
        this.frameStructure = rPFNonpolarFrameStructure;
    }

    static RPFNonpolarFrameTransform createNonpolarFrameTransform(char c, String string, double d) {
        if (!RPFZone.isZoneCode(c)) {
            String string2 = Logging.getMessage("RPFZone.UnknownZoneCode", Character.valueOf(c));
            Logging.logger().fine(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null || !RPFDataSeries.isRPFDataType(string)) {
            String string3 = Logging.getMessage("RPFDataSeries.UnkownDataType", string);
            Logging.logger().fine(string3);
            throw new IllegalArgumentException(string3);
        }
        if (d < 0.0) {
            String string4 = Logging.getMessage("generic.ArgumentOutOfRange", string);
            Logging.logger().fine(string4);
            throw new IllegalArgumentException(string4);
        }
        RPFNonpolarFrameStructure rPFNonpolarFrameStructure = RPFNonpolarFrameStructure.computeStructure(c, string, d);
        return new RPFNonpolarFrameTransform(c, string, d, rPFNonpolarFrameStructure);
    }

    public final char getZoneCode() {
        return this.zoneCode;
    }

    public final String getRpfDataType() {
        return this.rpfDataType;
    }

    public final double getResolution() {
        return this.resolution;
    }

    public final RPFFrameStructure getFrameStructure() {
        return this.frameStructure;
    }

    @Override
    public int getFrameNumber(int n, int n2) {
        return RPFNonpolarFrameTransform.frameNumber(n, n2, this.frameStructure.getLongitudinalFrames());
    }

    @Override
    public int getMaximumFrameNumber() {
        return RPFNonpolarFrameTransform.maxFrameNumber(this.frameStructure.getLatitudinalFrames(), this.frameStructure.getLongitudinalFrames());
    }

    @Override
    public int getRows() {
        return this.frameStructure.getLatitudinalFrames();
    }

    @Override
    public int getColumns() {
        return this.frameStructure.getLongitudinalFrames();
    }

    @Override
    public LatLon computeFrameOrigin(int n) {
        if (n < 0 || n > this.getMaximumFrameNumber()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = RPFNonpolarFrameTransform.frameRow(n, this.frameStructure.getLongitudinalFrames());
        int n3 = RPFNonpolarFrameTransform.frameColumn(n, n2, this.frameStructure.getLongitudinalFrames());
        double d = RPFZone.isZoneInUpperHemisphere(this.zoneCode) ? this.frameStructure.getEquatorwardExtent() : this.frameStructure.getPolewardExtent();
        double d2 = RPFNonpolarFrameTransform.frameOriginLatitude(n2, this.frameStructure.getNorthSouthPixelConstant(), this.frameStructure.getPixelRowsPerFrame(), d);
        double d3 = RPFNonpolarFrameTransform.frameOriginLongitude(n3, this.frameStructure.getEastWestPixelConstant(), this.frameStructure.getPixelRowsPerFrame());
        return LatLon.fromDegrees(d2, d3);
    }

    @Override
    public Sector computeFrameCoverage(int n) {
        int n2 = RPFNonpolarFrameTransform.maxFrameNumber(this.frameStructure.getLatitudinalFrames(), this.frameStructure.getLongitudinalFrames());
        if (n < 0 || n > n2) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = RPFNonpolarFrameTransform.frameRow(n, this.frameStructure.getLongitudinalFrames());
        int n4 = RPFNonpolarFrameTransform.frameColumn(n, n3, this.frameStructure.getLongitudinalFrames());
        double d = RPFZone.isZoneInUpperHemisphere(this.zoneCode) ? this.frameStructure.getEquatorwardExtent() : this.frameStructure.getPolewardExtent();
        double d2 = RPFNonpolarFrameTransform.frameOriginLatitude(n3, this.frameStructure.getNorthSouthPixelConstant(), this.frameStructure.getPixelRowsPerFrame(), d);
        double d3 = d2 - RPFNonpolarFrameTransform.frameDeltaLatitude(this.frameStructure.getNorthSouthPixelConstant(), this.frameStructure.getPixelRowsPerFrame());
        double d4 = RPFNonpolarFrameTransform.frameOriginLongitude(n4, this.frameStructure.getEastWestPixelConstant(), this.frameStructure.getPixelRowsPerFrame());
        double d5 = d4 + RPFNonpolarFrameTransform.frameDeltaLongitude(this.frameStructure.getEastWestPixelConstant(), this.frameStructure.getPixelRowsPerFrame());
        return Sector.fromDegrees(d3, d2, d4, d5);
    }

    @Override
    public RPFFrameTransform.RPFImage[] deproject(int n, BufferedImage bufferedImage) {
        RPFFrameTransform.RPFImage[] rPFImageArray = new RPFFrameTransform.RPFImage[1];
        Sector sector = this.computeFrameCoverage(n);
        rPFImageArray[0] = new RPFFrameTransform.RPFImage(sector, bufferedImage);
        return rPFImageArray;
    }

    private static double pixelLatitude_CADRG(double d, int n, double d2) {
        return d - 90.0 / d2 * (double)n;
    }

    private static double pixelLongitude_CADRG(double d, int n, double d2) {
        return d + 360.0 / d2 * (double)n;
    }

    private static double pixelLatitude_CIB(double d, int n, double d2) {
        return d - 90.0 / d2 * ((double)n + 0.5);
    }

    private static double pixelLongitude_CIB(double d, int n, double d2) {
        return d + 360.0 / d2 * ((double)n + 0.5);
    }

    private static int frameRow(double d, double d2, double d3, double d4) {
        return (int)((d - d4) / 90.0 * (d2 / d3));
    }

    private static double frameOriginLatitude(int n, double d, double d2, double d3) {
        return 90.0 / d * d2 * (double)(n + 1) + d3;
    }

    private static int frameColumn(double d, double d2, double d3) {
        return (int)((d + 180.0) / 360.0 * (d2 / d3));
    }

    private static double frameOriginLongitude(int n, double d, double d2) {
        return 360.0 / d * d2 * (double)n - 180.0;
    }

    private static double frameDeltaLatitude(double d, double d2) {
        return 90.0 / d * d2;
    }

    private static double frameDeltaLongitude(double d, double d2) {
        return 360.0 / d * d2;
    }

    private static double normalizedDegreesLongitude(double d) {
        double d2 = d % 360.0;
        return d2 > 180.0 ? d2 - 360.0 : (d2 < -180.0 ? 360.0 + d2 : d2);
    }
}

