/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RPFFrameFileIndexSection;
import gov.nasa.worldwind.formats.rpf.RPFFrameFilename;
import gov.nasa.worldwind.formats.rpf.RPFFrameProperty;
import gov.nasa.worldwind.formats.rpf.RPFTOCFile;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class RPFCrawler {
    public static final String RPF_DIRECTORY = "RPF";
    public static final String RPF_OVERVIEW_EXTENSION = ".OVR";
    public static final String RPF_TOC_EXTENSION = ".TOC";
    private final Thread deadThread = new Thread();
    private final Lock threadLock = new ReentrantLock();
    private volatile Thread thread = null;

    private static String createAbsolutePath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null || string.length() <= 0) continue;
            int n = 0;
            if (string.startsWith("./") || string.startsWith(".\\")) {
                n = 1;
            } else if (!string.startsWith("/") && !string.startsWith("\\")) {
                stringBuilder.append(File.separatorChar);
            }
            int n2 = string.endsWith("/") || string.endsWith("\\") ? string.length() - 1 : string.length();
            stringBuilder.append(string, n, n2);
        }
        if (stringBuilder.length() <= 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    private static List<RPFFrameFileIndexSection.RPFFrameFileIndexRecord> extractRPFRecords(RPFTOCFile rPFTOCFile) {
        LinkedList<RPFFrameFileIndexSection.RPFFrameFileIndexRecord> linkedList = new LinkedList<RPFFrameFileIndexSection.RPFFrameFileIndexRecord>();
        if (rPFTOCFile != null && rPFTOCFile.getFrameFileIndexSection() != null && rPFTOCFile.getFrameFileIndexSection().getFrameFileIndexTable() != null && rPFTOCFile.getFrameFileIndexSection().getFrameFileIndexTable().size() > 0) {
            for (RPFFrameFileIndexSection.RPFFrameFileIndexRecord rPFFrameFileIndexRecord : rPFTOCFile.getFrameFileIndexSection().getFrameFileIndexTable()) {
                if (rPFFrameFileIndexRecord == null || rPFFrameFileIndexRecord.getFrameFileName() == null || rPFFrameFileIndexRecord.getFrameFileName().toUpperCase().endsWith(RPF_OVERVIEW_EXTENSION)) continue;
                linkedList.add(rPFFrameFileIndexRecord);
            }
        }
        return linkedList;
    }

    private static boolean isRPFDirectory(File file) {
        return RPF_DIRECTORY.compareToIgnoreCase(file.getName()) == 0;
    }

    private static boolean isRPFFile(File file) {
        return RPFFrameFilename.isFilename(file.getName().toUpperCase());
    }

    private static boolean isTOCFile(File file) {
        return file.getName().toUpperCase().endsWith(RPF_TOC_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(File file, RPFCrawlerListener rPFCrawlerListener, boolean bl, boolean bl2) {
        this.threadLock.lock();
        try {
            if (bl2 && this.thread == this.deadThread) {
                return;
            }
        }
        finally {
            this.threadLock.unlock();
        }
        File[] fileArray = file.listFiles();
        if (bl) {
            if (fileArray == null) {
                return;
            }
            if (RPFCrawler.isRPFDirectory(file)) {
                this.searchForTOC(fileArray, rPFCrawlerListener, bl2);
            } else {
                this.searchForDirectory(fileArray, rPFCrawlerListener, true, bl2);
            }
        } else {
            if (RPFFrameFilename.isFilename(file.getName().toUpperCase())) {
                rPFCrawlerListener.fileFound(file, false);
            }
            if (fileArray == null) {
                return;
            }
            this.searchForRPF(fileArray, rPFCrawlerListener, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForTOC(File[] fileArray, RPFCrawlerListener rPFCrawlerListener, boolean bl) {
        for (File file : fileArray) {
            this.threadLock.lock();
            try {
                if (bl && this.thread == this.deadThread) {
                    return;
                }
            }
            finally {
                this.threadLock.unlock();
            }
            if (!RPFCrawler.isTOCFile(file)) continue;
            rPFCrawlerListener.fileFound(file, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForDirectory(File[] fileArray, RPFCrawlerListener rPFCrawlerListener, boolean bl, boolean bl2) {
        for (File file : fileArray) {
            this.threadLock.lock();
            try {
                if (bl2 && this.thread == this.deadThread) {
                    return;
                }
            }
            finally {
                this.threadLock.unlock();
            }
            if (!file.isDirectory()) continue;
            this.process(file, rPFCrawlerListener, bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForRPF(File[] fileArray, RPFCrawlerListener rPFCrawlerListener, boolean bl) {
        for (File file : fileArray) {
            this.threadLock.lock();
            try {
                if (bl && this.thread == this.deadThread) {
                    return;
                }
            }
            finally {
                this.threadLock.unlock();
            }
            if (RPFCrawler.isRPFFile(file)) {
                rPFCrawlerListener.fileFound(file, false);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.process(file, rPFCrawlerListener, false, bl);
        }
    }

    public File[] invoke(File file, boolean bl) {
        File file2 = this.validateDirectory(file);
        final ArrayList arrayList = new ArrayList();
        this.process(file2, new RPFCrawlerListener(){

            @Override
            public void fileFound(File file, boolean bl) {
                if (file.exists()) {
                    arrayList.add(file);
                }
            }

            @Override
            public void finished() {
            }
        }, bl, false);
        File[] fileArray = new File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    public void invoke(File file, RPFCrawlerListener rPFCrawlerListener, boolean bl) {
        File file2 = this.validateDirectory(file);
        this.process(file2, rPFCrawlerListener, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(File file, RPFCrawlerListener rPFCrawlerListener, boolean bl) {
        this.threadLock.lock();
        try {
            if (this.thread != null || this.thread == this.deadThread) {
                String string = Logging.getMessage("RPFCrawler.BadStart");
                Logging.logger().fine(string);
                throw new IllegalStateException(string);
            }
            File file2 = this.validateDirectory(file);
            this.thread = new Thread(new RPFRunner(this, file2, rPFCrawlerListener, bl));
            this.thread.start();
        }
        finally {
            this.threadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.threadLock.lock();
        try {
            this.thread = this.deadThread;
        }
        finally {
            this.threadLock.unlock();
        }
    }

    private File validateDirectory(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        String string = file.getAbsolutePath();
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separatorChar;
            file = new File(string);
        }
        if (!file.exists()) {
            String string2 = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return file;
    }

    private static class RPFRunner
    implements Runnable {
        private final RPFCrawler context;
        private final File directory;
        private final RPFCrawlerListener listener;
        private final boolean tocFileSearch;

        public RPFRunner(RPFCrawler rPFCrawler, File file, RPFCrawlerListener rPFCrawlerListener, boolean bl) {
            this.context = rPFCrawler;
            this.directory = file;
            this.listener = rPFCrawlerListener;
            this.tocFileSearch = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.context.process(this.directory, this.listener, this.tocFileSearch, true);
            this.context.threadLock.lock();
            try {
                if (this.context.thread != this.context.deadThread) {
                    this.listener.finished();
                    this.context.thread = this.context.deadThread;
                }
            }
            finally {
                this.context.threadLock.unlock();
            }
        }
    }

    public static abstract class RPFGrouper
    implements RPFCrawlerListener {
        private final RPFFrameProperty groupType;

        public RPFGrouper(RPFFrameProperty rPFFrameProperty) {
            if (rPFFrameProperty == null) {
                String string = Logging.getMessage("nullValue.RPFFramePropertyTypeIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            this.groupType = rPFFrameProperty;
        }

        public abstract void addToGroup(Object var1, File var2, RPFFrameFilename var3);

        @Override
        public void fileFound(File file, boolean bl) {
            if (bl) {
                this.fileFoundTOC(file);
            } else {
                this.fileFoundRPF(file);
            }
        }

        private void fileFoundTOC(File file) {
            RPFTOCFile rPFTOCFile = null;
            try {
                rPFTOCFile = RPFTOCFile.load(file);
            }
            catch (IOException iOException) {
                Logging.logger().fine(iOException.getMessage());
            }
            if (rPFTOCFile == null) {
                return;
            }
            List list = RPFCrawler.extractRPFRecords(rPFTOCFile);
            if (list == null || list.isEmpty()) {
                return;
            }
            RPFFrameFilename rPFFrameFilename = null;
            try {
                rPFFrameFilename = RPFFrameFilename.parseFilename(((RPFFrameFileIndexSection.RPFFrameFileIndexRecord)list.get(0)).getFrameFileName());
            }
            catch (Exception exception) {
                String string = Logging.getMessage("RPFCrawler.ExceptionParsingFilename", file.getPath());
                Logging.logger().log(Level.FINE, string, exception);
            }
            if (rPFFrameFilename == null) {
                return;
            }
            Object object = this.groupType.getValue(rPFFrameFilename);
            for (RPFFrameFileIndexSection.RPFFrameFileIndexRecord rPFFrameFileIndexRecord : list) {
                String string = RPFCrawler.createAbsolutePath(new String[]{file.getParentFile().getAbsolutePath(), rPFFrameFileIndexRecord.getPathname(), rPFFrameFileIndexRecord.getFrameFileName()});
                RPFFrameFilename rPFFrameFilename2 = this.rpfFrameFilenameFor(file);
                this.addToGroup(object, new File(string), rPFFrameFilename2);
            }
        }

        private void fileFoundRPF(File file) {
            RPFFrameFilename rPFFrameFilename = this.rpfFrameFilenameFor(file);
            if (rPFFrameFilename == null) {
                return;
            }
            Object object = this.groupType.getValue(rPFFrameFilename);
            this.addToGroup(object, file, rPFFrameFilename);
        }

        @Override
        public void finished() {
        }

        private RPFFrameFilename rpfFrameFilenameFor(File file) {
            RPFFrameFilename rPFFrameFilename = null;
            try {
                rPFFrameFilename = RPFFrameFilename.parseFilename(file.getName().toUpperCase());
            }
            catch (Exception exception) {
                String string = Logging.getMessage("RPFCrawler.ExceptionParsingFilename", file.getPath());
                Logging.logger().log(Level.FINE, string, exception);
            }
            return rPFFrameFilename;
        }
    }

    public static interface RPFCrawlerListener {
        public void fileFound(File var1, boolean var2);

        public void finished();
    }
}

