/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.formats.nitfs.NITFSRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NITFSUtil;
import gov.nasa.worldwind.formats.rpf.RPFFrameFileComponents;
import java.nio.ByteBuffer;

public class UserDefinedImageSubheader {
    private RPFFrameFileComponents rpfFrameFileComponents = null;
    private short overflow;
    private String tag;
    private int dataLength;

    public short getOverflow() {
        return this.overflow;
    }

    public String getTag() {
        return this.tag;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public RPFFrameFileComponents getRPFFrameFileComponents() {
        return this.rpfFrameFileComponents;
    }

    public UserDefinedImageSubheader(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        this.overflow = NITFSUtil.getShortNumeric(byteBuffer, 3);
        this.tag = NITFSUtil.getString(byteBuffer, 6);
        this.dataLength = NITFSUtil.getShortNumeric(byteBuffer, 5);
        if (0 < this.dataLength) {
            if ("RPFIMG".equals(this.tag)) {
                this.rpfFrameFileComponents = new RPFFrameFileComponents(byteBuffer);
            } else {
                throw new NITFSRuntimeException("NITFSReader.UnknownOrUnsupportedUserDefinedImageSubheader");
            }
        }
    }
}

