/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.formats.nitfs.NITFSUtil;
import java.nio.ByteBuffer;

class NITFSImageBand {
    private String representation;
    private String significanceForImageCategory;
    private String imageFilterCondition;
    private String stdImageFilterCode;
    private short numOfLookupTables;
    private short numOfLookupTableEntries;
    private byte[][] lut;
    private boolean isGrayImage;
    private boolean hasTransparentEntry;

    public boolean isGrayImage() {
        return this.isGrayImage;
    }

    public boolean isHasTransparentEntry() {
        return this.hasTransparentEntry;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public short getNumOfLookupTables() {
        return this.numOfLookupTables;
    }

    public short getNumOfLookupTableEntries() {
        return this.numOfLookupTableEntries;
    }

    public NITFSImageBand(ByteBuffer byteBuffer) {
        this.representation = NITFSUtil.getString(byteBuffer, 2);
        this.significanceForImageCategory = NITFSUtil.getString(byteBuffer, 6);
        this.imageFilterCondition = NITFSUtil.getString(byteBuffer, 1);
        this.stdImageFilterCode = NITFSUtil.getString(byteBuffer, 3);
        this.numOfLookupTables = NITFSUtil.getShortNumeric(byteBuffer, 1);
        this.numOfLookupTableEntries = NITFSUtil.getShortNumeric(byteBuffer, 5);
        if (0 < this.numOfLookupTables && 0 < this.numOfLookupTableEntries) {
            this.lut = new byte[this.numOfLookupTables][this.numOfLookupTableEntries];
            for (int i = 0; i < this.numOfLookupTables; ++i) {
                byteBuffer.get(this.lut[i], 0, this.numOfLookupTableEntries);
            }
        }
        this.isGrayImage = 1 == this.numOfLookupTables;
        this.hasTransparentEntry = 217 == this.numOfLookupTableEntries;
    }

    public final boolean isReservedApplicationCode(int n) {
        return n >= this.numOfLookupTableEntries;
    }

    public final int lookupR5G6B5(int n) {
        int n2;
        int n3;
        int n4;
        if (3 == this.numOfLookupTables) {
            n4 = (0xFF & this.lut[0][n]) >> 3;
            n3 = (0xFF & this.lut[1][n]) >> 2;
            n2 = (0xFF & this.lut[2][n]) >> 3;
        } else {
            int n5 = 0xFF & this.lut[0][n];
            n4 = n5 >> 3;
            n3 = n5 >> 2;
            n2 = n5 >> 3;
        }
        return 0xFFFF & (n4 << 11 | n3 << 5 | n2);
    }

    public final int lookupRGB(int n) {
        int n2;
        int n3;
        int n4;
        if (3 == this.numOfLookupTables) {
            n4 = 0xFF & this.lut[0][n];
            n3 = 0xFF & this.lut[1][n];
            n2 = 0xFF & this.lut[2][n];
        } else {
            n3 = n2 = 0xFF & this.lut[0][n];
            n4 = n2;
        }
        return (int)(0xFFFFFFL & (long)(n4 << 16 | n3 << 8 | n2));
    }

    public final int lookupGray(int n) {
        if (3 == this.numOfLookupTables) {
            int n2 = 0xFF & this.lut[0][n];
            int n3 = 0xFF & this.lut[1][n];
            int n4 = 0xFF & this.lut[2][n];
            return (30 * n2 + 59 * n3 + 11 * n4) / 100;
        }
        return 0xFF & this.lut[0][n];
    }
}

