/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.formats.dds.Color32;
import gov.nasa.worldwind.formats.dds.ColorBlock4x4;
import gov.nasa.worldwind.formats.dds.ColorBlockExtractor;
import gov.nasa.worldwind.formats.dds.DXTCompressionAttributes;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;

public class BasicColorBlockExtractor
implements ColorBlockExtractor {
    protected int width;
    protected int height;
    protected BufferedImage image;
    private int[] buffer;
    protected static int[] remainder = new int[]{0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 2, 0, 0, 1, 2, 3};

    public BasicColorBlockExtractor(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.image = bufferedImage;
        this.buffer = new int[16];
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public void extractColorBlock4x4(DXTCompressionAttributes dXTCompressionAttributes, int n, int n2, ColorBlock4x4 colorBlock4x4) {
        int n3;
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (colorBlock4x4 == null) {
            String string = Logging.getMessage("nullValue.ColorBlockIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = Math.min(this.width - n, 4);
        int n5 = Math.min(this.height - n2, 4);
        int n6 = 4 * (n4 - 1);
        int n7 = 4 * (n5 - 1);
        int n8 = 0;
        this.image.getRGB(n, n2, n4, n5, this.buffer, 0, 4);
        for (n3 = 0; n3 < 4; ++n3) {
            int n9 = remainder[n7 + n3];
            int n10 = remainder[n6];
            BasicColorBlockExtractor.int32ToColor32(this.buffer[n10 + n9 * 4], colorBlock4x4.color[n8++]);
            n10 = remainder[n6 + 1];
            BasicColorBlockExtractor.int32ToColor32(this.buffer[n10 + n9 * 4], colorBlock4x4.color[n8++]);
            n10 = remainder[n6 + 2];
            BasicColorBlockExtractor.int32ToColor32(this.buffer[n10 + n9 * 4], colorBlock4x4.color[n8++]);
            n10 = remainder[n6 + 3];
            BasicColorBlockExtractor.int32ToColor32(this.buffer[n10 + n9 * 4], colorBlock4x4.color[n8++]);
        }
        if (dXTCompressionAttributes.isPremultiplyAlpha()) {
            for (n3 = 0; n3 < 16; ++n3) {
                BasicColorBlockExtractor.premultiplyAlpha(colorBlock4x4.color[n3]);
            }
        }
    }

    protected static void int32ToColor32(int n, Color32 color32) {
        color32.a = 0xFF & n >> 24;
        color32.r = 0xFF & n >> 16;
        color32.g = 0xFF & n >> 8;
        color32.b = 0xFF & n;
    }

    protected static void premultiplyAlpha(Color32 color32) {
        color32.r = BasicColorBlockExtractor.div255(color32.r * color32.a);
        color32.g = BasicColorBlockExtractor.div255(color32.g * color32.a);
        color32.b = BasicColorBlockExtractor.div255(color32.b * color32.a);
    }

    private static int div255(int n) {
        return n + (n >> 8) + 128 >> 8;
    }
}

