/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DDSRasterWriter;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterWriter;
import gov.nasa.worldwind.data.GDALDataRasterReader;
import gov.nasa.worldwind.data.GeotiffRasterReader;
import gov.nasa.worldwind.data.ImageIORasterReader;
import gov.nasa.worldwind.data.ImageIORasterWriter;
import gov.nasa.worldwind.data.RPFRasterReader;
import gov.nasa.worldwind.data.TiledRasterProducer;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.IOException;
import org.w3c.dom.Document;

public class TiledImageProducer
extends TiledRasterProducer {
    protected static final String DEFAULT_IMAGE_FORMAT = "image/png";
    protected static final String DEFAULT_TEXTURE_FORMAT = "image/dds";
    protected static DataRasterReader[] readers = new DataRasterReader[]{new RPFRasterReader(), new GDALDataRasterReader(), new ImageIORasterReader(), new GeotiffRasterReader()};

    public TiledImageProducer(MemoryCache memoryCache, int n) {
        super(memoryCache, n);
    }

    public TiledImageProducer() {
    }

    @Override
    public String getDataSourceDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Logging.getMessage("TiledImageProducer.Description"));
        stringBuilder.append(" (").append(super.getDataSourceDescription()).append(")");
        return stringBuilder.toString();
    }

    @Override
    protected DataRaster createDataRaster(int n, int n2, Sector sector, AVList aVList) {
        int n3 = 3;
        BufferedImageRaster bufferedImageRaster = new BufferedImageRaster(n, n2, n3, sector);
        return bufferedImageRaster;
    }

    @Override
    protected DataRasterReader[] getDataRasterReaders() {
        return readers;
    }

    @Override
    protected DataRasterWriter[] getDataRasterWriters() {
        return new DataRasterWriter[]{new ImageIORasterWriter(false), new DDSRasterWriter()};
    }

    @Override
    protected String validateDataSource(Object object, AVList aVList) {
        if (object == null) {
            return Logging.getMessage("nullValue.SourceIsNull");
        }
        if (object instanceof DataRaster) {
            DataRaster dataRaster = (DataRaster)object;
            if (!(dataRaster instanceof BufferedImageRaster)) {
                return Logging.getMessage("TiledRasterProducer.UnrecognizedDataSource", dataRaster);
            }
            String string = this.validateDataSourceParams(dataRaster, String.valueOf(dataRaster));
            if (string != null) {
                return string;
            }
        } else {
            aVList = aVList == null ? new AVListImpl() : aVList;
            DataRasterReader dataRasterReader = this.getReaderFactory().findReaderFor(object, aVList, this.getDataRasterReaders());
            if (dataRasterReader == null) {
                return Logging.getMessage("TiledRasterProducer.UnrecognizedDataSource", object);
            }
            if (dataRasterReader instanceof RPFRasterReader) {
                return null;
            }
            String string = this.validateDataSourceParams(aVList, String.valueOf(object));
            if (!WWUtil.isEmpty(string)) {
                try {
                    dataRasterReader.readMetadata(object, aVList);
                    string = this.validateDataSourceParams(aVList, String.valueOf(object));
                }
                catch (IOException iOException) {
                    return Logging.getMessage("TiledRasterProducer.ExceptionWhileReading", object, iOException.getMessage());
                }
            }
            if (!WWUtil.isEmpty(string)) {
                return string;
            }
        }
        return null;
    }

    protected String validateDataSourceParams(AVList aVList, String string) {
        if (aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat") && aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat") != "gov.nasa.worldwind.avkey.Image") {
            return Logging.getMessage("TiledRasterProducer.UnrecognizedRasterType", aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat"), string);
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem") && aVList.getValue("gov.nasa.worldwind.avkey.CoordinateSystem") != "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic" && aVList.getValue("gov.nasa.worldwind.avkey.CoordinateSystem") != "gov.nasa.worldwind.avkey.CoordinateSystem.Projected") {
            return Logging.getMessage("TiledRasterProducer.UnrecognizedCoordinateSystem", aVList.getValue("gov.nasa.worldwind.avkey.CoordinateSystem"), string);
        }
        if (aVList.getValue("gov.nasa.worldwind.avKey.Sector") == null) {
            return Logging.getMessage("TiledRasterProducer.NoSector", string);
        }
        return null;
    }

    @Override
    protected void initProductionParameters(AVList aVList) {
        String string;
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") != null && (string = WWIO.makeMimeTypeForSuffix(aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey").toString())) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", string);
            aVList.setValue("gov.nasa.worldwind.avkey.AvailableImageFormats", new String[]{string});
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", DEFAULT_IMAGE_FORMAT);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.AvailableImageFormats") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.AvailableImageFormats", new String[]{aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat").toString()});
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", WWIO.makeSuffixForMimeType(aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat").toString()));
        }
    }

    @Override
    protected Document createConfigDoc(AVList aVList) {
        AVList aVList2 = aVList.copy();
        if (aVList2.getValue("gov.nasa.worldwind.avkey.DisplayName") == null) {
            aVList2.setValue("gov.nasa.worldwind.avkey.DisplayName", aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey"));
        }
        if (aVList2.getValue("gov.nasa.worldwind.avkey.ServiceName") == null) {
            aVList2.setValue("gov.nasa.worldwind.avkey.ServiceName", "Offline");
        }
        aVList2.setValue("gov.nasa.worldwind.avkey.NetworkRetrievalEnabled", Boolean.FALSE);
        aVList2.setValue("gov.nasa.worldwind.avkey.TextureFormat", DEFAULT_TEXTURE_FORMAT);
        aVList2.setValue("gov.nasa.worldwind.avkey.UseMipMaps", Boolean.TRUE);
        aVList2.setValue("gov.nasa.worldwind.avkey.UseTransparentTextures", Boolean.TRUE);
        return BasicTiledImageLayer.createTiledImageLayerConfigDocument(aVList2);
    }
}

