/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.BasicRasterServerCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.data.AbstractDataRaster;
import gov.nasa.worldwind.data.BasicDataRasterReaderFactory;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.CachedDataRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.data.RasterServer;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.dds.DDSCompressor;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicRasterServer
extends WWObjectImpl
implements RasterServer {
    protected final String XPATH_RASTER_SERVER = "/RasterServer";
    protected final String XPATH_RASTER_SERVER_PROPERTY = "/RasterServer/Property";
    protected final String XPATH_RASTER_SERVER_SOURCE = "/RasterServer/Sources/Source";
    protected final String XPATH_RASTER_SERVER_SOURCE_SECTOR = "/RasterServer/Sources/Source/Sector";
    protected List<DataRaster> dataRasterList = new ArrayList<DataRaster>();
    protected DataRasterReaderFactory readerFactory;
    protected static final MemoryCache cache = new BasicRasterServerCache();

    public BasicRasterServer(Object object, AVList aVList) {
        if (null != aVList) {
            this.setValues(aVList);
        }
        try {
            this.readerFactory = (DataRasterReaderFactory)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.DataRasterReaderFactoryClassName");
        }
        catch (Exception exception) {
            this.readerFactory = new BasicDataRasterReaderFactory();
        }
        this.init(object);
    }

    public MemoryCache getCache() {
        return cache;
    }

    public boolean hasDataRasters() {
        return this.dataRasterList.size() > 0;
    }

    protected void init(Object object) {
        Object object2;
        if (null == object) {
            String string = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Element element = null;
        if (object instanceof Element) {
            element = (Element)object;
        } else if (object instanceof Document) {
            element = ((Document)object).getDocumentElement();
        } else {
            object2 = WWXML.openDocument(object);
            if (null != object2) {
                element = object2.getDocumentElement();
            }
        }
        if (null == element) {
            object2 = Logging.getMessage("generic.UnexpectedObjectType", object.getClass().getName());
            Logging.logger().severe((String)object2);
            throw new IllegalArgumentException((String)object2);
        }
        object2 = element.getNodeName();
        if (!"RasterServer".equals(object2)) {
            String string = Logging.getMessage("generic.InvalidDataSource", (String)object2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XPath xPath = WWXML.makeXPath();
        this.extractProperties(element, xPath);
        if (this.readRasterSources(element, xPath)) {
            String string = Logging.getMessage("generic.DataSetAvailable", this.getDataSetName());
            Logging.logger().finest(string);
        } else {
            String string = Logging.getMessage("generic.DataSetLimitedAvailability", this.getDataSetName());
            Logging.logger().severe(string);
        }
    }

    protected String getDataSetName() {
        return AVListImpl.getStringValue(this, "gov.nasa.worldwind.avkey.DatasetNameKey", "");
    }

    protected String getDataSetPixelFormat() {
        return AVListImpl.getStringValue(this, "gov.nasa.worldwind.avkey.PixelFormat", "");
    }

    protected void setDataSetPixelFormat(String string) {
        this.setValue("gov.nasa.worldwind.avkey.PixelFormat", string);
    }

    protected void extractProperties(Element element, XPath xPath) {
        Element[] elementArray = WWXML.getElements(element, "/RasterServer/Property", xPath);
        if (elementArray != null && elementArray.length > 0) {
            for (Element element2 : elementArray) {
                String string = element2.getAttribute("name");
                String string2 = element2.getAttribute("value");
                if (WWUtil.isEmpty(string) || WWUtil.isEmpty(string2)) continue;
                if (!this.hasKey(string)) {
                    this.setValue(string, string2);
                    continue;
                }
                Object object = this.getValue(string);
                if (string2.equals(object)) continue;
                String string3 = Logging.getMessage("generic.AttemptToChangeExistingProperty", string, object, string2);
                Logging.logger().fine(string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readRasterSources(Element element, XPath xPath) {
        Object object;
        long l = System.currentTimeMillis();
        boolean bl = false;
        int n = 0;
        Sector sector = null;
        try {
            XPathExpression xPathExpression = xPath.compile("/RasterServer/Sources/Source");
            object = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (object == null || object.getLength() == 0) {
                boolean bl2 = false;
                return bl2;
            }
            n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Object object2;
                Thread.yield();
                try {
                    String string;
                    Object object3;
                    Object object4;
                    Object object5;
                    String string2;
                    Node node = object.item(i);
                    node.getParentNode().removeChild(node);
                    if (node.getNodeType() != 1 || WWUtil.isEmpty(string2 = (object2 = (Element)node).getAttribute("path"))) continue;
                    AVListImpl aVListImpl = new AVListImpl();
                    File file = new File(string2);
                    string2 = file.getAbsolutePath();
                    if (!file.exists()) {
                        bl = true;
                        object5 = Logging.getMessage("generic.FileDoesNotExists", string2);
                        Logging.logger().warning((String)object5);
                        continue;
                    }
                    if (!file.canRead()) {
                        bl = true;
                        object5 = Logging.getMessage("generic.FileNoReadPermission", string2);
                        Logging.logger().warning((String)object5);
                        continue;
                    }
                    object5 = this.findDataRasterReader(file, aVListImpl);
                    if (null == object5) {
                        bl = true;
                        object4 = Logging.getMessage("generic.UnknownFileFormatOrMatchingReaderNotFound", string2);
                        Logging.logger().warning((String)object4);
                        continue;
                    }
                    object4 = WWXML.getSector((Element)object2, "Sector", xPath);
                    if (null == object4) {
                        object5.readMetadata(file, aVListImpl);
                        object3 = aVListImpl.getValue("gov.nasa.worldwind.avKey.Sector");
                        object4 = object3 instanceof Sector ? (Sector)object3 : object4;
                    } else {
                        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", object4);
                    }
                    object3 = aVListImpl.getValue("gov.nasa.worldwind.avkey.PixelFormat");
                    String string3 = this.getDataSetPixelFormat();
                    if (!WWUtil.isEmpty(string3)) {
                        if (!string3.equals(object3)) {
                            bl = true;
                            string = Logging.getMessage("generic.UnexpectedRasterType", string2);
                            Logging.logger().warning(string);
                            continue;
                        }
                    } else if ("gov.nasa.worldwind.avkey.Image".equals(object3) || "gov.nasa.worldwind.avkey.Elevation".equals(object3)) {
                        this.setDataSetPixelFormat((String)object3);
                    } else {
                        bl = true;
                        string = Logging.getMessage("generic.UnknownFileFormat", string2);
                        Logging.logger().warning(string);
                        continue;
                    }
                    if (null != object4) {
                        sector = Sector.union(sector, (Sector)object4);
                        this.dataRasterList.add(new CachedDataRaster(file, aVListImpl, (DataRasterReader)object5, this.getCache()));
                        continue;
                    }
                    bl = true;
                    string = Logging.getMessage("generic.NoSectorSpecified", string2);
                    Logging.logger().warning(string);
                    continue;
                }
                catch (Throwable throwable) {
                    object2 = throwable.getMessage();
                    object2 = WWUtil.isEmpty(object2) ? throwable.getCause().getMessage() : object2;
                    Logging.logger().log(Level.WARNING, (String)object2, throwable);
                }
            }
            if (null != sector && sector.getDeltaLatDegrees() > 0.0 && sector.getDeltaLonDegrees() > 0.0) {
                this.setValue("gov.nasa.worldwind.avKey.Sector", sector);
            }
        }
        catch (Throwable throwable) {
            object = throwable.getMessage();
            object = WWUtil.isEmpty(object) ? throwable.getCause().getMessage() : object;
            Logging.logger().log(Level.SEVERE, (String)object, throwable);
        }
        finally {
            Logging.logger().finest(this.getStringValue("gov.nasa.worldwind.avkey.DisplayName") + ": " + n + " files in " + (System.currentTimeMillis() - l) + " milli-seconds");
        }
        return !bl;
    }

    protected DataRasterReader findDataRasterReader(Object object, AVList aVList) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DataRasterReader dataRasterReader = this.readerFactory.findReaderFor(object, aVList = null == aVList ? new AVListImpl() : aVList);
        if (dataRasterReader == null) {
            return null;
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            try {
                dataRasterReader.readMetadata(object, aVList);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileReading", object);
                Logging.logger().finest(string);
            }
        }
        return dataRasterReader;
    }

    @Override
    public Sector getSector() {
        return this.hasKey("gov.nasa.worldwind.avKey.Sector") ? (Sector)this.getValue("gov.nasa.worldwind.avKey.Sector") : null;
    }

    public DataRaster composeRaster(AVList aVList) throws IllegalArgumentException, WWRuntimeException {
        AbstractDataRaster abstractDataRaster;
        if (null == aVList) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Width")) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Width");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Height")) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Height");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (null == object || !(object instanceof Sector)) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avKey.Sector");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = (Sector)object;
        Sector sector2 = this.getSector();
        if (!sector.intersects(sector2)) {
            String string = Logging.getMessage("generic.SectorRequestedOutsideCoverageArea", sector, sector2);
            Logging.logger().finest(string);
            throw new WWRuntimeException(string);
        }
        try {
            int n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width");
            int n2 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height");
            if (!aVList.hasKey("gov.nasa.worldwind.avkey.ByteOrder")) {
                aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.BigEndian");
            }
            if ("gov.nasa.worldwind.avkey.Elevation".equals(this.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
                if (!aVList.hasKey("gov.nasa.worldwind.avkey.DataType")) {
                    aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int16");
                }
                abstractDataRaster = new ByteBufferRaster(n, n2, sector, aVList);
            } else if ("gov.nasa.worldwind.avkey.Image".equals(this.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
                abstractDataRaster = new BufferedImageRaster(n, n2, 3, sector);
            } else {
                String string = Logging.getMessage("generic.UnrecognizedSourceType", this.getValue("gov.nasa.worldwind.avkey.PixelFormat"));
                Logging.logger().severe(string);
                throw new WWRuntimeException(string);
            }
            int n3 = 0;
            for (DataRaster dataRaster : this.dataRasterList) {
                Sector sector3 = dataRaster.getSector();
                Sector sector4 = sector.intersection(sector3);
                if (null == sector4 || sector4.getDeltaLatDegrees() == 0.0 || sector4.getDeltaLonDegrees() == 0.0) continue;
                dataRaster.drawOnTo(abstractDataRaster);
                ++n3;
            }
            if (n3 == 0) {
                String string = Logging.getMessage("generic.SectorRequestedOutsideCoverageArea", sector, "");
                Logging.logger().finest(string);
                throw new WWRuntimeException(string);
            }
        }
        catch (WWRuntimeException wWRuntimeException) {
            throw wWRuntimeException;
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            string = WWUtil.isEmpty(string) ? throwable.getCause().getMessage() : string;
            Logging.logger().log(Level.FINE, string, throwable);
            throw new WWRuntimeException(string);
        }
        return abstractDataRaster;
    }

    @Override
    public ByteBuffer getRasterAsByteBuffer(AVList aVList) {
        String string;
        String string2 = string = null != aVList && aVList.hasKey("gov.nasa.worldwind.avkey.ImageFormat") ? aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat") : this.getStringValue("gov.nasa.worldwind.avkey.ImageFormat");
        if (WWUtil.isEmpty(string)) {
            String string3 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.ImageFormat");
            Logging.logger().severe(string3);
            throw new WWRuntimeException(string3);
        }
        if (this.dataRasterList.isEmpty()) {
            String string4 = Logging.getMessage("generic.NoImagesAvailable");
            Logging.logger().finest(string4);
            throw new WWRuntimeException(string4);
        }
        try {
            DataRaster dataRaster = this.composeRaster(aVList);
            if (dataRaster instanceof BufferedImageRaster) {
                if ("image/png".equalsIgnoreCase(string)) {
                    return ImageUtil.asPNG(dataRaster);
                }
                if ("image/jpeg".equalsIgnoreCase(string) || "image/jpg".equalsIgnoreCase(string)) {
                    return ImageUtil.asJPEG(dataRaster);
                }
                if ("image/dds".equalsIgnoreCase(string)) {
                    return DDSCompressor.compressImage(((BufferedImageRaster)dataRaster).getBufferedImage());
                }
                String string5 = Logging.getMessage("generic.UnknownFileFormat", string);
                Logging.logger().severe(string5);
                throw new WWRuntimeException(string5);
            }
            if (dataRaster instanceof ByteBufferRaster) {
                return ((ByteBufferRaster)dataRaster).getByteBuffer();
            }
            String string6 = Logging.getMessage("generic.UnexpectedRasterType", dataRaster.getClass().getName());
            Logging.logger().severe(string6);
            throw new WWRuntimeException(string6);
        }
        catch (WWRuntimeException wWRuntimeException) {
            Logging.logger().finest(wWRuntimeException.getMessage());
        }
        catch (Throwable throwable) {
            String string7 = throwable.getMessage();
            string7 = WWUtil.isEmpty(string7) ? throwable.getCause().getMessage() : string7;
            Logging.logger().log(Level.SEVERE, string7, throwable);
        }
        return null;
    }
}

