/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.BILRasterReader;
import gov.nasa.worldwind.data.DTEDRasterReader;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.data.GDALDataRasterReader;
import gov.nasa.worldwind.data.GeotiffRasterReader;
import gov.nasa.worldwind.data.ImageIORasterReader;
import gov.nasa.worldwind.data.RPFRasterReader;
import gov.nasa.worldwind.util.Logging;

public class BasicDataRasterReaderFactory
implements DataRasterReaderFactory {
    protected DataRasterReader[] readers = new DataRasterReader[]{new RPFRasterReader(), new DTEDRasterReader(), new GDALDataRasterReader(), new GeotiffRasterReader(), new BILRasterReader(), new ImageIORasterReader()};

    @Override
    public DataRasterReader[] getReaders() {
        return this.readers;
    }

    @Override
    public DataRasterReader findReaderFor(Object object, AVList aVList) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.findReaderFor(object, aVList, this.readers);
    }

    @Override
    public DataRasterReader findReaderFor(Object object, AVList aVList, DataRasterReader[] dataRasterReaderArray) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dataRasterReaderArray == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (DataRasterReader dataRasterReader : dataRasterReaderArray) {
            if (dataRasterReader == null || !dataRasterReader.canRead(object, aVList)) continue;
            return dataRasterReader;
        }
        return null;
    }
}

