/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import com.jogamp.opengl.util.texture.Texture;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.GpuResourceCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.util.Logging;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;

public class BasicGpuResourceCache
implements GpuResourceCache {
    protected final BasicMemoryCache resources;

    public BasicGpuResourceCache(long l, long l2) {
        this.resources = new BasicMemoryCache(l, l2);
        this.resources.setName("GPU Resource Cache");
        this.resources.addCacheListener(new MemoryCache.CacheListener(){

            @Override
            public void entryRemoved(Object object, Object object2) {
                BasicGpuResourceCache.this.onEntryRemoved(object, object2);
            }

            @Override
            public void removalException(Throwable throwable, Object object, Object object2) {
                String string = Logging.getMessage("BasicMemoryCache.ExceptionFromRemovalListener", throwable.getMessage());
                Logging.logger().log(Level.INFO, string);
            }
        });
    }

    protected void onEntryRemoved(Object object, Object object2) {
        GLContext gLContext = GLContext.getCurrent();
        if (gLContext == null || gLContext.getGL() == null) {
            return;
        }
        if (!(object2 instanceof CacheEntry)) {
            return;
        }
        CacheEntry cacheEntry = (CacheEntry)object2;
        GL2 gL2 = gLContext.getGL().getGL2();
        if (cacheEntry.resourceType == "gov.nasa.worldwind.cache.GpuResourceCache.Texture") {
            ((Texture)cacheEntry.resource).destroy((GL)gL2);
        } else if (cacheEntry.resourceType == "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers") {
            int[] nArray = (int[])cacheEntry.resource;
            gL2.glDeleteBuffers(nArray.length, nArray, 0);
        } else if (cacheEntry.resourceType == "gov.nasa.worldwind.cache.GpuResourceCache.DisplayList") {
            int[] nArray = (int[])cacheEntry.resource;
            gL2.glDeleteLists(nArray[0], nArray[1]);
        }
    }

    @Override
    public void put(Object object, Texture texture) {
        CacheEntry cacheEntry = this.createCacheEntry(texture, "gov.nasa.worldwind.cache.GpuResourceCache.Texture");
        this.resources.add(object, cacheEntry);
    }

    @Override
    public void put(Object object, Object object2, String string, long l) {
        CacheEntry cacheEntry = this.createCacheEntry(object2, string, l);
        this.resources.add(object, cacheEntry);
    }

    protected CacheEntry createCacheEntry(Object object, String string) {
        CacheEntry cacheEntry = new CacheEntry(object, string);
        cacheEntry.resourceSize = this.computeEntrySize(cacheEntry);
        return cacheEntry;
    }

    protected CacheEntry createCacheEntry(Object object, String string, long l) {
        CacheEntry cacheEntry = new CacheEntry(object, string, l);
        cacheEntry.resourceSize = l;
        return cacheEntry;
    }

    @Override
    public Object get(Object object) {
        CacheEntry cacheEntry = (CacheEntry)this.resources.getObject(object);
        return cacheEntry != null ? cacheEntry.resource : null;
    }

    @Override
    public Texture getTexture(Object object) {
        CacheEntry cacheEntry = (CacheEntry)this.resources.getObject(object);
        return cacheEntry != null && cacheEntry.resourceType == "gov.nasa.worldwind.cache.GpuResourceCache.Texture" ? (Texture)cacheEntry.resource : null;
    }

    @Override
    public void remove(Object object) {
        this.resources.remove(object);
    }

    @Override
    public int getNumObjects() {
        return this.resources.getNumObjects();
    }

    @Override
    public long getCapacity() {
        return this.resources.getCapacity();
    }

    @Override
    public long getUsedCapacity() {
        return this.resources.getUsedCapacity();
    }

    @Override
    public long getFreeCapacity() {
        return this.resources.getFreeCapacity();
    }

    @Override
    public boolean contains(Object object) {
        return this.resources.contains(object);
    }

    @Override
    public void clear() {
        this.resources.clear();
    }

    @Override
    public synchronized void setCapacity(long l) {
        this.resources.setCapacity(l);
    }

    @Override
    public synchronized void setLowWater(long l) {
        this.resources.setLowWater(l);
    }

    @Override
    public long getLowWater() {
        return this.resources.getLowWater();
    }

    protected long computeEntrySize(CacheEntry cacheEntry) {
        if (cacheEntry.resourceType == "gov.nasa.worldwind.cache.GpuResourceCache.Texture") {
            return this.computeTextureSize(cacheEntry);
        }
        return 0L;
    }

    protected long computeTextureSize(CacheEntry cacheEntry) {
        Texture texture = (Texture)cacheEntry.resource;
        long l = texture.getEstimatedMemorySize();
        if (l < 1L) {
            l = texture.getHeight() * texture.getWidth() * 4;
        }
        return l;
    }

    public static class CacheEntry
    implements Cacheable {
        protected final String resourceType;
        protected final Object resource;
        protected long resourceSize;

        public CacheEntry(Object object, String string) {
            this.resource = object;
            this.resourceType = string;
        }

        public CacheEntry(Object object, String string, long l) {
            this.resource = object;
            this.resourceType = string;
            this.resourceSize = l;
        }

        @Override
        public long getSizeInBytes() {
            return this.resourceSize;
        }
    }
}

