/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.BasicAnimator;
import gov.nasa.worldwind.animation.Interpolator;
import gov.nasa.worldwind.animation.ScheduledInterpolator;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PropertyAccessor;

public class DoubleAnimator
extends BasicAnimator {
    protected double begin;
    protected double end;
    protected final PropertyAccessor.DoubleAccessor propertyAccessor;

    public DoubleAnimator(Interpolator interpolator, double d, double d2, PropertyAccessor.DoubleAccessor doubleAccessor) {
        super(interpolator);
        if (interpolator == null) {
            this.interpolator = new ScheduledInterpolator(10000L);
        }
        if (doubleAccessor == null) {
            String string = Logging.getMessage("nullValue.ViewPropertyAccessorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.begin = d;
        this.end = d2;
        this.propertyAccessor = doubleAccessor;
    }

    public void setBegin(Double d) {
        this.begin = d;
    }

    public void setEnd(Double d) {
        this.end = d;
    }

    public final Double getBegin() {
        return this.begin;
    }

    public final Double getEnd() {
        return this.end;
    }

    public final PropertyAccessor.DoubleAccessor getPropertyAccessor() {
        return this.propertyAccessor;
    }

    @Override
    protected void setImpl(double d) {
        Double d2 = this.nextDouble(d);
        if (d2 == null) {
            return;
        }
        boolean bl = this.propertyAccessor.setDouble(d2);
        if (!bl) {
            this.flagLastStateInvalid();
        }
        if (d >= 1.0) {
            this.stop();
        }
    }

    public Double nextDouble(double d) {
        return AnimationSupport.mixDouble(d, this.begin, this.end);
    }
}

