/*
 * Decompiled with CFR 0.152.
 */
package com.zebraimaging;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.AWTInputHandler;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class ZebraInputHandler
extends AWTInputHandler {
    private static List<ZebraInputHandler> instances = new ArrayList<ZebraInputHandler>();
    private static Timer repaintContextsTimer = null;
    static final TimerTask repaintContextsTask = new TimerTask(){

        @Override
        public void run() {
            for (ZebraInputHandler zebraInputHandler : instances) {
                if (!zebraInputHandler.NeedsRefresh()) continue;
                zebraInputHandler.SetRefresh(false);
                zebraInputHandler.getWorldWindow().redraw();
            }
        }
    };
    private long hwnd = 0L;
    private boolean arGL2Present = false;
    private boolean refresh = false;

    public ZebraInputHandler() {
        try {
            System.loadLibrary("arGL2Integrator");
            this.arGL2Present = true;
            instances.add(this);
            System.out.println("Loaded arGL2Integrator successfully");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("FAILED to load arGL2Integrator.dll");
        }
        if (repaintContextsTimer == null) {
            repaintContextsTimer = new Timer();
            repaintContextsTimer.scheduleAtFixedRate(repaintContextsTask, 0L, 10L);
        }
    }

    private synchronized void SetRefresh(boolean bl) {
        this.refresh = bl;
    }

    private synchronized boolean NeedsRefresh() {
        return this.refresh;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        if (this.arGL2Present) {
            bl = this.zebraKeyPressed(this.getGLCanvasHandle(), keyEvent.getKeyCode());
        }
        if (bl) {
            keyEvent.consume();
        } else {
            super.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        boolean bl = false;
        if (this.arGL2Present) {
            bl = this.zebraKeyReleased(this.getGLCanvasHandle(), keyEvent.getKeyCode());
        }
        if (bl) {
            keyEvent.consume();
        } else {
            super.keyReleased(keyEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.arGL2Present) {
            bl = this.zebraMouseReleased(this.getGLCanvasHandle(), mouseEvent.getButton(), mouseEvent.getX(), mouseEvent.getY());
        }
        if (bl) {
            mouseEvent.consume();
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.arGL2Present) {
            bl = this.zebraMousePressed(this.getGLCanvasHandle(), mouseEvent.getButton(), mouseEvent.getX(), mouseEvent.getY());
        }
        if (bl) {
            mouseEvent.consume();
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.arGL2Present) {
            bl = this.zebraMouseReleased(this.getGLCanvasHandle(), mouseEvent.getButton(), mouseEvent.getX(), mouseEvent.getY());
        }
        if (bl) {
            mouseEvent.consume();
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = 0;
        n = (mouseEvent.getModifiersEx() & 0x400) == 1024 ? 1 : n;
        n = (mouseEvent.getModifiersEx() & 0x800) == 2048 ? 2 : n;
        n = (mouseEvent.getModifiersEx() & 0x1000) == 4096 ? 3 : n;
        boolean bl = false;
        if (this.arGL2Present) {
            bl = this.zebraMouseMoved(this.getGLCanvasHandle(), n, mouseEvent.getX(), mouseEvent.getY());
        }
        if (bl) {
            mouseEvent.consume();
        } else {
            super.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        boolean bl = false;
        if (this.arGL2Present) {
            bl = this.zebraMouseWheel(this.getGLCanvasHandle(), mouseWheelEvent.getWheelRotation());
        }
        if (bl) {
            mouseWheelEvent.consume();
        } else {
            super.mouseWheelMoved(mouseWheelEvent);
        }
    }

    private long getGLCanvasHandle() {
        WorldWindow worldWindow;
        if (this.hwnd == 0L && (worldWindow = this.getWorldWindow()) != null) {
            WorldWindowGLCanvas worldWindowGLCanvas;
            WorldWindowGLCanvas worldWindowGLCanvas2;
            WorldWindowGLCanvas worldWindowGLCanvas3;
            WorldWindowGLCanvas worldWindowGLCanvas4 = worldWindowGLCanvas3 = (worldWindowGLCanvas2 = (worldWindowGLCanvas = (WorldWindowGLCanvas)worldWindow));
            this.hwnd = this.zebraGetWin32Handle((Component)((Object)worldWindowGLCanvas4));
        }
        return this.hwnd;
    }

    private static ZebraInputHandler getInstance(long l) {
        for (ZebraInputHandler zebraInputHandler : instances) {
            if (zebraInputHandler.hwnd != l) continue;
            return zebraInputHandler;
        }
        return null;
    }

    public static void forceRepaint(long l) {
        ZebraInputHandler zebraInputHandler = ZebraInputHandler.getInstance(l);
        if (zebraInputHandler != null) {
            zebraInputHandler.SetRefresh(true);
        }
    }

    public static double[] getModelviewMatrix(long l) {
        double[] dArray = new double[16];
        ZebraInputHandler zebraInputHandler = ZebraInputHandler.getInstance(l);
        if (zebraInputHandler != null) {
            zebraInputHandler.getWorldWindow().getView().getModelviewMatrix().toArray(dArray, 0, false);
        }
        return dArray;
    }

    public static double[] getProjectionMatrix(long l) {
        double[] dArray = new double[16];
        ZebraInputHandler zebraInputHandler = ZebraInputHandler.getInstance(l);
        if (zebraInputHandler != null) {
            zebraInputHandler.getWorldWindow().getView().getProjectionMatrix().toArray(dArray, 0, false);
        }
        return dArray;
    }

    public native boolean zebraKeyPressed(long var1, int var3);

    public native boolean zebraKeyReleased(long var1, int var3);

    public native boolean zebraMousePressed(long var1, int var3, int var4, int var5);

    public native boolean zebraMouseReleased(long var1, int var3, int var4, int var5);

    public native boolean zebraMouseMoved(long var1, int var3, int var4, int var5);

    public native boolean zebraMouseWheel(long var1, int var3);

    public native void zebraSetModelview(long var1, double[] var3);

    public native void zebraSetProjection(long var1, double[] var3);

    public native long zebraGetWin32Handle(Component var1);
}

