/*
 * Decompiled with CFR 0.152.
 */
package de.gkss.hs.datev2004;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import de.gkss.hs.datev2004.General;

public class Gaussian {
    public Matrix covinv;
    public double[] cog;
    public double normfactor;
    public double var;
    public double center;

    public Gaussian(double[] cog, double[][] cov) {
        double detr = 1.0;
        double pot = 1.0;
        try {
            int i;
            this.cog = cog;
            Matrix covm = new Matrix(cov);
            SingularValueDecomposition svd = new SingularValueDecomposition(covm);
            double[] s = svd.getSingularValues();
            int rang = svd.rank();
            for (i = 0; i < rang; ++i) {
                pot *= Math.PI * 2;
                detr *= s[i];
            }
            double[][] sinv = new double[s.length][s.length];
            for (i = 0; i < s.length; ++i) {
                sinv[i][i] = s[i] < 1.0E-10 ? 0.0 : 1.0 / s[i];
            }
            Matrix u = svd.getU();
            Matrix v = svd.getV();
            Matrix sinvm = new Matrix(sinv);
            this.covinv = v.times(sinvm.times(u.transpose()));
            for (i = 0; i < s.length; ++i) {
                if (!(s[i] < 1.0E-10)) continue;
                this.covinv.set(i, i, 1.0E10);
            }
            this.var = -1.0;
            this.normfactor = 1.0 / Math.sqrt(pot * detr);
        }
        catch (IllegalArgumentException e) {
            General.error("Gaussian: " + e.toString());
        }
    }

    public Gaussian(double center, double var) {
        this.center = center;
        this.var = var;
    }

    public double distancesqu(double[] pt) {
        double[] df = new double[pt.length];
        for (int k = 0; k < pt.length; ++k) {
            df[k] = pt[k] - this.cog[k];
        }
        Matrix dfm = new Matrix(df, pt.length);
        return Math.abs(dfm.transpose().times(this.covinv.times(dfm)).getArray()[0][0]);
    }

    public double distancesqu(double a) {
        double res = this.var < 1.0E-10 ? (Math.abs(this.center - a) < 1.0E-10 ? 0.0 : 1.0E10) : (this.center - a) * (this.center - a) / this.var;
        return res;
    }

    public double density(double[] a) {
        return this.normfactor * Math.exp(-0.5 * this.distancesqu(a));
    }

    public double density(double a) {
        return Math.exp(-0.5 * this.distancesqu(a)) / Math.sqrt(Math.PI * 2 * Math.max(this.var, 1.0E-10));
    }
}

