/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordMultiPoint;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordPoint;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordPolygon;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordPolyline;
import gov.nasa.worldwind.formats.shapefile.ShapefileUtils;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygons;
import gov.nasa.worldwind.render.SurfacePolylines;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.util.RandomShapeAttributes;
import java.util.ArrayList;
import java.util.List;

public class ShapefileLoader {
    protected static final RandomShapeAttributes randomAttrs = new RandomShapeAttributes();
    protected int numPolygonsPerLayer = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer createLayerFromSource(Object object) {
        if (WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Shapefile shapefile = null;
        Layer layer = null;
        try {
            shapefile = new Shapefile(object);
            layer = this.createLayerFromShapefile(shapefile);
        }
        finally {
            WWIO.closeStream(shapefile, object.toString());
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Layer> createLayersFromSource(Object object) {
        if (WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Shapefile shapefile = null;
        try {
            shapefile = new Shapefile(object);
            List<Layer> list = this.createLayersFromShapefile(shapefile);
            return list;
        }
        finally {
            WWIO.closeStream(shapefile, object.toString());
        }
    }

    public Layer createLayerFromShapefile(Shapefile shapefile) {
        if (shapefile == null) {
            String string = Logging.getMessage("nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Layer layer = null;
        if (Shapefile.isPointType(shapefile.getShapeType())) {
            layer = new RenderableLayer();
            this.addRenderablesForPoints(shapefile, (RenderableLayer)layer);
        } else if (Shapefile.isMultiPointType(shapefile.getShapeType())) {
            layer = new RenderableLayer();
            this.addRenderablesForMultiPoints(shapefile, (RenderableLayer)layer);
        } else if (Shapefile.isPolylineType(shapefile.getShapeType())) {
            layer = new RenderableLayer();
            this.addRenderablesForPolylines(shapefile, (RenderableLayer)layer);
        } else if (Shapefile.isPolygonType(shapefile.getShapeType())) {
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            this.addRenderablesForPolygons(shapefile, arrayList);
            layer = (Layer)arrayList.get(0);
        } else {
            Logging.logger().warning(Logging.getMessage("generic.UnrecognizedShapeType", shapefile.getShapeType()));
        }
        return layer;
    }

    public List<Layer> createLayersFromShapefile(Shapefile shapefile) {
        if (shapefile == null) {
            String string = Logging.getMessage("nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        if (Shapefile.isPointType(shapefile.getShapeType())) {
            RenderableLayer renderableLayer = new RenderableLayer();
            this.addRenderablesForPoints(shapefile, renderableLayer);
            arrayList.add(renderableLayer);
        } else if (Shapefile.isMultiPointType(shapefile.getShapeType())) {
            RenderableLayer renderableLayer = new RenderableLayer();
            this.addRenderablesForMultiPoints(shapefile, renderableLayer);
            arrayList.add(renderableLayer);
        } else if (Shapefile.isPolylineType(shapefile.getShapeType())) {
            RenderableLayer renderableLayer = new RenderableLayer();
            this.addRenderablesForPolylines(shapefile, renderableLayer);
            arrayList.add(renderableLayer);
        } else if (Shapefile.isPolygonType(shapefile.getShapeType())) {
            this.addRenderablesForPolygons(shapefile, arrayList);
        } else {
            Logging.logger().warning(Logging.getMessage("generic.UnrecognizedShapeType", shapefile.getShapeType()));
        }
        return arrayList;
    }

    public int getNumPolygonsPerLayer() {
        return this.numPolygonsPerLayer;
    }

    public void setNumPolygonsPerLayer(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.InvalidSize", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.numPolygonsPerLayer = n;
    }

    protected void addRenderablesForPoints(Shapefile shapefile, RenderableLayer renderableLayer) {
        PointPlacemarkAttributes pointPlacemarkAttributes = this.createPointAttributes(null);
        while (shapefile.hasNext()) {
            ShapefileRecord shapefileRecord = shapefile.nextRecord();
            if (!Shapefile.isPointType(shapefileRecord.getShapeType())) continue;
            double[] dArray = ((ShapefileRecordPoint)shapefileRecord).getPoint();
            renderableLayer.addRenderable(this.createPoint(shapefileRecord, dArray[1], dArray[0], pointPlacemarkAttributes));
        }
    }

    protected void addRenderablesForMultiPoints(Shapefile shapefile, RenderableLayer renderableLayer) {
        PointPlacemarkAttributes pointPlacemarkAttributes = this.createPointAttributes(null);
        while (shapefile.hasNext()) {
            ShapefileRecord shapefileRecord = shapefile.nextRecord();
            if (!Shapefile.isMultiPointType(shapefileRecord.getShapeType())) continue;
            Iterable<double[]> iterable = ((ShapefileRecordMultiPoint)shapefileRecord).getPoints(0);
            for (double[] dArray : iterable) {
                renderableLayer.addRenderable(this.createPoint(shapefileRecord, dArray[1], dArray[0], pointPlacemarkAttributes));
            }
        }
    }

    protected void addRenderablesForPolylines(Shapefile shapefile, RenderableLayer renderableLayer) {
        while (shapefile.hasNext()) {
            shapefile.nextRecord();
        }
        ShapeAttributes shapeAttributes = this.createPolylineAttributes(null);
        renderableLayer.addRenderable(this.createPolyline(shapefile, shapeAttributes));
    }

    protected void addRenderablesForPolygons(Shapefile shapefile, List<Layer> list) {
        RenderableLayer renderableLayer = new RenderableLayer();
        list.add(renderableLayer);
        int n = 0;
        while (shapefile.hasNext()) {
            try {
                ShapefileRecord shapefileRecord = shapefile.nextRecord();
                n = shapefileRecord.getRecordNumber();
                if (!Shapefile.isPolygonType(shapefileRecord.getShapeType())) continue;
                ShapeAttributes shapeAttributes = this.createPolygonAttributes(shapefileRecord);
                this.createPolygon(shapefileRecord, shapeAttributes, renderableLayer);
                if (renderableLayer.getNumRenderables() <= this.numPolygonsPerLayer) continue;
                renderableLayer = new RenderableLayer();
                renderableLayer.setEnabled(false);
                list.add(renderableLayer);
            }
            catch (Exception exception) {
                Logging.logger().warning(Logging.getMessage("SHP.ExceptionAttemptingToConvertShapefileRecord", n, exception));
            }
        }
    }

    protected Renderable createPoint(ShapefileRecord shapefileRecord, double d, double d2, PointPlacemarkAttributes pointPlacemarkAttributes) {
        PointPlacemark pointPlacemark = new PointPlacemark(Position.fromDegrees(d, d2, 0.0));
        pointPlacemark.setAltitudeMode(1);
        pointPlacemark.setAttributes(pointPlacemarkAttributes);
        return pointPlacemark;
    }

    protected Renderable createPolyline(ShapefileRecord shapefileRecord, ShapeAttributes shapeAttributes) {
        SurfacePolylines surfacePolylines = new SurfacePolylines(Sector.fromDegrees(((ShapefileRecordPolyline)shapefileRecord).getBoundingRectangle()), shapefileRecord.getCompoundPointBuffer());
        surfacePolylines.setAttributes(shapeAttributes);
        return surfacePolylines;
    }

    protected Renderable createPolyline(Shapefile shapefile, ShapeAttributes shapeAttributes) {
        SurfacePolylines surfacePolylines = new SurfacePolylines(Sector.fromDegrees(shapefile.getBoundingRectangle()), shapefile.getPointBuffer());
        surfacePolylines.setAttributes(shapeAttributes);
        return surfacePolylines;
    }

    protected void createPolygon(ShapefileRecord shapefileRecord, ShapeAttributes shapeAttributes, RenderableLayer renderableLayer) {
        Double d = this.getHeight(shapefileRecord);
        if (d != null) {
            ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon(d);
            extrudedPolygon.setAttributes(shapeAttributes);
            renderableLayer.addRenderable(extrudedPolygon);
            for (int i = 0; i < shapefileRecord.getNumberOfParts(); ++i) {
                VecBuffer vecBuffer = shapefileRecord.getCompoundPointBuffer().subBuffer(i);
                if (WWMath.computeWindingOrderOfLocations(vecBuffer.getLocations()).equals("gov.nasa.worldwind.avkey.ClockWise")) {
                    if (!extrudedPolygon.getOuterBoundary().iterator().hasNext()) {
                        extrudedPolygon.setOuterBoundary(vecBuffer.getLocations());
                        continue;
                    }
                    extrudedPolygon = new ExtrudedPolygon();
                    extrudedPolygon.setAttributes(shapeAttributes);
                    extrudedPolygon.setOuterBoundary(shapefileRecord.getCompoundPointBuffer().getLocations());
                    renderableLayer.addRenderable(extrudedPolygon);
                    continue;
                }
                extrudedPolygon.addInnerBoundary(vecBuffer.getLocations());
            }
        } else {
            SurfacePolygons surfacePolygons = new SurfacePolygons(Sector.fromDegrees(((ShapefileRecordPolygon)shapefileRecord).getBoundingRectangle()), shapefileRecord.getCompoundPointBuffer());
            surfacePolygons.setAttributes(shapeAttributes);
            surfacePolygons.setWindingRule("gov.nasa.worldwind.avkey.ClockWise");
            surfacePolygons.setPolygonRingGroups(new int[]{0});
            surfacePolygons.setPolygonRingGroups(new int[]{0});
            renderableLayer.addRenderable(surfacePolygons);
        }
    }

    protected Double getHeight(ShapefileRecord shapefileRecord) {
        return ShapefileUtils.extractHeightAttribute(shapefileRecord);
    }

    protected PointPlacemarkAttributes createPointAttributes(ShapefileRecord shapefileRecord) {
        return randomAttrs.nextPointAttributes();
    }

    protected ShapeAttributes createPolylineAttributes(ShapefileRecord shapefileRecord) {
        return randomAttrs.nextPolylineAttributes();
    }

    protected ShapeAttributes createPolygonAttributes(ShapefileRecord shapefileRecord) {
        return randomAttrs.nextPolygonAttributes();
    }
}

