/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.event.MessageListener;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;

public class ScreenSelector
extends WWObjectImpl
implements MouseListener,
MouseMotionListener,
SelectListener {
    public static final String SELECTION_STARTED = "ScreenSelector.SelectionStarted";
    public static final String SELECTION_CHANGED = "ScreenSelector.SelectionChanged";
    public static final String SELECTION_ENDED = "ScreenSelector.SelectionEnded";
    protected WorldWindow wwd;
    protected Layer layer;
    protected SelectionRectangle selectionRect;
    protected List<Object> selectedObjects = new ArrayList<Object>();
    protected List<MessageListener> messageListeners = new ArrayList<MessageListener>();
    protected boolean armed;

    public ScreenSelector(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.layer = this.createLayer();
        this.layer.setPickEnabled(false);
        this.selectionRect = this.createSelectionRectangle();
        ((RenderableLayer)this.layer).addRenderable(this.selectionRect);
    }

    protected Layer createLayer() {
        return new RenderableLayer();
    }

    protected SelectionRectangle createSelectionRectangle() {
        return new SelectionRectangle();
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public Color getInteriorColor() {
        return this.selectionRect.getInteriorColor();
    }

    public void setInteriorColor(Color color) {
        this.selectionRect.setInteriorColor(color);
    }

    public Color getBorderColor() {
        return this.selectionRect.getBorderColor();
    }

    public void setBorderColor(Color color) {
        this.selectionRect.setBorderColor(color);
    }

    public void enable() {
        this.selectionRect.clearSelection();
        this.getWwd().getSceneController().setPickRectangle(null);
        LayerList layerList = this.getWwd().getModel().getLayers();
        if (!layerList.contains(this.getLayer())) {
            layerList.add(this.getLayer());
        }
        if (!this.getLayer().isEnabled()) {
            this.getLayer().setEnabled(true);
        }
        this.getWwd().getInputHandler().addMouseListener(this);
        this.getWwd().getInputHandler().addMouseMotionListener(this);
    }

    public void disable() {
        this.selectionRect.clearSelection();
        this.getWwd().getSceneController().setPickRectangle(null);
        this.getWwd().removeSelectListener(this);
        this.getWwd().getModel().getLayers().remove(this.getLayer());
        this.getWwd().getInputHandler().removeMouseListener(this);
        this.getWwd().getInputHandler().removeMouseMotionListener(this);
    }

    public List<?> getSelectedObjects() {
        return this.selectedObjects;
    }

    public void addMessageListener(MessageListener messageListener) {
        if (messageListener == null) {
            String string = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.messageListeners.add(messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) {
        if (messageListener == null) {
            String string = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.messageListeners.remove(messageListener);
    }

    protected void sendMessage(Message message) {
        for (MessageListener messageListener : this.messageListeners) {
            try {
                messageListener.onMessage(message);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionInvokingMessageListener");
                Logging.logger().severe(string);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        if (1024 != mouseEvent.getModifiersEx()) {
            return;
        }
        this.armed = true;
        this.selectionStarted(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        if (!this.armed) {
            return;
        }
        this.armed = false;
        this.selectionEnded(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        if (!this.armed) {
            return;
        }
        this.selectionChanged(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    protected void selectionStarted(MouseEvent mouseEvent) {
        this.selectionRect.startSelection(mouseEvent.getPoint());
        this.getWwd().getSceneController().setPickRectangle(null);
        this.getWwd().addSelectListener(this);
        this.getWwd().redraw();
        this.selectedObjects.clear();
        this.sendMessage(new Message(SELECTION_STARTED, this));
    }

    protected void selectionEnded(MouseEvent mouseEvent) {
        this.selectionRect.clearSelection();
        this.getWwd().getSceneController().setPickRectangle(null);
        this.getWwd().removeSelectListener(this);
        this.getWwd().redraw();
        this.sendMessage(new Message(SELECTION_ENDED, this));
    }

    protected void selectionChanged(MouseEvent mouseEvent) {
        Point point = this.limitPointToWorldWindow(mouseEvent.getPoint());
        this.selectionRect.endSelection(point);
        this.getWwd().getSceneController().setPickRectangle(this.selectionRect.hasSelection() ? new Rectangle(this.selectionRect.getSelection()) : null);
        this.getWwd().redraw();
    }

    protected Point limitPointToWorldWindow(Point point) {
        int n;
        Rectangle rectangle = this.getWwd().getView().getViewport();
        int n2 = point.x;
        if (n2 < rectangle.x) {
            n2 = rectangle.x;
        }
        if (n2 > rectangle.x + rectangle.width) {
            n2 = rectangle.x + rectangle.width;
        }
        if ((n = point.y) < rectangle.y) {
            n = rectangle.y;
        }
        if (n > rectangle.y + rectangle.height) {
            n = rectangle.y + rectangle.height;
        }
        return new Point(n2, n);
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        try {
            if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.BoxRollover") && this.armed) {
                this.selectObjects(selectEvent.getAllTopObjects());
            }
        }
        catch (Exception exception) {
            Util.getLogger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
        }
    }

    protected void selectObjects(List<?> list) {
        if (this.selectedObjects.equals(list)) {
            return;
        }
        this.selectedObjects.clear();
        if (list != null) {
            this.selectedObjects.addAll(list);
        }
        this.sendMessage(new Message(SELECTION_CHANGED, this));
    }

    protected static class SelectionRectangle
    implements OrderedRenderable {
        protected static final Color DEFAULT_INTERIOR_COLOR = new Color(255, 255, 255, 64);
        protected static final Color DEFAULT_BORDER_COLOR = Color.WHITE;
        protected Rectangle rect;
        protected Point startPoint;
        protected Point endPoint;
        protected Color interiorColor;
        protected Color borderColor;
        protected OGLStackHandler BEogsh = new OGLStackHandler();

        public SelectionRectangle() {
            this.rect = new Rectangle();
            this.startPoint = new Point();
            this.endPoint = new Point();
        }

        public boolean hasSelection() {
            return !this.rect.isEmpty();
        }

        public Rectangle getSelection() {
            return this.rect;
        }

        public void startSelection(Point point) {
            if (point == null) {
                String string = Logging.getMessage("nullValue.PointIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.startPoint.setLocation(point);
            this.endPoint.setLocation(point);
            this.rect.setRect(point.x, point.y, 0.0, 0.0);
        }

        public void endSelection(Point point) {
            double d;
            double d2;
            double d3;
            double d4;
            if (point == null) {
                String string = Logging.getMessage("nullValue.PointIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.endPoint.setLocation(point);
            if (this.startPoint.x < this.endPoint.x) {
                d4 = this.startPoint.x;
                d3 = this.endPoint.x;
            } else {
                d4 = this.endPoint.x;
                d3 = this.startPoint.x;
            }
            if (this.startPoint.y < this.endPoint.y) {
                d2 = this.startPoint.y;
                d = this.endPoint.y;
            } else {
                d2 = this.endPoint.y;
                d = this.startPoint.y;
            }
            if (d4 == d3 && d2 < d) {
                d3 = d4 + 1.0;
            }
            if (d2 == d && d4 < d3) {
                d2 = d - 1.0;
            }
            this.rect.setRect(d4, d, d3 - d4, d - d2);
        }

        public void clearSelection() {
            this.startPoint.setLocation(0, 0);
            this.endPoint.setLocation(0, 0);
            this.rect.setRect(0.0, 0.0, 0.0, 0.0);
        }

        public Color getInteriorColor() {
            return this.interiorColor;
        }

        public void setInteriorColor(Color color) {
            this.interiorColor = color;
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(Color color) {
            this.borderColor = color;
        }

        @Override
        public double getDistanceFromEye() {
            return 0.0;
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
        }

        @Override
        public void render(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (drawContext.isOrderedRenderingMode()) {
                this.drawOrderedRenderable(drawContext);
            } else {
                this.makeOrderedRenderable(drawContext);
            }
        }

        protected void makeOrderedRenderable(DrawContext drawContext) {
            if (this.hasSelection()) {
                drawContext.addOrderedRenderable(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void drawOrderedRenderable(DrawContext drawContext) {
            int n = 16641;
            Rectangle rectangle = drawContext.getView().getViewport();
            Rectangle rectangle2 = this.getSelection();
            GL2 gL2 = drawContext.getGL().getGL2();
            this.BEogsh.pushAttrib(gL2, n);
            this.BEogsh.pushClientAttrib(gL2, 32884);
            try {
                this.BEogsh.pushProjectionIdentity(gL2);
                gL2.glOrtho(0.0, rectangle.getWidth(), 0.0, rectangle.getHeight(), -1.0, 1.0);
                this.BEogsh.pushModelviewIdentity(gL2);
                gL2.glTranslated(0.5, 0.5, 0.0);
                gL2.glTranslated(rectangle2.getX(), rectangle.getHeight() - rectangle2.getY(), 0.0);
                gL2.glScaled(rectangle2.getWidth() - 1.0, rectangle2.getHeight() - 1.0, 1.0);
                gL2.glDisable(2929);
                gL2.glEnable(3042);
                OGLUtil.applyBlending(gL2, false);
                Color color = this.getInteriorColor() != null ? this.getInteriorColor() : DEFAULT_INTERIOR_COLOR;
                gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
                drawContext.drawUnitQuad();
                color = this.getBorderColor() != null ? this.getBorderColor() : DEFAULT_BORDER_COLOR;
                gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
                drawContext.drawUnitQuadOutline();
            }
            finally {
                this.BEogsh.pop(gL2);
            }
        }
    }
}

