/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ExampleUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzipAndSaveToTempFile(String string, String string2) {
        if (WWUtil.isEmpty(string)) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        InputStream inputStream = null;
        try {
            inputStream = WWIO.openStream(string);
            ByteBuffer byteBuffer = WWIO.readStreamToBuffer(inputStream);
            File file = WWIO.saveBufferToTempFile(byteBuffer, WWIO.getFilename(string));
            byteBuffer = WWIO.readZipEntryToBuffer(file, null);
            File file2 = WWIO.saveBufferToTempFile(byteBuffer, string2);
            return file2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            WWIO.closeStream(inputStream, string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveResourceToTempFile(String string, String string2) {
        if (WWUtil.isEmpty(string)) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        InputStream inputStream = null;
        try {
            inputStream = WWIO.openStream(string);
            ByteBuffer byteBuffer = WWIO.readStreamToBuffer(inputStream);
            File file = WWIO.saveBufferToTempFile(byteBuffer, string2);
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            WWIO.closeStream(inputStream, string);
        }
        return null;
    }

    public static void goTo(WorldWindow worldWindow, Sector sector) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Box box = Sector.computeBoundingBox(worldWindow.getModel().getGlobe(), worldWindow.getSceneController().getVerticalExaggeration(), sector);
        Angle angle = worldWindow.getView().getFieldOfView();
        double d = box.getRadius() / angle.cosHalfAngle() / angle.tanHalfAngle();
        worldWindow.getView().goTo(new Position(sector.getCentroid(), 0.0), d);
    }
}

