/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwindx.examples.util.AudioPlayer;
import gov.nasa.worldwindx.examples.util.AudioPlayerAnnotation;
import gov.nasa.worldwindx.examples.util.DialogAnnotationController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.Timer;

public class AudioPlayerAnnotationController
extends DialogAnnotationController
implements LineListener {
    protected static final long PLAYER_UPDATE_DELAY_MILLIS = 20L;
    private AudioPlayer audioPlayer;
    private Timer playerUpdateTimer;

    public AudioPlayerAnnotationController(WorldWindow worldWindow, AudioPlayerAnnotation audioPlayerAnnotation, Clip clip) {
        super(worldWindow, audioPlayerAnnotation);
        this.setAudioPlayer(new AudioPlayer());
        this.setClip(clip);
    }

    public AudioPlayerAnnotationController(WorldWindow worldWindow, AudioPlayerAnnotation audioPlayerAnnotation) {
        this(worldWindow, audioPlayerAnnotation, null);
    }

    public Clip getClip() {
        return this.audioPlayer.getClip();
    }

    public void setClip(Clip clip) {
        this.audioPlayer.setClip(clip);
        this.updateAudioAnnotation();
    }

    protected AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    protected void setAudioPlayer(AudioPlayer audioPlayer) {
        if (this.audioPlayer == audioPlayer) {
            return;
        }
        this.stopPlayerUpdate();
        if (this.audioPlayer != null) {
            this.audioPlayer.removeLineListener(this);
        }
        this.audioPlayer = audioPlayer;
        if (this.audioPlayer != null) {
            this.audioPlayer.addLineListener(this);
        }
    }

    public String getClipStatus() {
        return this.audioPlayer != null ? this.audioPlayer.getStatus() : null;
    }

    public void startClip() {
        if (this.audioPlayer == null) {
            return;
        }
        this.audioPlayer.play();
        this.updateAudioAnnotation();
    }

    public void stopClip() {
        if (this.audioPlayer == null) {
            return;
        }
        this.audioPlayer.stop();
        this.updateAudioAnnotation();
    }

    public void pauseClip() {
        if (this.audioPlayer == null) {
            return;
        }
        this.audioPlayer.pause();
        this.updateAudioAnnotation();
    }

    protected void updateAudioAnnotation() {
        if (this.getAnnotation() == null) {
            return;
        }
        if (this.audioPlayer != null) {
            long l = this.audioPlayer.getMillisecondPosition();
            long l2 = this.audioPlayer.getMillisecondLength();
            boolean bl = this.audioPlayer.getClip() != null;
            this.doUpdateAudioAnnotation(l, l2, bl);
        } else {
            this.doUpdateAudioAnnotation(0L, 0L, false);
        }
    }

    protected void doUpdateAudioAnnotation(long l, long l2, boolean bl) {
        AudioPlayerAnnotation audioPlayerAnnotation = (AudioPlayerAnnotation)this.getAnnotation();
        audioPlayerAnnotation.setClipPosition(l);
        audioPlayerAnnotation.setClipLength(l2);
        audioPlayerAnnotation.getPlayButton().setEnabled(bl);
        audioPlayerAnnotation.getBackButton().setEnabled(bl);
        this.getWorldWindow().redraw();
    }

    @Override
    public void onActionPerformed(ActionEvent actionEvent) {
        super.onActionPerformed(actionEvent);
        if (actionEvent.getActionCommand() == "gov.nasa.worldwind.avkey.Play") {
            this.playPressed(actionEvent);
        } else if (actionEvent.getActionCommand() == "gov.nasa.worldwind.avkey.Stop") {
            this.stopPressed(actionEvent);
        }
    }

    protected void playPressed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        if (this.getAnnotation() == null) {
            return;
        }
        this.onPlayPressed(actionEvent);
    }

    protected void stopPressed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        if (this.getAnnotation() == null) {
            return;
        }
        this.onStopPressed(actionEvent);
    }

    protected void onPlayPressed(ActionEvent actionEvent) {
        String string = this.getClipStatus();
        if (string == null) {
            return;
        }
        if (string == "gov.nasa.worldwind.avkey.Play") {
            this.pauseClip();
        } else if (string == "gov.nasa.worldwind.avkey.Stop" || string == "gov.nasa.worldwind.avkey.Pause") {
            this.startClip();
        }
    }

    protected void onStopPressed(ActionEvent actionEvent) {
        this.stopClip();
    }

    @Override
    public void update(LineEvent lineEvent) {
        if (lineEvent == null) {
            return;
        }
        if (this.getAnnotation() == null) {
            return;
        }
        if (lineEvent.getType() == LineEvent.Type.START) {
            this.onClipStart(lineEvent);
        } else if (lineEvent.getType() == LineEvent.Type.STOP) {
            this.onClipStop(lineEvent);
        }
    }

    protected void onClipStart(LineEvent lineEvent) {
        AudioPlayerAnnotation audioPlayerAnnotation = (AudioPlayerAnnotation)this.getAnnotation();
        audioPlayerAnnotation.setPlayButtonState("gov.nasa.worldwind.avkey.Pause");
        this.startPlayerUpdate();
        this.updateAudioAnnotation();
    }

    protected void onClipStop(LineEvent lineEvent) {
        AudioPlayerAnnotation audioPlayerAnnotation = (AudioPlayerAnnotation)this.getAnnotation();
        audioPlayerAnnotation.setPlayButtonState("gov.nasa.worldwind.avkey.Play");
        this.stopPlayerUpdate();
        this.updateAudioAnnotation();
    }

    protected void onPlayerUpdate() {
        this.updateAudioAnnotation();
    }

    protected void startPlayerUpdate() {
        this.playerUpdateTimer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioPlayerAnnotationController.this.onPlayerUpdate();
            }
        });
        this.playerUpdateTimer.start();
    }

    protected void stopPlayerUpdate() {
        if (this.playerUpdateTimer != null) {
            this.playerUpdateTimer.stop();
        }
        this.playerUpdateTimer = null;
    }
}

