/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.shapebuilder;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditorUtil;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.render.markers.MarkerRenderer;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import gov.nasa.worldwindx.examples.shapebuilder.AbstractShapeEditor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ExtrudedPolygonEditor
extends AbstractShapeEditor {
    public static final String MOVE_VERTEX_ACTION = "gov.nasa.worldwind.ExtrudedPolygonEditor.MoveVertexAction";
    public static final String CHANGE_HEIGHT_ACTION = "gov.nasa.worldwind.ExtrudedPolygonEditor.ChangeHeightAction";
    public static final String MOVE_POLYGON_ACTION = "gov.nasa.worldwind.ExtrudedPolygonEditor.MovePolygonAction";
    protected ExtrudedPolygon polygon;
    protected MarkerRenderer markerRenderer = new MarkerRenderer();
    List<Marker> controlPoints;
    protected BasicMarkerAttributes vertexControlAttributes;
    protected BasicMarkerAttributes heightControlAttributes;
    protected ControlPointMarker activeControlPoint;
    protected int activeControlPointIndex;

    public ExtrudedPolygonEditor() {
        this.markerRenderer.setKeepSeparated(false);
        this.markerRenderer.setOverrideMarkerElevation(false);
        this.markerRenderer.setEnablePickSizeReturn(true);
        this.assembleMarkerAttributes();
        this.initializeAnnotation();
        this.unitsFormat = new UnitsFormat();
    }

    public ExtrudedPolygon getPolygon() {
        return this.polygon;
    }

    public void setPolygon(ExtrudedPolygon extrudedPolygon) {
        if (extrudedPolygon == null) {
            String string = "nullValue.Shape";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.polygon = extrudedPolygon;
    }

    @Override
    public void setShape(AbstractShape abstractShape) {
        this.setPolygon((ExtrudedPolygon)abstractShape);
    }

    @Override
    public String getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(String string) {
    }

    protected void assembleControlPoints(DrawContext drawContext) {
        this.controlPoints = new ArrayList<Marker>();
        this.assembleVertexControlPoints(drawContext);
        this.assembleHeightControlPoints();
    }

    protected void assembleVertexControlPoints(DrawContext drawContext) {
        Terrain terrain = drawContext.getTerrain();
        ExtrudedPolygon extrudedPolygon = this.getPolygon();
        Position position = extrudedPolygon.getReferencePosition();
        Vec4 vec4 = terrain.getSurfacePoint(position.getLatitude(), position.getLongitude(), 0.0);
        int n = extrudedPolygon.getAltitudeMode();
        double d = extrudedPolygon.getHeight();
        Vec4 vec42 = null;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        for (LatLon latLon : extrudedPolygon.getOuterBoundary()) {
            Vec4 vec43;
            if (n == 3 || !(latLon instanceof Position)) {
                if (vec42 == null) {
                    vec42 = vec4.multiply3(d / vec4.getLength3());
                    d2 = vec42.getLength3();
                    d3 = vec4.getLength3();
                }
                vec43 = terrain.getSurfacePoint(latLon.getLatitude(), latLon.getLongitude(), 0.0);
                double d4 = d3 - vec43.dot3(vec4) / d3;
                vec43 = vec43.add3(vec42.multiply3(1.0 + d4 / d2));
            } else {
                vec43 = n == 2 ? terrain.getSurfacePoint(latLon.getLatitude(), latLon.getLongitude(), ((Position)latLon).getAltitude()) : terrain.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), ((Position)latLon).getAltitude() * terrain.getVerticalExaggeration());
            }
            Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec43);
            this.controlPoints.add(new ControlPointMarker(MOVE_VERTEX_ACTION, position2, vec43, this.vertexControlAttributes, n2));
            ++n2;
        }
    }

    protected void assembleHeightControlPoints() {
        if (this.controlPoints.size() < 2) {
            return;
        }
        Position position = this.controlPoints.get(0).getPosition();
        Position position2 = this.controlPoints.get(1).getPosition();
        Globe globe = this.wwd.getModel().getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computePointFromPosition(position2);
        Vec4 vec43 = vec4.add3(vec42).divide3(2.0);
        Position position3 = globe.computePositionFromPoint(vec43);
        this.controlPoints.add(new ControlPointMarker(CHANGE_HEIGHT_ACTION, position3, vec43, this.heightControlAttributes, this.controlPoints.size()));
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        if (this.frameTimestamp != drawContext.getFrameTimeStamp()) {
            this.assembleControlPoints(drawContext);
            this.frameTimestamp = drawContext.getFrameTimeStamp();
        }
        this.markerRenderer.render(drawContext, this.controlPoints);
        if (this.annotation != null && this.isShowAnnotation()) {
            this.annotation.render(drawContext);
        }
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.doRender(drawContext);
    }

    protected void assembleMarkerAttributes() {
        this.vertexControlAttributes = new BasicMarkerAttributes();
        this.vertexControlAttributes.setMaterial(Material.BLUE);
        this.heightControlAttributes = new BasicMarkerAttributes();
        this.heightControlAttributes.setMaterial(Material.RED);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isArmed() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            Object object = null;
            PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
            if (pickedObjectList != null) {
                object = pickedObjectList.getTopObject();
            }
            if (object instanceof ControlPointMarker) {
                this.removeVertex((ControlPointMarker)object);
                mouseEvent.consume();
            } else {
                this.addVertex(mouseEvent.getPoint());
                mouseEvent.consume();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.mousePoint;
        this.mousePoint = mouseEvent.getPoint();
        if (point == null) {
            point = this.mousePoint;
        }
        if (this.isShowAnnotation()) {
            if (this.activeControlPointIndex < 0) {
                this.updateAnnotation(this.polygon.getReferencePosition());
            } else if (this.controlPoints != null) {
                this.updateAnnotation(this.controlPoints.get(this.activeControlPointIndex).getPosition());
            }
        }
        if (MOVE_VERTEX_ACTION.equals(this.activeAction)) {
            this.moveControlPoint(this.activeControlPoint, point, this.mousePoint);
            mouseEvent.consume();
        } else if (CHANGE_HEIGHT_ACTION.equals(this.activeAction)) {
            this.setPolygonHeight(point, this.mousePoint);
            mouseEvent.consume();
        } else if (MOVE_POLYGON_ACTION.equals(this.activeAction)) {
            this.movePolygon(point, this.mousePoint);
            mouseEvent.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePoint = mouseEvent.getPoint();
        Object object = null;
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        if (pickedObjectList != null) {
            object = pickedObjectList.getTopObject();
        }
        if (object instanceof ControlPointMarker) {
            this.activeControlPoint = (ControlPointMarker)object;
            this.activeAction = this.activeControlPoint.getType();
            this.setShowAnnotation(true);
            this.updateAnnotation(this.activeControlPoint.getPosition());
            int n = 0;
            for (Marker marker : this.controlPoints) {
                if (marker.equals(object)) break;
                ++n;
            }
            this.activeControlPointIndex = n;
            mouseEvent.consume();
        } else if (object == this.getPolygon()) {
            this.activeAction = MOVE_POLYGON_ACTION;
            this.activeControlPointIndex = -1;
            this.setShowAnnotation(true);
            this.updateAnnotation(this.polygon.getReferencePosition());
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.activeControlPoint = null;
        this.activeAction = null;
        this.setShowAnnotation(false);
        this.updateAnnotation(null);
        mouseEvent.consume();
    }

    protected void movePolygon(Point point, Point point2) {
        View view = this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        Position position = this.polygon.getReferencePosition();
        if (position == null) {
            return;
        }
        Line line = view.computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec4 = AirspaceEditorUtil.intersectGlobeAt(this.wwd, position.getElevation(), line);
        Vec4 vec42 = AirspaceEditorUtil.intersectGlobeAt(this.wwd, position.getElevation(), line2);
        if (vec4 == null || vec42 == null) {
            return;
        }
        Position position2 = globe.computePositionFromPoint(vec4);
        Position position3 = globe.computePositionFromPoint(vec42);
        Position position4 = position2.subtract(position3);
        this.polygon.move(new Position(position4.getLatitude(), position4.getLongitude(), 0.0));
    }

    protected void moveControlPoint(ControlPointMarker controlPointMarker, Point point, Point point2) {
        View view = this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        Position position = controlPointMarker.getPosition();
        if (position == null) {
            return;
        }
        Line line = view.computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec4 = AirspaceEditorUtil.intersectGlobeAt(this.wwd, position.getElevation(), line);
        Vec4 vec42 = AirspaceEditorUtil.intersectGlobeAt(this.wwd, position.getElevation(), line2);
        if (vec4 == null || vec42 == null) {
            return;
        }
        Position position2 = globe.computePositionFromPoint(vec4);
        Position position3 = globe.computePositionFromPoint(vec42);
        Position position4 = position2.subtract(position3);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon latLon : this.polygon.getOuterBoundary()) {
            arrayList.add(latLon);
        }
        arrayList.set(controlPointMarker.getIndex(), new Position(position2.add((LatLon)position4), position.getAltitude()));
        arrayList.remove(arrayList.size() - 1);
        this.polygon.setOuterBoundary(arrayList);
    }

    protected void setPolygonHeight(Point point, Point point2) {
        Position position = this.polygon.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Vec4 vec42 = this.wwd.getModel().getGlobe().computeSurfaceNormalAtLocation(position.getLatitude(), position.getLongitude());
        Line line = new Line(vec4, vec42);
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line3 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec43 = AirspaceEditorUtil.nearestPointOnLine(line, line2);
        Vec4 vec44 = AirspaceEditorUtil.nearestPointOnLine(line, line3);
        Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec43);
        Position position3 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec44);
        double d = position2.getElevation() - position3.getElevation();
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (LatLon latLon : this.polygon.getOuterBoundary()) {
            arrayList.add(new Position(latLon, ((Position)latLon).getElevation() + d));
        }
        this.polygon.setOuterBoundary(arrayList);
    }

    protected void addVertex(Point point) {
        Object object;
        Line line = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec4 = this.intersectPolygonAltitudeAt(line);
        double d = Double.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < this.controlPoints.size(); ++i) {
            double d2;
            object = (ControlPointMarker)this.controlPoints.get(i);
            ControlPointMarker controlPointMarker = (ControlPointMarker)this.controlPoints.get((i + 1) % this.controlPoints.size());
            Vec4 object2 = AirspaceEditorUtil.nearestPointOnSegment(((ControlPointMarker)object).point, controlPointMarker.point, vec4);
            if (AirspaceEditorUtil.isPointBehindLineOrigin(line, object2) || !((d2 = object2.distanceTo3(vec4)) < d)) continue;
            n = i + 1;
            d = d2;
        }
        Position position = this.wwd.getModel().getGlobe().computePositionFromPoint(vec4);
        object = new ArrayList(this.controlPoints.size());
        for (LatLon latLon : this.getPolygon().getOuterBoundary()) {
            ((ArrayList)object).add((Position)latLon);
        }
        ((ArrayList)object).add(n, position);
        this.getPolygon().setOuterBoundary((Iterable<? extends LatLon>)object);
    }

    protected void removeVertex(ControlPointMarker controlPointMarker) {
        ExtrudedPolygon extrudedPolygon = this.getPolygon();
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(this.controlPoints.size() - 1);
        for (LatLon latLon : extrudedPolygon.getOuterBoundary()) {
            arrayList.add(latLon);
        }
        arrayList.remove(controlPointMarker.getIndex());
        extrudedPolygon.setOuterBoundary(arrayList);
    }

    protected Vec4 intersectPolygonAltitudeAt(Line line) {
        double d = 0.0;
        if (this.controlPoints.size() > 0) {
            d = this.controlPoints.get(0).getPosition().getElevation();
        }
        return AirspaceEditorUtil.intersectGlobeAt(this.wwd, d, line);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void updateAnnotation(Position position) {
        if (position == null) {
            this.annotation.getAttributes().setVisible(false);
            return;
        }
        String string = this.getDisplayString(position);
        if (string == null) {
            this.annotation.getAttributes().setVisible(false);
            return;
        }
        this.annotation.setText(string);
        Vec4 vec4 = this.computeAnnotationPosition(position);
        if (vec4 != null) {
            this.annotation.setScreenPoint(new Point((int)vec4.x, (int)vec4.y));
        }
        this.annotation.getAttributes().setVisible(true);
    }

    protected Vec4 computeAnnotationPosition(Position position) {
        Vec4 vec4 = this.wwd.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude());
        if (vec4 == null) {
            Globe globe = this.wwd.getModel().getGlobe();
            vec4 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), globe.getElevation(position.getLatitude(), position.getLongitude()));
        }
        return this.wwd.getView().project(vec4);
    }

    protected String getDisplayString(Position position) {
        String string = null;
        if (position != null) {
            string = this.formatMeasurements(position);
        }
        return string;
    }

    protected String formatMeasurements(Position position) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.arePositionsRedundant(position, this.polygon.getReferencePosition())) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.LatitudeLabel"), position.getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.LongitudeLabel"), position.getLongitude()));
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel("MeasureTool.AltitudeLabel"), position.getAltitude()));
        }
        if (this.polygon.getReferencePosition() != null) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.CenterLatitudeLabel"), this.polygon.getReferencePosition().getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.CenterLongitudeLabel"), this.polygon.getReferencePosition().getLongitude()));
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel("MeasureTool.CenterAltitudeLabel"), this.polygon.getReferencePosition().getAltitude()));
        }
        return stringBuilder.toString();
    }

    protected static class ControlPointMarker
    extends BasicMarker {
        protected int index;
        protected String type;
        protected Vec4 point;

        public ControlPointMarker(String string, Position position, Vec4 vec4, MarkerAttributes markerAttributes, int n) {
            super(position, markerAttributes);
            this.point = vec4;
            this.index = n;
            this.type = string;
        }

        public int getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        public Vec4 getPoint() {
            return this.point;
        }
    }
}

