/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.multiwindow;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.terrain.SectorGeometry;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwindx.examples.util.ViewVolumeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ViewVolumeViewer
extends JFrame {
    protected WWPanel wwp;
    protected WorldWindowGLCanvas wwd;
    protected WorldWindow observed;

    public ViewVolumeViewer(WorldWindow worldWindow, Dimension dimension) {
        this.observed = worldWindow;
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.wwp = new WWPanel((WorldWindowGLCanvas)this.observed, dimension, this.makeModel());
        this.getContentPane().add((Component)this.wwp, "Center");
        this.wwd = this.wwp.wwd;
        final SectorGeometryLayer sectorGeometryLayer = new SectorGeometryLayer();
        this.wwd.getModel().getLayers().add(sectorGeometryLayer);
        final ViewVolumeLayer viewVolumeLayer = new ViewVolumeLayer();
        this.wwd.getModel().getLayers().add(0, viewVolumeLayer);
        this.observed.addRenderingListener(new RenderingListener(){

            @Override
            public void stageChanged(RenderingEvent renderingEvent) {
                if (renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.AfterBufferSwap")) {
                    SectorGeometryList sectorGeometryList = new SectorGeometryList(ViewVolumeViewer.this.observed.getSceneController().getTerrain());
                    sectorGeometryLayer.setGeometry(sectorGeometryList);
                    viewVolumeLayer.setView(ViewVolumeViewer.this.observed.getView());
                    ViewVolumeViewer.this.wwd.redraw();
                }
            }
        });
        this.setTitle("View Volume Viewer");
        this.setResizable(true);
        this.pack();
    }

    protected Model makeModel() {
        LayerList layerList = new LayerList();
        for (Layer layer : this.observed.getModel().getLayers()) {
            if (!(layer instanceof TiledImageLayer)) continue;
            layerList.add(layer);
        }
        BasicModel basicModel = new BasicModel();
        basicModel.setGlobe(this.observed.getModel().getGlobe());
        basicModel.setLayers(layerList);
        return basicModel;
    }

    public WorldWindow getWwd() {
        return this.wwp.wwd;
    }

    public WorldWindow getObserved() {
        return this.observed;
    }

    protected static class ViewVolumeLayer
    extends RenderableLayer {
        protected View view;
        protected ViewVolumeRenderer renderer = new ViewVolumeRenderer();

        public ViewVolumeLayer() {
            this.setPickEnabled(false);
        }

        public void setView(View view) {
            this.view = view;
        }

        @Override
        protected void doRender(DrawContext drawContext) {
            if (this.view != null) {
                this.renderer.render(drawContext, this.view.getModelviewMatrix(), this.view.getProjectionMatrix(), this.view.getViewport());
            }
        }
    }

    protected static class SectorGeometryLayer
    extends RenderableLayer {
        protected SectorGeometryList sg;

        public SectorGeometryLayer() {
            this.setPickEnabled(false);
        }

        public void setGeometry(SectorGeometryList sectorGeometryList) {
            this.sg = sectorGeometryList;
        }

        @Override
        protected void doRender(DrawContext drawContext) {
            if (this.sg != null) {
                Position position = this.getCurrentPosition(drawContext);
                for (SectorGeometry sectorGeometry : this.sg) {
                    sectorGeometry.renderWireframe(drawContext, false, true);
                    if (position == null || !sectorGeometry.getSector().contains(position)) continue;
                    sectorGeometry.renderBoundingVolume(drawContext);
                    sectorGeometry.renderTileID(drawContext);
                }
            }
        }

        public Position getCurrentPosition(DrawContext drawContext) {
            PickedObjectList pickedObjectList = drawContext.getPickedObjects();
            PickedObject pickedObject = pickedObjectList != null ? pickedObjectList.getTerrainObject() : null;
            return pickedObject != null ? pickedObject.getPosition() : null;
        }
    }

    protected static class WWPanel
    extends JPanel {
        protected WorldWindowGLCanvas wwd;

        public WWPanel(WorldWindowGLCanvas worldWindowGLCanvas, Dimension dimension, Model model) {
            this.wwd = worldWindowGLCanvas != null ? new WorldWindowGLCanvas(worldWindowGLCanvas) : new WorldWindowGLCanvas();
            this.wwd.setSize(dimension);
            this.wwd.setModel(model);
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)((Object)this.wwd), "Center");
            StatusBar statusBar = new StatusBar();
            statusBar.setEventSource(this.wwd);
            this.add((Component)statusBar, "South");
        }
    }
}

