/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.multiwindow;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.BMNGOneImage;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.ScalebarLayer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import gov.nasa.worldwindx.examples.util.HighlightController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FlatAndRoundGlobes {
    protected static final int NUM_PATHS = 200;
    protected static final int NUM_POSITIONS = 200;
    protected static final Angle PATH_LENGTH = Angle.fromDegrees(5.0);
    protected static final double PATH_HEIGHT = 1000.0;
    protected static final LatLon START_LOCATION = LatLon.fromDegrees(48.86, 2.33);
    protected static final int ALTITUDE_MODE = 2;
    protected static final double LINE_WIDTH = 1.0;

    public FlatAndRoundGlobes() {
        LayerList layerList = this.makeCommonLayers();
        Model model = this.makeModel(new Earth(), layerList);
        Model model2 = this.makeModel(new EarthFlat(), layerList);
        ((EarthFlat)model2.getGlobe()).setProjection("gov.nasa.worldwind.globes.projectionSinusoidal");
        WWFrame wWFrame = new WWFrame(null, model, "Round Globe", "gov.nasa.worldwind.avkey.LeftOfCenter");
        WWFrame wWFrame2 = new WWFrame(wWFrame.wwPanel.wwd, model2, "Flat Globe", "gov.nasa.worldwind.avkey.RightOfCenter");
        wWFrame2.wwPanel.wwd.setView(new FlatOrbitView());
        this.addViewControlLayer(wWFrame);
        this.addViewControlLayer(wWFrame2);
        wWFrame.wwPanel.wwd.getView().setEyePosition(new Position(START_LOCATION, 3000000.0));
        wWFrame2.wwPanel.wwd.getView().setEyePosition(new Position(START_LOCATION, 3000000.0));
        wWFrame.setVisible(true);
        wWFrame2.setVisible(true);
    }

    protected LayerList makeCommonLayers() {
        LayerList layerList = new LayerList();
        layerList.add(new BMNGOneImage());
        Factory factory = (Factory)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.LayerFactory");
        Layer layer = (Layer)factory.createFromConfigSource("config/Earth/BMNGWMSLayer.xml", null);
        layer.setEnabled(true);
        layerList.add(layer);
        layerList.add(this.makePathLayer());
        layerList.add(this.makePolygonLayer());
        layerList.add(this.makeExtrudedPolygonLayer());
        return layerList;
    }

    protected Model makeModel(Globe globe, LayerList layerList) {
        BasicModel basicModel = new BasicModel(globe, new LayerList(layerList));
        basicModel.getLayers().add(new CompassLayer());
        basicModel.getLayers().add(new WorldMapLayer());
        basicModel.getLayers().add(new ScalebarLayer());
        return basicModel;
    }

    protected void addViewControlLayer(WWFrame wWFrame) {
        ViewControlsLayer viewControlsLayer = new ViewControlsLayer();
        wWFrame.wwPanel.wwd.getModel().getLayers().add(viewControlsLayer);
        wWFrame.wwPanel.wwd.addSelectListener(new ViewControlsSelectListener(wWFrame.wwPanel.wwd, viewControlsLayer));
    }

    protected Layer makePathLayer() {
        RenderableLayer renderableLayer = new RenderableLayer();
        renderableLayer.setName("Paths");
        this.makePaths(renderableLayer, new Position(START_LOCATION, 1000.0), 200, PATH_LENGTH, 200);
        return renderableLayer;
    }

    protected void makePaths(RenderableLayer renderableLayer, Position position, int n, Angle angle, int n2) {
        double d = 360.0 / (double)n;
        for (int i = 0; i < n; ++i) {
            Angle angle2 = Angle.fromDegrees((double)i * d);
            renderableLayer.addRenderable(this.makePath(position, angle2, angle, n2));
        }
        System.out.printf("%d paths, each with %d positions\n", 200, 200);
    }

    protected Path makePath(Position position, Angle angle, Angle angle2, int n) {
        Object object;
        double d = angle2.radians / (double)(n - 1);
        ArrayList<Position> arrayList = new ArrayList<Position>(n);
        for (int i = 0; i < n - 1; ++i) {
            object = Position.greatCircleEndPosition((LatLon)position, angle, Angle.fromRadians((double)i * d));
            arrayList.add(new Position((LatLon)object, 1000.0));
        }
        LatLon latLon = Position.greatCircleEndPosition((LatLon)position, angle, angle2);
        arrayList.add(new Position(latLon, 1000.0));
        object = new Path(arrayList);
        ((AbstractShape)object).setAltitudeMode(2);
        ((Path)object).setExtrude(true);
        ((Path)object).setDrawVerticals(true);
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeRandomColor(null)));
        basicShapeAttributes.setInteriorMaterial(basicShapeAttributes.getOutlineMaterial());
        basicShapeAttributes.setInteriorOpacity(0.5);
        basicShapeAttributes.setDrawOutline(true);
        basicShapeAttributes.setDrawInterior(true);
        basicShapeAttributes.setOutlineWidth(1.0);
        ((AbstractShape)object).setAttributes(basicShapeAttributes);
        return object;
    }

    protected Layer makePolygonLayer() {
        RenderableLayer renderableLayer = new RenderableLayer();
        renderableLayer.setName("Polygons");
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
        basicShapeAttributes.setOutlineOpacity(0.5);
        basicShapeAttributes.setInteriorOpacity(0.8);
        basicShapeAttributes.setOutlineMaterial(Material.GREEN);
        basicShapeAttributes.setOutlineWidth(2.0);
        basicShapeAttributes.setDrawOutline(true);
        basicShapeAttributes.setDrawInterior(true);
        basicShapeAttributes.setEnableLighting(true);
        BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes(basicShapeAttributes);
        basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
        basicShapeAttributes2.setOutlineOpacity(1.0);
        ArrayList<Position> arrayList = new ArrayList<Position>();
        arrayList.add(Position.fromDegrees(28.0, -106.0, 30000.0));
        arrayList.add(Position.fromDegrees(35.0, -104.0, 30000.0));
        arrayList.add(Position.fromDegrees(35.0, -107.0, 90000.0));
        arrayList.add(Position.fromDegrees(28.0, -107.0, 90000.0));
        arrayList.add(Position.fromDegrees(28.0, -106.0, 30000.0));
        Polygon polygon = new Polygon(arrayList);
        polygon.setValue("gov.nasa.worldwind.avkey.DisplayName", "Has a hole\nRotated -170\u00b0");
        arrayList.clear();
        arrayList.add(Position.fromDegrees(29.0, -106.4, 40000.0));
        arrayList.add(Position.fromDegrees(30.0, -106.4, 40000.0));
        arrayList.add(Position.fromDegrees(29.0, -106.8, 70000.0));
        arrayList.add(Position.fromDegrees(29.0, -106.4, 40000.0));
        polygon.addInnerBoundary(arrayList);
        polygon.setAltitudeMode(2);
        polygon.setAttributes(basicShapeAttributes);
        polygon.setHighlightAttributes(basicShapeAttributes2);
        polygon.setRotation(-90.0);
        renderableLayer.addRenderable(polygon);
        ArrayList<Position> arrayList2 = new ArrayList<Position>();
        arrayList2.add(Position.fromDegrees(28.0, -110.0, 50000.0));
        arrayList2.add(Position.fromDegrees(35.0, -108.0, 50000.0));
        arrayList2.add(Position.fromDegrees(35.0, -111.0, 50000.0));
        arrayList2.add(Position.fromDegrees(28.0, -111.0, 50000.0));
        arrayList2.add(Position.fromDegrees(28.0, -110.0, 50000.0));
        polygon = new Polygon(arrayList2);
        polygon.setValue("gov.nasa.worldwind.avkey.DisplayName", "Has an image");
        basicShapeAttributes = new BasicShapeAttributes(basicShapeAttributes);
        basicShapeAttributes.setDrawInterior(true);
        basicShapeAttributes.setInteriorMaterial(Material.WHITE);
        basicShapeAttributes.setInteriorOpacity(1.0);
        polygon.setAttributes(basicShapeAttributes);
        polygon.setHighlightAttributes(basicShapeAttributes2);
        float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        polygon.setTextureImageSource("images/32x32-icon-nasa.png", fArray, 5);
        renderableLayer.addRenderable(polygon);
        return renderableLayer;
    }

    protected Layer makeExtrudedPolygonLayer() {
        RenderableLayer renderableLayer = new RenderableLayer();
        renderableLayer.setName("Extruded Polygons");
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setInteriorMaterial(Material.MAGENTA);
        basicShapeAttributes.setOutlineOpacity(0.5);
        basicShapeAttributes.setInteriorOpacity(0.5);
        basicShapeAttributes.setOutlineMaterial(Material.GREEN);
        basicShapeAttributes.setOutlineWidth(2.0);
        basicShapeAttributes.setDrawOutline(true);
        basicShapeAttributes.setDrawInterior(true);
        basicShapeAttributes.setEnableLighting(true);
        BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes(basicShapeAttributes);
        basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
        basicShapeAttributes2.setOutlineOpacity(1.0);
        BasicShapeAttributes basicShapeAttributes3 = new BasicShapeAttributes(basicShapeAttributes);
        basicShapeAttributes3.setInteriorMaterial(Material.YELLOW);
        basicShapeAttributes3.setInteriorOpacity(0.8);
        basicShapeAttributes3.setDrawInterior(true);
        basicShapeAttributes3.setEnableLighting(true);
        ArrayList<Position> arrayList = new ArrayList<Position>();
        arrayList.add(Position.fromDegrees(36.0, -106.0, 30000.0));
        arrayList.add(Position.fromDegrees(43.0, -104.0, 30000.0));
        arrayList.add(Position.fromDegrees(43.0, -107.0, 90000.0));
        arrayList.add(Position.fromDegrees(36.0, -107.0, 90000.0));
        arrayList.add(Position.fromDegrees(36.0, -106.0, 30000.0));
        ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon(arrayList);
        arrayList.clear();
        arrayList.add(Position.fromDegrees(37.0, -106.4, 40000.0));
        arrayList.add(Position.fromDegrees(38.0, -106.4, 40000.0));
        arrayList.add(Position.fromDegrees(37.0, -106.8, 70000.0));
        arrayList.add(Position.fromDegrees(37.0, -106.4, 40000.0));
        extrudedPolygon.addInnerBoundary(arrayList);
        extrudedPolygon.setAltitudeMode(2);
        extrudedPolygon.setSideAttributes(basicShapeAttributes);
        extrudedPolygon.setSideHighlightAttributes(basicShapeAttributes2);
        extrudedPolygon.setCapAttributes(basicShapeAttributes3);
        renderableLayer.addRenderable(extrudedPolygon);
        ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
        arrayList2.add(LatLon.fromDegrees(36.0, -110.0));
        arrayList2.add(LatLon.fromDegrees(43.0, -108.0));
        arrayList2.add(LatLon.fromDegrees(43.0, -111.0));
        arrayList2.add(LatLon.fromDegrees(36.0, -111.0));
        arrayList2.add(LatLon.fromDegrees(36.0, -110.0));
        extrudedPolygon = new ExtrudedPolygon(arrayList2, 60000.0);
        extrudedPolygon.setSideAttributes(basicShapeAttributes);
        extrudedPolygon.setSideHighlightAttributes(basicShapeAttributes2);
        extrudedPolygon.setCapAttributes(basicShapeAttributes3);
        renderableLayer.addRenderable(extrudedPolygon);
        return renderableLayer;
    }

    public static void main(String[] stringArray) {
        String string = "World Wind MultiGlobe";
        if (Configuration.isMacOS()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FlatAndRoundGlobes();
            }
        });
    }

    protected static class WWPanel
    extends JPanel {
        protected WorldWindowGLCanvas wwd;
        protected HighlightController highlightController;

        public WWPanel(WorldWindowGLCanvas worldWindowGLCanvas, Dimension dimension, Model model) {
            this.wwd = worldWindowGLCanvas != null ? new WorldWindowGLCanvas(worldWindowGLCanvas) : new WorldWindowGLCanvas();
            this.wwd.setSize(dimension);
            this.wwd.setModel(model);
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)((Object)this.wwd), "Center");
            StatusBar statusBar = new StatusBar();
            statusBar.setEventSource(this.wwd);
            this.add((Component)statusBar, "South");
            this.highlightController = new HighlightController(this.wwd, "gov.nasa.worldwind.SelectEvent.Rollover");
        }
    }

    protected static class WWFrame
    extends JFrame {
        protected Dimension canvasSize = new Dimension(800, 600);
        protected WWPanel wwPanel;

        public WWFrame(WorldWindowGLCanvas worldWindowGLCanvas, Model model, String string, String string2) {
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            this.wwPanel = new WWPanel(worldWindowGLCanvas, this.canvasSize, model);
            this.getContentPane().add((Component)this.wwPanel, "Center");
            this.setTitle(string);
            WWUtil.alignComponent(null, this, string2);
            this.setResizable(true);
            this.pack();
            this.setDefaultCloseOperation(3);
        }
    }
}

