/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.multiwindow;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.BMNGWMSLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3WMSLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.StarsLayer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class CardLayoutUsage
extends JFrame {
    private WWPanel wwpA;
    private WWPanel wwpB;

    public CardLayoutUsage() {
        try {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new CardLayout());
            this.wwpA = new WWPanel(null, 600, 600);
            jPanel.add((Component)this.wwpA, "World Window A");
            Earth earth = new Earth();
            Layer[] layerArray = new Layer[]{new StarsLayer(), new CompassLayer(), new BMNGWMSLayer(), new LandsatI3WMSLayer()};
            BasicModel basicModel = new BasicModel();
            basicModel.setGlobe(earth);
            basicModel.setLayers(new LayerList(layerArray));
            this.wwpA.wwd.setModel(basicModel);
            BasicModel basicModel2 = new BasicModel();
            basicModel2.setGlobe(earth);
            basicModel2.setLayers(new LayerList(layerArray));
            ViewControlsLayer viewControlsLayer = new ViewControlsLayer();
            this.wwpA.wwd.getModel().getLayers().add(viewControlsLayer);
            this.wwpA.wwd.addSelectListener(new ViewControlsSelectListener(this.wwpA.wwd, viewControlsLayer));
            ViewControlsLayer viewControlsLayer2 = new ViewControlsLayer();
            this.add((Component)jPanel, "Center");
            this.add((Component)this.makeControlPanel((CardLayout)jPanel.getLayout(), jPanel), "South");
            this.setTitle("World Wind Multi-Window CardLayout");
            this.setDefaultCloseOperation(3);
            this.pack();
            WWUtil.alignComponent(null, this, "gov.nasa.worldwind.avkey.Center");
            this.setResizable(true);
            this.setVisible(true);
            this.wwpB = new WWPanel(this.wwpA.wwd, this.wwpA.getWidth(), this.wwpA.getHeight());
            jPanel.add((Component)this.wwpB, "World Window B");
            this.wwpB.wwd.setModel(basicModel2);
            this.wwpB.wwd.getModel().getLayers().add(viewControlsLayer2);
            this.wwpB.wwd.addSelectListener(new ViewControlsSelectListener(this.wwpB.wwd, viewControlsLayer2));
            this.wwpA.wwd.redraw();
            this.wwpB.wwd.redraw();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JPanel makeControlPanel(final CardLayout cardLayout, final JPanel jPanel) {
        final JButton jButton = new JButton("World Window A");
        final JButton jButton2 = new JButton(" World Window B");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel, "World Window A");
                jButton.setEnabled(false);
                jButton2.setEnabled(true);
                ((CardLayoutUsage)CardLayoutUsage.this).wwpA.wwd.redraw();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel, "World Window B");
                jButton.setEnabled(true);
                jButton2.setEnabled(false);
                ((CardLayoutUsage)CardLayoutUsage.this).wwpB.wwd.redraw();
            }
        });
        jButton.setEnabled(false);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        return jPanel2;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CardLayoutUsage();
            }
        });
    }

    private static class WWPanel
    extends JPanel {
        WorldWindowGLCanvas wwd;

        public WWPanel(WorldWindowGLCanvas worldWindowGLCanvas, int n, int n2) {
            this.wwd = worldWindowGLCanvas != null ? new WorldWindowGLCanvas(worldWindowGLCanvas) : new WorldWindowGLCanvas();
            this.wwd.setSize(new Dimension(n, n2));
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)((Object)this.wwd), "Center");
            StatusBar statusBar = new StatusBar();
            statusBar.setBorder(new EmptyBorder(5, 5, 5, 5));
            statusBar.setEventSource(this.wwd);
            this.add((Component)statusBar, "South");
        }
    }
}

