/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.lineofsight;

import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.terrain.Terrain;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LineIntersector
implements Runnable {
    protected Terrain terrain;
    protected int numThreads;
    protected Position referencePosition;
    protected Iterable<Position> positions;
    protected int numPositions;
    protected Vec4 referencePoint;
    protected ThreadPoolExecutor threadPool;
    protected AtomicInteger numProcessedPositions = new AtomicInteger();
    protected long startTime;
    protected long endTime;
    protected Map<Position, List<Intersection>> allIntersections;

    protected LineIntersector(Terrain terrain, int n) {
        this.terrain = terrain;
        this.numThreads = n;
        this.threadPool = new ThreadPoolExecutor(n, n, 200L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.allIntersections = new ConcurrentHashMap<Position, List<Intersection>>();
    }

    protected abstract void doPerformIntersection(Position var1) throws InterruptedException;

    public Terrain getTerrain() {
        return this.terrain;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public Position getReferencePosition() {
        return this.referencePosition;
    }

    public void setReferencePosition(Position position) {
        this.referencePosition = position;
    }

    public Iterable<Position> getPositions() {
        return this.positions;
    }

    public void setPositions(Iterable<Position> iterable) {
        this.positions = iterable;
        for (Position position : this.positions) {
            ++this.numPositions;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getNumProcessedPositions() {
        return this.numProcessedPositions.get();
    }

    public Map<Position, List<Intersection>> getAllIntersections() {
        return this.allIntersections;
    }

    public List<Intersection> getIntersections(Position position) {
        return position != null ? this.allIntersections.get(position) : null;
    }

    @Override
    public void run() {
        if (this.referencePosition == null || this.positions == null) {
            throw new IllegalStateException("No reference positions or grid positions specified.");
        }
        this.startTime = System.currentTimeMillis();
        this.numProcessedPositions.set(0);
        this.allIntersections.clear();
        try {
            this.referencePoint = this.terrain.getSurfacePoint(this.referencePosition.getLatitude(), this.referencePosition.getLongitude(), this.referencePosition.getAltitude());
            for (Position position : this.positions) {
                if (this.numThreads > 1) {
                    this.threadPool.execute(new InternalIntersector(position));
                    continue;
                }
                this.performIntersection(position);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    protected void performIntersection(Position position) throws InterruptedException {
        try {
            this.doPerformIntersection(position);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.numProcessedPositions.addAndGet(1) >= this.numPositions) {
            this.endTime = System.currentTimeMillis();
        }
    }

    protected class InternalIntersector
    implements Runnable {
        protected final Position position;

        public InternalIntersector(Position position) {
            this.position = position;
        }

        @Override
        public void run() {
            try {
                LineIntersector.this.performIntersection(this.position);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

