/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.layermanager;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwindx.examples.layermanager.ElevationModelManagerPanel;
import gov.nasa.worldwindx.examples.layermanager.LayerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ElevationModelPanel
extends JPanel {
    protected ElevationModel elevationModel;
    protected JCheckBox checkBox;
    protected JButton upButton;
    protected JButton downButton;

    public ElevationModelPanel(final WorldWindow worldWindow, final ElevationModelManagerPanel elevationModelManagerPanel, final ElevationModel elevationModel) {
        super(new BorderLayout(10, 10));
        this.elevationModel = elevationModel;
        SelectModelAction selectModelAction = new SelectModelAction(worldWindow, elevationModel, elevationModel.isEnabled());
        this.checkBox = new JCheckBox(selectModelAction);
        this.checkBox.setSelected(selectModelAction.selected);
        this.add((Component)this.checkBox, "Center");
        this.upButton = new JButton(LayerPanel.UP_ARROW);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ElevationModelPanel.this.moveElevationModel(worldWindow, elevationModel, -1);
                elevationModelManagerPanel.update(worldWindow);
            }
        });
        this.downButton = new JButton(LayerPanel.DOWN_ARROW);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ElevationModelPanel.this.moveElevationModel(worldWindow, elevationModel, 1);
                elevationModelManagerPanel.update(worldWindow);
            }
        });
        this.upButton.setBorderPainted(false);
        this.upButton.setContentAreaFilled(false);
        this.upButton.setPreferredSize(new Dimension(24, 24));
        this.downButton.setBorderPainted(false);
        this.downButton.setContentAreaFilled(false);
        this.downButton.setPreferredSize(new Dimension(24, 24));
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 5, 0));
        jPanel.add(this.upButton);
        jPanel.add(this.downButton);
        this.add((Component)jPanel, "East");
        int n = this.findElevationModelPosition(worldWindow, elevationModel);
        this.upButton.setEnabled(n != 0);
        this.downButton.setEnabled(n != this.getNumElevationModels(worldWindow) - 1);
    }

    public ElevationModel getElevationModel() {
        return this.elevationModel;
    }

    protected void moveElevationModel(WorldWindow worldWindow, ElevationModel elevationModel, int n) {
        int n2 = this.findElevationModelPosition(worldWindow, elevationModel);
        if (n2 < 0) {
            return;
        }
        CompoundElevationModel compoundElevationModel = (CompoundElevationModel)worldWindow.getModel().getGlobe().getElevationModel();
        if (n < 0 && n2 == 0) {
            return;
        }
        if (n > 0 && n2 == compoundElevationModel.getElevationModels().size() - 1) {
            return;
        }
        compoundElevationModel.getElevationModels().remove(elevationModel);
        if (n > 0) {
            compoundElevationModel.getElevationModels().add(n2 + 1, elevationModel);
        } else if (n < 0) {
            compoundElevationModel.getElevationModels().add(n2 - 1, elevationModel);
        }
        worldWindow.redraw();
    }

    protected int findElevationModelPosition(WorldWindow worldWindow, ElevationModel elevationModel) {
        if (!(worldWindow.getModel().getGlobe().getElevationModel() instanceof CompoundElevationModel)) {
            return -1;
        }
        CompoundElevationModel compoundElevationModel = (CompoundElevationModel)worldWindow.getModel().getGlobe().getElevationModel();
        for (int i = 0; i < compoundElevationModel.getElevationModels().size(); ++i) {
            if (elevationModel != compoundElevationModel.getElevationModels().get(i)) continue;
            return i;
        }
        return -1;
    }

    protected int getNumElevationModels(WorldWindow worldWindow) {
        if (!(worldWindow.getModel().getGlobe().getElevationModel() instanceof CompoundElevationModel)) {
            return 1;
        }
        CompoundElevationModel compoundElevationModel = (CompoundElevationModel)worldWindow.getModel().getGlobe().getElevationModel();
        return compoundElevationModel.getElevationModels().size();
    }

    protected static class SelectModelAction
    extends AbstractAction {
        protected WorldWindow wwd;
        protected ElevationModel elevationModel;
        protected boolean selected;

        public SelectModelAction(WorldWindow worldWindow, ElevationModel elevationModel, boolean bl) {
            super(elevationModel.getName());
            this.wwd = worldWindow;
            this.elevationModel = elevationModel;
            this.selected = bl;
            this.elevationModel.setEnabled(this.selected);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                this.elevationModel.setEnabled(true);
            } else {
                this.elevationModel.setEnabled(false);
            }
            this.wwd.redraw();
        }
    }
}

