/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.dataimport;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.terrain.LocalElevationModel;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.awt.Cursor;
import java.io.File;
import javax.swing.SwingUtilities;

public class ImportElevations
extends ApplicationTemplate {
    protected static final String ELEVATIONS_PATH = "gov/nasa/worldwindx/examples/data/craterlake-elev-16bit-30m.tif";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Elevation Import", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.setCursor(new Cursor(3));
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.importElevations();
                    AppFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            });
            thread.start();
        }

        protected void importElevations() {
            try {
                File file = ExampleUtil.saveResourceToTempFile(ImportElevations.ELEVATIONS_PATH, ".tif");
                final LocalElevationModel localElevationModel = new LocalElevationModel();
                localElevationModel.addElevations(file);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Globe globe = AppFrame.this.getWwd().getModel().getGlobe();
                        ElevationModel elevationModel = globe.getElevationModel();
                        if (elevationModel instanceof CompoundElevationModel) {
                            ((CompoundElevationModel)elevationModel).addElevationModel(localElevationModel);
                        } else {
                            globe.setElevationModel(localElevationModel);
                        }
                        Sector sector = localElevationModel.getSector();
                        ExampleUtil.goTo(AppFrame.this.getWwd(), sector);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

