/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.analytics;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.BufferWrapperRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.BufferFactory;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWBufferUtil;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurface;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceAttributes;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceLegend;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AnalyticSurfaceDemo
extends ApplicationTemplate {
    protected static final String DATA_PATH = "gov/nasa/worldwindx/examples/data/wa-precip-24hmam-5km.tif";
    protected static final int DEFAULT_RANDOM_ITERATIONS = 1000;
    protected static final double DEFAULT_RANDOM_SMOOTHING = 0.5;

    protected static Renderable createLegendRenderable(final AnalyticSurface analyticSurface, final double d, final AnalyticSurfaceLegend analyticSurfaceLegend) {
        return new Renderable(){

            @Override
            public void render(DrawContext drawContext) {
                Extent extent = analyticSurface.getExtent(drawContext);
                if (!extent.intersects(drawContext.getView().getFrustumInModelCoordinates())) {
                    return;
                }
                if (WWMath.computeSizeInWindowCoordinates(drawContext, extent) < d) {
                    return;
                }
                analyticSurfaceLegend.render(drawContext);
            }
        };
    }

    protected static void createRandomAltitudeSurface(double d, double d2, int n, int n2, RenderableLayer renderableLayer) {
        double d3 = -200000.0;
        double d4 = 200000.0;
        AnalyticSurface analyticSurface = new AnalyticSurface();
        analyticSurface.setSector(Sector.fromDegrees(25.0, 35.0, -90.0, -80.0));
        analyticSurface.setAltitude(400000.0);
        analyticSurface.setDimensions(n, n2);
        analyticSurface.setClientLayer(renderableLayer);
        renderableLayer.addRenderable(analyticSurface);
        BufferWrapper bufferWrapper = AnalyticSurfaceDemo.randomGridValues(n, n2, d3, d4);
        BufferWrapper bufferWrapper2 = AnalyticSurfaceDemo.randomGridValues(n, n2, d3 * 2.0, d4 / 2.0);
        AnalyticSurfaceDemo.mixValuesOverTime(2000L, bufferWrapper, bufferWrapper2, d3, d4, d, d2, analyticSurface);
        AnalyticSurfaceAttributes analyticSurfaceAttributes = new AnalyticSurfaceAttributes();
        analyticSurfaceAttributes.setShadowOpacity(0.5);
        analyticSurface.setSurfaceAttributes(analyticSurfaceAttributes);
        final double d5 = analyticSurface.getAltitude();
        final double d6 = analyticSurface.getVerticalScale();
        DecimalFormat decimalFormat = new DecimalFormat("# km"){

            @Override
            public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                double d2 = d5 + d6 * d;
                double d3 = d2 * 0.001;
                return super.format(d3, stringBuffer, fieldPosition);
            }
        };
        AnalyticSurfaceLegend analyticSurfaceLegend = AnalyticSurfaceLegend.fromColorGradient(d3, d4, d, d2, AnalyticSurfaceLegend.createDefaultColorGradientLabels(d3, d4, decimalFormat), AnalyticSurfaceLegend.createDefaultTitle("Random Altitudes"));
        analyticSurfaceLegend.setOpacity(0.8);
        analyticSurfaceLegend.setScreenLocation(new Point(650, 300));
        renderableLayer.addRenderable(AnalyticSurfaceDemo.createLegendRenderable(analyticSurface, 300.0, analyticSurfaceLegend));
    }

    protected static void createRandomColorSurface(double d, double d2, int n, int n2, RenderableLayer renderableLayer) {
        double d3 = -200000.0;
        double d4 = 200000.0;
        AnalyticSurface analyticSurface = new AnalyticSurface();
        analyticSurface.setSector(Sector.fromDegrees(25.0, 35.0, -110.0, -100.0));
        analyticSurface.setAltitudeMode(1);
        analyticSurface.setDimensions(n, n2);
        analyticSurface.setClientLayer(renderableLayer);
        renderableLayer.addRenderable(analyticSurface);
        BufferWrapper bufferWrapper = AnalyticSurfaceDemo.randomGridValues(n, n2, d3, d4);
        BufferWrapper bufferWrapper2 = AnalyticSurfaceDemo.randomGridValues(n, n2, d3 * 2.0, d4 / 2.0);
        AnalyticSurfaceDemo.mixValuesOverTime(2000L, bufferWrapper, bufferWrapper2, d3, d4, d, d2, analyticSurface);
        AnalyticSurfaceAttributes analyticSurfaceAttributes = new AnalyticSurfaceAttributes();
        analyticSurfaceAttributes.setDrawShadow(false);
        analyticSurfaceAttributes.setInteriorOpacity(0.6);
        analyticSurfaceAttributes.setOutlineWidth(3.0);
        analyticSurface.setSurfaceAttributes(analyticSurfaceAttributes);
    }

    protected static void mixValuesOverTime(final long l, final BufferWrapper bufferWrapper, final BufferWrapper bufferWrapper2, final double d, final double d2, final double d3, final double d4, final AnalyticSurface analyticSurface) {
        Timer timer = new Timer(20, new ActionListener(){
            protected long startTime = -1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.startTime < 0L) {
                    this.startTime = System.currentTimeMillis();
                }
                double d5 = (double)(actionEvent.getWhen() - this.startTime) / (double)l;
                int n = (int)Math.floor(d5);
                double d22 = d5 - (double)n;
                if (n % 2 == 0) {
                    d22 = 1.0 - d22;
                }
                analyticSurface.setValues(AnalyticSurfaceDemo.createMixedColorGradientGridValues(d22, bufferWrapper, bufferWrapper2, d, d2, d3, d4));
                if (analyticSurface.getClientLayer() != null) {
                    analyticSurface.getClientLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, analyticSurface.getClientLayer());
                }
            }
        });
        timer.start();
    }

    public static Iterable<? extends AnalyticSurface.GridPointAttributes> createMixedColorGradientGridValues(double d, BufferWrapper bufferWrapper, BufferWrapper bufferWrapper2, double d2, double d3, double d4, double d5) {
        ArrayList<AnalyticSurface.GridPointAttributes> arrayList = new ArrayList<AnalyticSurface.GridPointAttributes>();
        long l = Math.min(bufferWrapper.length(), bufferWrapper2.length());
        int n = 0;
        while ((long)n < l) {
            double d6 = WWMath.mixSmooth(d, bufferWrapper.getDouble(n), bufferWrapper2.getDouble(n));
            arrayList.add(AnalyticSurface.createColorGradientAttributes(d6, d2, d3, d4, d5));
            ++n;
        }
        return arrayList;
    }

    protected static void createPrecipitationSurface(double d, double d2, final RenderableLayer renderableLayer) {
        BufferWrapperRaster bufferWrapperRaster = AnalyticSurfaceDemo.loadRasterElevations(DATA_PATH);
        if (bufferWrapperRaster == null) {
            return;
        }
        double[] dArray = WWBufferUtil.computeExtremeValues(bufferWrapperRaster.getBuffer(), bufferWrapperRaster.getTransparentValue());
        if (dArray == null) {
            return;
        }
        final AnalyticSurface analyticSurface = new AnalyticSurface();
        analyticSurface.setSector(bufferWrapperRaster.getSector());
        analyticSurface.setDimensions(bufferWrapperRaster.getWidth(), bufferWrapperRaster.getHeight());
        analyticSurface.setValues(AnalyticSurface.createColorGradientValues(bufferWrapperRaster.getBuffer(), bufferWrapperRaster.getTransparentValue(), dArray[0], dArray[1], d, d2));
        analyticSurface.setVerticalScale(5000.0);
        AnalyticSurfaceAttributes analyticSurfaceAttributes = new AnalyticSurfaceAttributes();
        analyticSurfaceAttributes.setDrawOutline(false);
        analyticSurfaceAttributes.setDrawShadow(false);
        analyticSurfaceAttributes.setInteriorOpacity(0.6);
        analyticSurface.setSurfaceAttributes(analyticSurfaceAttributes);
        DecimalFormat decimalFormat = new DecimalFormat("# ft"){

            @Override
            public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                double d2 = d * 3.280839895;
                return super.format(d2, stringBuffer, fieldPosition);
            }
        };
        final AnalyticSurfaceLegend analyticSurfaceLegend = AnalyticSurfaceLegend.fromColorGradient(dArray[0], dArray[1], d, d2, AnalyticSurfaceLegend.createDefaultColorGradientLabels(dArray[0], dArray[1], decimalFormat), AnalyticSurfaceLegend.createDefaultTitle("Annual Precipitation"));
        analyticSurfaceLegend.setOpacity(0.8);
        analyticSurfaceLegend.setScreenLocation(new Point(100, 300));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                analyticSurface.setClientLayer(renderableLayer);
                renderableLayer.addRenderable(analyticSurface);
                renderableLayer.addRenderable(AnalyticSurfaceDemo.createLegendRenderable(analyticSurface, 300.0, analyticSurfaceLegend));
            }
        });
    }

    protected static BufferWrapperRaster loadRasterElevations(String string) {
        File file = ExampleUtil.saveResourceToTempFile(string, "." + WWIO.getSuffix(string));
        DataRasterReaderFactory dataRasterReaderFactory = (DataRasterReaderFactory)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.DataRasterReaderFactoryClassName");
        DataRasterReader dataRasterReader = dataRasterReaderFactory.findReaderFor(file, null);
        try {
            int n;
            AVList aVList = dataRasterReader.readMetadata(file, null);
            if (aVList == null || !"gov.nasa.worldwind.avkey.Elevation".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
                String string2 = Logging.getMessage("ElevationModel.SourceNotElevations", file.getAbsolutePath());
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            DataRaster[] dataRasterArray = dataRasterReader.read(file, null);
            if (dataRasterArray == null || dataRasterArray.length == 0) {
                String string3 = Logging.getMessage("ElevationModel.CannotReadElevations", file.getAbsolutePath());
                Logging.logger().severe(string3);
                throw new WWRuntimeException(string3);
            }
            Sector sector = (Sector)dataRasterArray[0].getValue("gov.nasa.worldwind.avKey.Sector");
            if (sector == null) {
                String string4 = Logging.getMessage("DataRaster.MissingMetadata", "gov.nasa.worldwind.avKey.Sector");
                Logging.logger().severe(string4);
                throw new IllegalArgumentException(string4);
            }
            int n2 = dataRasterArray[0].getWidth();
            DataRaster dataRaster = dataRasterArray[0].getSubRaster(n2, n = dataRasterArray[0].getHeight(), sector, dataRasterArray[0]);
            if (!(dataRaster instanceof BufferWrapperRaster)) {
                String string5 = Logging.getMessage("ElevationModel.CannotCreateElevationBuffer", string);
                Logging.logger().severe(string5);
                throw new WWRuntimeException(string5);
            }
            return (BufferWrapperRaster)dataRaster;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static BufferWrapper randomGridValues(int n, int n2, double d, double d2, int n3, double d3, BufferFactory bufferFactory) {
        int n4 = n * n2;
        double[] dArray = new double[n4];
        for (int i = 0; i < n3; ++i) {
            double d4 = 1.0 - (double)i / (double)n3;
            int n5 = (int)Math.round(Math.random() * (double)(n - 1));
            int n6 = (int)Math.round(Math.random() * (double)(n - 1));
            int n7 = (int)Math.round(Math.random() * (double)(n2 - 1));
            int n8 = (int)Math.round(Math.random() * (double)(n2 - 1));
            int n9 = n6 - n5;
            int n10 = n8 - n7;
            for (int j = 0; j < n2; ++j) {
                int n11 = j - n7;
                for (int k = 0; k < n; ++k) {
                    int n12 = k - n5;
                    if (n12 * n10 - n9 * n11 < 0) continue;
                    int n13 = k + j * n;
                    dArray[n13] = dArray[n13] + d4;
                }
            }
        }
        AnalyticSurfaceDemo.smoothValues(n, n2, dArray, d3);
        AnalyticSurfaceDemo.scaleValues(dArray, n4, d, d2);
        BufferWrapper bufferWrapper = bufferFactory.newBuffer(n4);
        bufferWrapper.putDouble(0, dArray, 0, n4);
        return bufferWrapper;
    }

    public static BufferWrapper randomGridValues(int n, int n2, double d, double d2) {
        return AnalyticSurfaceDemo.randomGridValues(n, n2, d, d2, 1000, 0.5, new BufferFactory.DoubleBufferFactory());
    }

    protected static void scaleValues(double[] dArray, int n, double d, double d2) {
        int n2;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        for (n2 = 0; n2 < n; ++n2) {
            if (d3 > dArray[n2]) {
                d3 = dArray[n2];
            }
            if (!(d4 < dArray[n2])) continue;
            d4 = dArray[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = (dArray[n2] - d3) / (d4 - d3);
            dArray[n2] = d + dArray[n2] * (d2 - d);
        }
    }

    protected static void smoothValues(int n, int n2, double[] dArray, double d) {
        int n3;
        int n4;
        for (n4 = 0; n4 < n; ++n4) {
            AnalyticSurfaceDemo.smoothBand(dArray, n4, n, n2, d);
        }
        n4 = (n2 - 1) * n;
        for (n3 = 0; n3 < n; ++n3) {
            AnalyticSurfaceDemo.smoothBand(dArray, n3 + n4, -n, n2, d);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            AnalyticSurfaceDemo.smoothBand(dArray, n3 * n, 1, n, d);
        }
        n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            AnalyticSurfaceDemo.smoothBand(dArray, n3 + i * n, -1, n, d);
        }
    }

    protected static void smoothBand(double[] dArray, int n, int n2, int n3, double d) {
        double d2 = dArray[n];
        int n4 = n + n2;
        for (int i = 0; i < n3 - 1; ++i) {
            dArray[n4] = d * d2 + (1.0 - d) * dArray[n4];
            d2 = dArray[n4];
            n4 += n2;
        }
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Analytic Surface", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected static final double HUE_BLUE = 0.6666666666666666;
        protected static final double HUE_RED = 0.0;
        protected RenderableLayer analyticSurfaceLayer;

        public AppFrame() {
            this.initAnalyticSurfaceLayer();
        }

        protected void initAnalyticSurfaceLayer() {
            this.analyticSurfaceLayer = new RenderableLayer();
            this.analyticSurfaceLayer.setPickEnabled(false);
            this.analyticSurfaceLayer.setName("Analytic Surfaces");
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.analyticSurfaceLayer);
            this.getLayerPanel().update(this.getWwd());
            AnalyticSurfaceDemo.createRandomAltitudeSurface(0.6666666666666666, 0.0, 40, 40, this.analyticSurfaceLayer);
            AnalyticSurfaceDemo.createRandomColorSurface(0.6666666666666666, 0.0, 40, 40, this.analyticSurfaceLayer);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AnalyticSurfaceDemo.createPrecipitationSurface(0.6666666666666666, 0.0, AppFrame.this.analyticSurfaceLayer);
                }
            });
            thread.start();
        }
    }
}

