/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Cone;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabbedPaneUsage {
    protected static int wwjPaneNumber;

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            jFrame.setTitle("World Wind Tabbed Pane");
            jFrame.setDefaultCloseOperation(3);
            final JTabbedPane jTabbedPane = new JTabbedPane();
            final WWJPanel wWJPanel = new WWJPanel(new Dimension(800, 600), true);
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton("Detach");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.print("Removing tab...");
                    jTabbedPane.removeTabAt(0);
                    System.out.println("Tab removed");
                }
            });
            JButton jButton2 = new JButton("Attach");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.print("Adding tab...");
                    jTabbedPane.insertTab("WWJ Pane " + ++wwjPaneNumber, null, wWJPanel, "Reattach", 0);
                    System.out.println("Tab added");
                }
            });
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jTabbedPane.add("WWJ Pane 1", wWJPanel);
            jTabbedPane.add("Dummy Pane", jPanel);
            jFrame.getContentPane().add((Component)jTabbedPane, "Center");
            jFrame.pack();
            WWUtil.alignComponent(null, jFrame, "gov.nasa.worldwind.avkey.Center");
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Tabbed Pane Application");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        }
        wwjPaneNumber = 1;
    }

    public static class WWJPanel
    extends JPanel {
        protected WorldWindow wwd = new WorldWindowGLCanvas();
        protected StatusBar statusBar;

        public WWJPanel(Dimension dimension, boolean bl) {
            super(new BorderLayout());
            ((Component)((Object)this.wwd)).setPreferredSize(dimension);
            Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(model);
            this.addMarkers();
            this.addShapes();
            this.add((Component)((Object)this.wwd), "Center");
            if (bl) {
                this.statusBar = new StatusBar();
                this.add((Component)this.statusBar, "Last");
                this.statusBar.setEventSource(this.wwd);
            }
        }

        protected void addMarkers() {
            ArrayList<Marker> arrayList = new ArrayList<Marker>();
            BasicMarkerAttributes basicMarkerAttributes = new BasicMarkerAttributes(Material.YELLOW, "gov.nasa.worldwind.render.markers.Cone", 1.0, 10.0, 5.0);
            Position position = Position.fromDegrees(40.0, -120.0);
            BasicMarker basicMarker = new BasicMarker(position, basicMarkerAttributes);
            arrayList.add(basicMarker);
            MarkerLayer markerLayer = new MarkerLayer();
            markerLayer.setOverrideMarkerElevation(true);
            markerLayer.setKeepSeparated(false);
            markerLayer.setElevation(1000.0);
            markerLayer.setMarkers(arrayList);
            ApplicationTemplate.insertBeforePlacenames(this.wwd, markerLayer);
        }

        protected void addShapes() {
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.GREEN);
            basicShapeAttributes.setInteriorOpacity(0.7);
            basicShapeAttributes.setEnableLighting(true);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setDrawOutline(false);
            Cone cone = new Cone(Position.fromDegrees(42.0, -118.0, 80000.0), 100000.0, 50000.0);
            cone.setAltitudeMode(0);
            cone.setAttributes(basicShapeAttributes);
            cone.setVisible(true);
            cone.setValue("gov.nasa.worldwind.avkey.DisplayName", "Cone with equal axes, ABSOLUTE altitude mode");
            renderableLayer.addRenderable(cone);
            Cone cone2 = new Cone(Position.fromDegrees(37.5, -115.0, 50000.0), 50000.0, 50000.0, 50000.0);
            cone2.setAltitudeMode(2);
            cone2.setAttributes(basicShapeAttributes);
            cone2.setVisible(true);
            cone2.setValue("gov.nasa.worldwind.avkey.DisplayName", "Cone with equal axes, RELATIVE_TO_GROUND altitude mode");
            renderableLayer.addRenderable(cone2);
            ApplicationTemplate.insertBeforePlacenames(this.wwd, renderableLayer);
        }
    }
}

