/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.formats.gcps.GCPSReader;
import gov.nasa.worldwind.formats.tab.TABRasterReader;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.RasterControlPointList;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ShapeUtils;
import gov.nasa.worldwindx.examples.util.SurfaceImageEditor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class RubberSheetImage
extends ApplicationTemplate {
    public static final String OPEN_IMAGE_FILE = "OpenImageFile";
    public static final String SET_IMAGE_OPACITY = "SetImageOpacity";
    public static final String TOGGLE_EDITING = "ToggleEditing";

    protected static BufferedImage createPowerOfTwoImage(int n, int n2) {
        return new BufferedImage(WWMath.powerOfTwoCeiling(n), WWMath.powerOfTwoCeiling(n2), 2);
    }

    protected static BufferedImage createPowerOfTwoScaledCopy(BufferedImage bufferedImage) {
        if (WWMath.isPowerOfTwo(bufferedImage.getWidth()) && WWMath.isPowerOfTwo(bufferedImage.getHeight())) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = RubberSheetImage.createPowerOfTwoImage(bufferedImage.getWidth(), bufferedImage.getHeight());
        ImageUtil.getScaledCopy(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Rubber Sheet Image", AppFrame.class);
    }

    public static class Controller
    implements ActionListener,
    SelectListener {
        private AppFrame appFrame;
        private JFileChooser openFileChooser;
        private boolean isEditingEnabled = true;
        private ArrayList<SurfaceImageEntry> entryList = new ArrayList();

        public Controller(AppFrame appFrame) {
            this.appFrame = appFrame;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (WWUtil.isEmpty(string)) {
                return;
            }
            if (string == RubberSheetImage.OPEN_IMAGE_FILE) {
                this.doOpenImageFile();
            } else if (string == RubberSheetImage.SET_IMAGE_OPACITY) {
                JSlider jSlider = (JSlider)actionEvent.getSource();
                this.doSetImageOpacity((double)jSlider.getValue() / 100.0);
            } else if (string == RubberSheetImage.TOGGLE_EDITING) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                this.enableEditing(abstractButton.isSelected());
            }
        }

        @Override
        public void selected(SelectEvent selectEvent) {
            SurfaceImageEntry surfaceImageEntry;
            PickedObject pickedObject = selectEvent.getTopPickedObject();
            if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftPress") && pickedObject != null && !pickedObject.isTerrain() && pickedObject.getObject() instanceof SurfaceImage && (surfaceImageEntry = this.getEntryFor((SurfaceImage)pickedObject.getObject())) != null) {
                this.setSelectedEntry(surfaceImageEntry);
            }
        }

        protected void enableEditing(boolean bl) {
            this.isEditingEnabled = bl;
            for (SurfaceImageEntry surfaceImageEntry : this.entryList) {
                surfaceImageEntry.getLayer().setPickEnabled(bl);
                if (bl) continue;
                surfaceImageEntry.getEditor().setArmed(false);
            }
        }

        protected void addSurfaceImage(SurfaceImage surfaceImage, String string) {
            SurfaceImageEntry surfaceImageEntry = new SurfaceImageEntry(this.appFrame.getWwd(), surfaceImage, string);
            this.entryList.add(surfaceImageEntry);
            this.setSelectedEntry(surfaceImageEntry);
            surfaceImageEntry.getLayer().setPickEnabled(this.isEditingEnabled);
            if (!this.isEditingEnabled) {
                surfaceImageEntry.getEditor().setArmed(false);
            }
            this.appFrame.getLayerPanel().update(this.appFrame.getWwd());
        }

        protected SurfaceImageEntry getEntryFor(SurfaceImage surfaceImage) {
            for (SurfaceImageEntry surfaceImageEntry : this.entryList) {
                if (surfaceImageEntry.getSurfaceImage() != surfaceImage) continue;
                return surfaceImageEntry;
            }
            return null;
        }

        protected void setSelectedEntry(SurfaceImageEntry surfaceImageEntry) {
            for (SurfaceImageEntry surfaceImageEntry2 : this.entryList) {
                if (surfaceImageEntry2 == surfaceImageEntry || !surfaceImageEntry2.getEditor().isArmed()) continue;
                surfaceImageEntry2.getEditor().setArmed(false);
            }
            if (!surfaceImageEntry.getEditor().isArmed()) {
                surfaceImageEntry.getEditor().setArmed(true);
            }
        }

        protected void doOpenImageFile() {
            int n;
            if (this.openFileChooser == null) {
                this.openFileChooser = new JFileChooser(Configuration.getUserHomeDirectory());
                this.openFileChooser.setAcceptAllFileFilterUsed(false);
                this.openFileChooser.setFileSelectionMode(0);
                this.openFileChooser.setMultiSelectionEnabled(true);
                this.openFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Images", ImageIO.getReaderFormatNames()));
            }
            if ((n = this.openFileChooser.showOpenDialog(this.appFrame)) != 0) {
                return;
            }
            File[] fileArray = this.openFileChooser.getSelectedFiles();
            this.loadFiles(fileArray);
        }

        protected void doSetImageOpacity(double d) {
            for (SurfaceImageEntry surfaceImageEntry : this.entryList) {
                surfaceImageEntry.getSurfaceImage().setOpacity(d);
            }
            this.appFrame.getWwd().redraw();
        }

        protected void loadFiles(final File[] fileArray) {
            this.appFrame.setCursor(Cursor.getPredefinedCursor(3));
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (File file : fileArray) {
                        Controller.this.loadFile(file);
                    }
                    Controller.this.appFrame.setCursor(null);
                }
            });
            thread.start();
        }

        protected void loadFile(final File file) {
            BufferedImage bufferedImage = this.readImage(file);
            if (bufferedImage == null) {
                return;
            }
            final SurfaceImage surfaceImage = this.createGeoreferencedSurfaceImage(file, bufferedImage);
            if (surfaceImage == null) {
                this.addNonGeoreferencedSurfaceImage(file, bufferedImage, this.appFrame.getWwd());
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Controller.this.addSurfaceImage(surfaceImage, file.getName());
                }
            });
        }

        protected BufferedImage readImage(File file) {
            try {
                return ImageIO.read(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        protected SurfaceImage createGeoreferencedSurfaceImage(File file, BufferedImage bufferedImage) {
            try {
                File[] fileArray;
                SurfaceImage surfaceImage = null;
                File file2 = this.getAssociatedTABFile(file);
                if (file2 != null) {
                    surfaceImage = this.createSurfaceImageFromTABFile(bufferedImage, file2);
                }
                if (surfaceImage == null && (fileArray = this.getAssociatedGCPSFile(file)) != null) {
                    surfaceImage = this.createSurfaceImageFromGCPSFile(bufferedImage, (File)fileArray);
                }
                if (surfaceImage == null && (fileArray = this.getAssociatedWorldFiles(file)) != null) {
                    surfaceImage = this.createSurfaceImageFromWorldFiles(bufferedImage, fileArray);
                }
                return surfaceImage;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public File getAssociatedTABFile(File file) {
            TABRasterReader tABRasterReader;
            File file2 = TABRasterReader.getTABFileFor(file);
            if (file2 != null && file2.exists() && (tABRasterReader = new TABRasterReader()).canRead(file2)) {
                return file2;
            }
            return null;
        }

        public File getAssociatedGCPSFile(File file) {
            GCPSReader gCPSReader;
            File file2 = GCPSReader.getGCPSFileFor(file);
            if (file2 != null && file2.exists() && (gCPSReader = new GCPSReader()).canRead(file2)) {
                return file2;
            }
            return null;
        }

        public File[] getAssociatedWorldFiles(File file) {
            try {
                File[] fileArray = WorldFile.getWorldFiles(file);
                if (fileArray != null && fileArray.length > 0) {
                    return fileArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        protected SurfaceImage createSurfaceImageFromWorldFiles(BufferedImage bufferedImage, File[] fileArray) throws IOException {
            AVListImpl aVListImpl = new AVListImpl();
            WorldFile.decodeWorldFiles(fileArray, aVListImpl);
            BufferedImage bufferedImage2 = RubberSheetImage.createPowerOfTwoImage(bufferedImage.getWidth(), bufferedImage.getHeight());
            Sector sector = ImageUtil.warpImageWithWorldFile(bufferedImage, aVListImpl, bufferedImage2);
            return new SurfaceImage((Object)bufferedImage2, sector);
        }

        protected SurfaceImage createSurfaceImageFromTABFile(BufferedImage bufferedImage, File file) throws IOException {
            TABRasterReader tABRasterReader = new TABRasterReader();
            RasterControlPointList rasterControlPointList = tABRasterReader.read(file);
            return this.createSurfaceImageFromControlPoints(bufferedImage, rasterControlPointList);
        }

        protected SurfaceImage createSurfaceImageFromGCPSFile(BufferedImage bufferedImage, File file) throws IOException {
            GCPSReader gCPSReader = new GCPSReader();
            RasterControlPointList rasterControlPointList = gCPSReader.read(file);
            return this.createSurfaceImageFromControlPoints(bufferedImage, rasterControlPointList);
        }

        protected SurfaceImage createSurfaceImageFromControlPoints(BufferedImage bufferedImage, RasterControlPointList rasterControlPointList) throws IOException {
            Object object;
            int n = rasterControlPointList.size();
            Point2D[] point2DArray = new Point2D[n];
            LatLon[] latLonArray = new LatLon[n];
            for (int i = 0; i < n; ++i) {
                object = (RasterControlPointList.ControlPoint)rasterControlPointList.get(i);
                point2DArray[i] = ((RasterControlPointList.ControlPoint)object).getRasterPoint();
                latLonArray[i] = ((RasterControlPointList.ControlPoint)object).getWorldPointAsLatLon();
            }
            BufferedImage bufferedImage2 = RubberSheetImage.createPowerOfTwoImage(bufferedImage.getWidth(), bufferedImage.getHeight());
            object = ImageUtil.warpImageWithControlPoints(bufferedImage, point2DArray, latLonArray, bufferedImage2);
            return new SurfaceImage((Object)bufferedImage2, (Sector)object);
        }

        protected void addNonGeoreferencedSurfaceImage(final File file, final BufferedImage bufferedImage, final WorldWindow worldWindow) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Controller.this.addNonGeoreferencedSurfaceImage(file, bufferedImage, worldWindow);
                    }
                });
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unable to find geographic coordinates for: ");
                stringBuilder.append("\"").append(file.getPath()).append("\"");
                stringBuilder.append("\n");
                stringBuilder.append("Open image anyway?");
                int n = JOptionPane.showConfirmDialog(this.appFrame, stringBuilder, null, 0);
                if (n != 0) {
                    return;
                }
                Position position = ShapeUtils.getNewShapePosition(worldWindow);
                double d = position.getLatitude().radians;
                double d2 = position.getLongitude().radians;
                double d3 = ShapeUtils.getViewportScaleFactor(worldWindow);
                double d4 = d3 / worldWindow.getModel().getGlobe().getRadiusAt(position);
                Sector sector = Sector.fromRadians(d - d4, d + d4, d2 - d4, d2 + d4);
                BufferedImage bufferedImage2 = RubberSheetImage.createPowerOfTwoScaledCopy(bufferedImage);
                this.addSurfaceImage(new SurfaceImage((Object)bufferedImage2, sector), file.getName());
            }
        }
    }

    public static class SurfaceImageEntry {
        private SurfaceImage surfaceImage;
        private SurfaceImageEditor editor;
        private RenderableLayer layer;

        public SurfaceImageEntry(WorldWindow worldWindow, SurfaceImage surfaceImage, String string) {
            this.surfaceImage = surfaceImage;
            this.editor = new SurfaceImageEditor(worldWindow, surfaceImage);
            this.layer = new RenderableLayer();
            this.layer.setName(string);
            this.layer.setPickEnabled(true);
            this.layer.addRenderable(surfaceImage);
            ApplicationTemplate.insertBeforePlacenames(worldWindow, this.layer);
        }

        public SurfaceImage getSurfaceImage() {
            return this.surfaceImage;
        }

        public SurfaceImageEditor getEditor() {
            return this.editor;
        }

        public RenderableLayer getLayer() {
            return this.layer;
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame
    implements ActionListener {
        private Controller controller = new Controller(this);

        public AppFrame() {
            this.getWwd().addSelectListener(this.controller);
            this.initComponents();
        }

        private void initComponents() {
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            JButton jButton = new JButton("Open Image File...");
            jButton.setActionCommand(RubberSheetImage.OPEN_IMAGE_FILE);
            jButton.setAlignmentX(0.0f);
            jButton.addActionListener(this);
            box.add(jButton);
            box.add(Box.createVerticalStrut(10));
            JCheckBox jCheckBox = new JCheckBox("Enable Editing", true);
            jCheckBox.setActionCommand(RubberSheetImage.TOGGLE_EDITING);
            jCheckBox.setAlignmentX(0.0f);
            jCheckBox.addActionListener(this);
            box.add(jCheckBox);
            box.add(Box.createVerticalStrut(10));
            JLabel jLabel = new JLabel("Opacity");
            JSlider jSlider = new JSlider(0, 100, 100);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ActionEvent actionEvent = new ActionEvent(changeEvent.getSource(), 0, RubberSheetImage.SET_IMAGE_OPACITY);
                    AppFrame.this.actionPerformed(actionEvent);
                }
            });
            Box box2 = Box.createHorizontalBox();
            box2.setAlignmentX(0.0f);
            box2.add(jLabel);
            box2.add(jSlider);
            box.add(box2);
            box.add(Box.createVerticalGlue());
            this.getLayerPanel().add((Component)box, "South");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent == null) {
                return;
            }
            if (this.controller == null) {
                return;
            }
            this.controller.actionPerformed(actionEvent);
        }
    }
}

