/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Box;
import gov.nasa.worldwind.render.Cone;
import gov.nasa.worldwind.render.Cylinder;
import gov.nasa.worldwind.render.Ellipsoid;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Pyramid;
import gov.nasa.worldwind.render.Wedge;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class RigidShapes
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Rigid Shapes", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.makeShapes();
        }

        protected void makeShapes() {
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Rigid Shapes");
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setInteriorOpacity(0.7);
            basicShapeAttributes.setEnableLighting(true);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setDrawOutline(false);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
            basicShapeAttributes2.setInteriorMaterial(Material.PINK);
            basicShapeAttributes2.setInteriorOpacity(1.0);
            basicShapeAttributes2.setEnableLighting(true);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineWidth(2.0);
            basicShapeAttributes2.setDrawOutline(false);
            Pyramid pyramid = new Pyramid(Position.fromDegrees(40.0, -120.0, 220000.0), 200000.0, 200000.0, 200000.0);
            pyramid.setAltitudeMode(0);
            pyramid.setAttributes(basicShapeAttributes);
            pyramid.setValue("gov.nasa.worldwind.avkey.DisplayName", "Pyramid with equal axes, ABSOLUTE altitude mode");
            renderableLayer.addRenderable(pyramid);
            Cone cone = new Cone(Position.fromDegrees(37.5, -115.0, 200000.0), 200000.0, 200000.0, 200000.0);
            cone.setAltitudeMode(2);
            cone.setAttributes(basicShapeAttributes);
            cone.setValue("gov.nasa.worldwind.avkey.DisplayName", "Cone with equal axes, RELATIVE_TO_GROUND altitude mode");
            renderableLayer.addRenderable(cone);
            Wedge wedge = new Wedge(Position.fromDegrees(35.0, -110.0, 200000.0), Angle.fromDegrees(225.0), 200000.0, 200000.0, 200000.0);
            wedge.setAltitudeMode(1);
            wedge.setAttributes(basicShapeAttributes);
            wedge.setValue("gov.nasa.worldwind.avkey.DisplayName", "Wedge with equal axes, CLAMP_TO_GROUND altitude mode");
            renderableLayer.addRenderable(wedge);
            Box box = new Box(Position.fromDegrees(0.0, -90.0, 600000.0), 600000.0, 600000.0, 600000.0);
            box.setAltitudeMode(2);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("images/32x32-icon-nasa.png");
            arrayList.add(null);
            arrayList.add("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            arrayList.add(null);
            arrayList.add("images/64x64-crosshair.png");
            arrayList.add(null);
            box.setImageSources(arrayList);
            box.setAttributes(basicShapeAttributes);
            box.setValue("gov.nasa.worldwind.avkey.DisplayName", "Box with a texture");
            renderableLayer.addRenderable(box);
            Ellipsoid ellipsoid = new Ellipsoid(Position.fromDegrees(0.0, -110.0, 600000.0), 600000.0, 600000.0, 600000.0);
            ellipsoid.setAltitudeMode(2);
            ellipsoid.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            ellipsoid.setAttributes(basicShapeAttributes);
            ellipsoid.setValue("gov.nasa.worldwind.avkey.DisplayName", "Sphere with a texture");
            renderableLayer.addRenderable(ellipsoid);
            Cylinder cylinder = new Cylinder(Position.fromDegrees(0.0, -130.0, 600000.0), 600000.0, 600000.0, 600000.0);
            cylinder.setAltitudeMode(2);
            cylinder.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            cylinder.setAttributes(basicShapeAttributes);
            cylinder.setValue("gov.nasa.worldwind.avkey.DisplayName", "Cylinder with a texture");
            renderableLayer.addRenderable(cylinder);
            cylinder = new Cylinder(Position.ZERO, 600000.0, 500000.0, 300000.0);
            cylinder.setAltitudeMode(0);
            cylinder.setAttributes(basicShapeAttributes);
            cylinder.setValue("gov.nasa.worldwind.avkey.DisplayName", "Cylinder with default orientation");
            renderableLayer.addRenderable(cylinder);
            Ellipsoid ellipsoid2 = new Ellipsoid(Position.fromDegrees(0.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            ellipsoid2.setAltitudeMode(2);
            ellipsoid2.setAttributes(basicShapeAttributes2);
            ellipsoid2.setValue("gov.nasa.worldwind.avkey.DisplayName", "Ellipsoid with a pre-set orientation");
            renderableLayer.addRenderable(ellipsoid2);
            ellipsoid2 = new Ellipsoid(Position.fromDegrees(30.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            ellipsoid2.setAltitudeMode(2);
            ellipsoid2.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            ellipsoid2.setAttributes(basicShapeAttributes2);
            ellipsoid2.setValue("gov.nasa.worldwind.avkey.DisplayName", "Ellipsoid with a pre-set orientation");
            renderableLayer.addRenderable(ellipsoid2);
            ellipsoid2 = new Ellipsoid(Position.fromDegrees(60.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            ellipsoid2.setAltitudeMode(2);
            ellipsoid2.setAttributes(basicShapeAttributes2);
            ellipsoid2.setValue("gov.nasa.worldwind.avkey.DisplayName", "Ellipsoid with a pre-set orientation");
            renderableLayer.addRenderable(ellipsoid2);
            ellipsoid2 = new Ellipsoid(Position.fromDegrees(-45.0, -180.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            ellipsoid2.setAltitudeMode(2);
            ellipsoid2.setAttributes(basicShapeAttributes2);
            ellipsoid2.setValue("gov.nasa.worldwind.avkey.DisplayName", "Ellipsoid oriented in 3rd \"quadrant\" (-X, -Y, -Z)");
            renderableLayer.addRenderable(ellipsoid2);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

