/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Pyramid;
import gov.nasa.worldwindx.examples.ApplicationTemplate;

public class Pyramids
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Pyramids", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setInteriorOpacity(0.7);
            basicShapeAttributes.setEnableLighting(true);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setDrawOutline(false);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
            basicShapeAttributes2.setInteriorMaterial(Material.PINK);
            basicShapeAttributes2.setInteriorOpacity(1.0);
            basicShapeAttributes2.setEnableLighting(true);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineWidth(2.0);
            basicShapeAttributes2.setDrawOutline(false);
            Pyramid pyramid = new Pyramid(Position.fromDegrees(40.0, -120.0, 80000.0), 50000.0, 50000.0, 50000.0);
            pyramid.setAltitudeMode(0);
            pyramid.setAttributes(basicShapeAttributes);
            pyramid.setVisible(true);
            pyramid.setValue("gov.nasa.worldwind.avkey.DisplayName", "Pyramid with equal axes, ABSOLUTE altitude mode");
            renderableLayer.addRenderable(pyramid);
            Pyramid pyramid2 = new Pyramid(Position.fromDegrees(37.5, -115.0, 50000.0), 50000.0, 50000.0, 50000.0);
            pyramid2.setAltitudeMode(2);
            pyramid2.setAttributes(basicShapeAttributes);
            pyramid2.setVisible(true);
            pyramid2.setValue("gov.nasa.worldwind.avkey.DisplayName", "Pyramid with equal axes, RELATIVE_TO_GROUND altitude mode");
            renderableLayer.addRenderable(pyramid2);
            Pyramid pyramid3 = new Pyramid(Position.fromDegrees(35.0, -110.0, 50000.0), 50000.0, 50000.0, 50000.0);
            pyramid3.setAltitudeMode(1);
            pyramid3.setAttributes(basicShapeAttributes);
            pyramid3.setVisible(true);
            pyramid3.setValue("gov.nasa.worldwind.avkey.DisplayName", "Pyramid with equal axes, CLAMP_TO_GROUND altitude mode");
            renderableLayer.addRenderable(pyramid3);
            Pyramid pyramid4 = new Pyramid(Position.fromDegrees(0.0, -90.0, 600000.0), 1200000.0, 1200000.0);
            pyramid4.setAltitudeMode(2);
            pyramid4.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            pyramid4.setAttributes(basicShapeAttributes);
            pyramid4.setVisible(true);
            pyramid4.setValue("gov.nasa.worldwind.avkey.DisplayName", "Pyramid with a texture");
            renderableLayer.addRenderable(pyramid4);
            Pyramid pyramid5 = new Pyramid(Position.ZERO, 1000000.0, 500000.0, 100000.0);
            pyramid5.setAltitudeMode(0);
            pyramid5.setAttributes(basicShapeAttributes);
            pyramid5.setVisible(true);
            pyramid5.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Pyramid with default orientation");
            renderableLayer.addRenderable(pyramid5);
            Pyramid pyramid6 = new Pyramid(Position.fromDegrees(0.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            pyramid6.setAltitudeMode(2);
            pyramid6.setAttributes(basicShapeAttributes2);
            pyramid6.setVisible(true);
            pyramid6.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Pyramid with a pre-set orientation");
            renderableLayer.addRenderable(pyramid6);
            Pyramid pyramid7 = new Pyramid(Position.fromDegrees(30.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            pyramid7.setAltitudeMode(2);
            pyramid7.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            pyramid7.setAttributes(basicShapeAttributes2);
            pyramid7.setVisible(true);
            pyramid7.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Pyramid with a pre-set orientation");
            renderableLayer.addRenderable(pyramid7);
            Pyramid pyramid8 = new Pyramid(Position.fromDegrees(60.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            pyramid8.setAltitudeMode(2);
            pyramid8.setAttributes(basicShapeAttributes2);
            pyramid8.setVisible(true);
            pyramid8.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Pyramid with a pre-set orientation");
            renderableLayer.addRenderable(pyramid8);
            Pyramid pyramid9 = new Pyramid(Position.fromDegrees(-45.0, -180.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            pyramid9.setAltitudeMode(2);
            pyramid9.setAttributes(basicShapeAttributes2);
            pyramid9.setVisible(true);
            pyramid9.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled, oriented Pyramid in the 3rd 'quadrant' (-X, -Y, -Z)");
            renderableLayer.addRenderable(pyramid9);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

