/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.coords.MGRSCoord;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class GoToCoordinatePanel
extends JPanel {
    private WorldWindow wwd;
    private JTextField coordInput;
    private JLabel resultLabel;

    public GoToCoordinatePanel(WorldWindow worldWindow) {
        super(new GridLayout(0, 1, 0, 0));
        this.wwd = worldWindow;
        this.makePanel();
    }

    private JPanel makePanel() {
        GoToCoordinatePanel goToCoordinatePanel = this;
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.coordInput = new JTextField(10);
        this.coordInput.setToolTipText("Type coordinates and press Enter");
        this.coordInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LatLon latLon = GoToCoordinatePanel.computeLatLonFromString(GoToCoordinatePanel.this.coordInput.getText(), GoToCoordinatePanel.this.wwd.getModel().getGlobe());
                GoToCoordinatePanel.this.updateResult(latLon);
            }
        });
        jPanel.add(this.coordInput);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.resultLabel = new JLabel();
        jPanel2.add(this.resultLabel);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JButton jButton = new JButton("Go to location");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LatLon latLon = GoToCoordinatePanel.computeLatLonFromString(GoToCoordinatePanel.this.coordInput.getText(), GoToCoordinatePanel.this.wwd.getModel().getGlobe());
                GoToCoordinatePanel.this.updateResult(latLon);
                if (latLon != null) {
                    View view = GoToCoordinatePanel.this.wwd.getView();
                    double d = view.getCenterPoint().distanceTo3(view.getEyePoint());
                    view.goTo(new Position(latLon, 0.0), d);
                }
            }
        });
        jPanel3.add(jButton);
        goToCoordinatePanel.add(jPanel);
        goToCoordinatePanel.add(jPanel2);
        goToCoordinatePanel.add(jPanel3);
        goToCoordinatePanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Go to")));
        return goToCoordinatePanel;
    }

    private void updateResult(LatLon latLon) {
        if (latLon != null) {
            this.coordInput.setText(this.coordInput.getText().toUpperCase());
            this.resultLabel.setText(String.format("Lat %7.4f\u00b0 Lon %7.4f\u00b0", latLon.getLatitude().degrees, latLon.getLongitude().degrees));
        } else {
            this.resultLabel.setText("Invalid coordinates");
        }
    }

    private static LatLon computeLatLonFromString(String string, Globe globe) {
        Matcher matcher;
        Pattern pattern;
        Object object;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Angle angle = null;
        Angle angle2 = null;
        string = string.trim();
        String string3 = "(\\s*|,|,\\s*)";
        String string4 = "\\d{1,2}[A-Za-z]\\s*[A-Za-z]{2}\\s*\\d{1,5}\\s*\\d{1,5}";
        if (string.matches(string4)) {
            try {
                object = MGRSCoord.fromString(string, globe);
                if (((MGRSCoord)object).getLatitude().degrees == 0.0 && ((MGRSCoord)object).getLatitude().degrees == 0.0) {
                    return null;
                }
                angle = ((MGRSCoord)object).getLatitude();
                angle2 = ((MGRSCoord)object).getLongitude();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if (angle == null || angle2 == null) {
            string4 = "([-|\\+]?\\d+?(\\.\\d+?)??\\s*[N|n|S|s]??)";
            string4 = string4 + string3;
            pattern = Pattern.compile(string4 = string4 + "([-|\\+]?\\d+?(\\.\\d+?)??\\s*[E|e|W|w]??)");
            matcher = pattern.matcher(string);
            if (matcher.matches()) {
                object = matcher.group(1).trim();
                int n = 1;
                char c = ((String)object).toUpperCase().charAt(((String)object).length() - 1);
                if (!Character.isDigit(c)) {
                    n = c == 'N' ? 1 : -1;
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                    object = ((String)object).trim();
                }
                String string5 = matcher.group(4).trim();
                int n2 = 1;
                c = string5.toUpperCase().charAt(string5.length() - 1);
                if (!Character.isDigit(c)) {
                    n2 = c == 'E' ? 1 : -1;
                    string5 = string5.substring(0, string5.length() - 1);
                    string5 = string5.trim();
                }
                angle = Angle.fromDegrees(Double.parseDouble((String)object) * (double)n);
                angle2 = Angle.fromDegrees(Double.parseDouble(string5) * (double)n2);
            }
        }
        if (angle == null || angle2 == null) {
            string4 = "([-|\\+]?\\d{1,3}[d|D|\u00b0|\\s](\\s*\\d{1,2}['|\u2019|\\s])?(\\s*\\d{1,2}[\"|\u201d])?\\s*[N|n|S|s]?)";
            string4 = string4 + string3;
            pattern = Pattern.compile(string4 = string4 + "([-|\\+]?\\d{1,3}[d|D|\u00b0|\\s](\\s*\\d{1,2}['|\u2019|\\s])?(\\s*\\d{1,2}[\"|\u201d])?\\s*[E|e|W|w]?)");
            matcher = pattern.matcher(string);
            if (matcher.matches()) {
                angle = GoToCoordinatePanel.parseDMSString(matcher.group(1));
                angle2 = GoToCoordinatePanel.parseDMSString(matcher.group(5));
            }
        }
        if (angle == null || angle2 == null) {
            return null;
        }
        if (angle.degrees >= -90.0 && angle.degrees <= 90.0 && angle2.degrees >= -180.0 && angle2.degrees <= 180.0) {
            return new LatLon(angle, angle2);
        }
        return null;
    }

    private static Angle parseDMSString(String string) {
        double d;
        char c;
        string = string.replaceAll("[D|d|\u00b0|'|\u2019|\"|\u201d]", " ");
        string = string.replaceAll("\\s+", " ");
        string = string.trim();
        int n = 1;
        char c2 = string.toUpperCase().charAt(string.length() - 1);
        if (!Character.isDigit(c2)) {
            n = c2 == 'N' || c2 == 'E' ? 1 : -1;
            string = string.substring(0, string.length() - 1);
            string = string.trim();
        }
        if (!Character.isDigit(c = string.charAt(0))) {
            n *= c == '-' ? -1 : 1;
            string = string.substring(1, string.length());
        }
        String[] stringArray = string.split(" ");
        double d2 = Integer.parseInt(stringArray[0]);
        double d3 = stringArray.length > 1 ? (double)Integer.parseInt(stringArray[1]) : 0.0;
        double d4 = d = stringArray.length > 2 ? (double)Integer.parseInt(stringArray[2]) : 0.0;
        if (d3 >= 0.0 && d3 <= 60.0 && d >= 0.0 && d <= 60.0) {
            return Angle.fromDegrees(d2 * (double)n + d3 / 60.0 * (double)n + d / 3600.0 * (double)n);
        }
        return null;
    }
}

