/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExtrudedPolygonsFromShapefile
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("Extruded Polygons from Shapefile", AppFrame.class);
    }

    public static void printShapefileInfo(ShapefileRecord shapefileRecord) {
        System.out.printf("%d, %s: %d parts, %d points", shapefileRecord.getRecordNumber(), shapefileRecord.getShapeType(), shapefileRecord.getNumberOfParts(), shapefileRecord.getNumberOfPoints());
        for (Map.Entry<String, Object> entry : shapefileRecord.getAttributes().getEntries()) {
            if (entry.getKey() != null) {
                System.out.printf(", %s", entry.getKey());
            }
            if (entry.getValue() == null) continue;
            System.out.printf(", %s", entry.getValue());
        }
        System.out.println();
        System.out.print("\tAttributes: ");
        for (Map.Entry<String, Object> entry : shapefileRecord.getAttributes().getEntries()) {
            System.out.printf("%s = %s, ", entry.getKey(), entry.getValue());
        }
        System.out.println();
        VecBuffer vecBuffer = shapefileRecord.getPointBuffer(0);
        for (LatLon latLon : vecBuffer.getLocations()) {
            System.out.printf("\t%f, %f\n", latLon.getLatitude().degrees, latLon.getLongitude().degrees);
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.makeMenu();
        }

        protected void makeMenu() {
            final JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("ESRI Shapefiles", "shp"));
            JMenuBar jMenuBar = new JMenuBar();
            this.setJMenuBar(jMenuBar);
            JMenu jMenu = new JMenu("File");
            jMenuBar.add(jMenu);
            JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Open File..."){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        int n = jFileChooser.showOpenDialog(AppFrame.this);
                        if (n == 0) {
                            WorkerThread workerThread = new WorkerThread(jFileChooser.getSelectedFile(), AppFrame.this.getWwd());
                            workerThread.start();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            jMenu.add(jMenuItem);
        }

        public class WorkerThread
        extends Thread {
            private File file;
            private WorldWindow wwd;
            protected String[] heightKeys = new String[]{"height", "Height", "HEIGHT"};

            public WorkerThread(File file, WorldWindow worldWindow) {
                this.file = file;
                this.wwd = worldWindow;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Shapefile shapefile = new Shapefile(this.file);
                final RenderableLayer renderableLayer = new RenderableLayer();
                try {
                    while (shapefile.hasNext()) {
                        ShapefileRecord shapefileRecord = shapefile.nextRecord();
                        if (shapefileRecord == null || shapefileRecord.getNumberOfPoints() < 4) continue;
                        renderableLayer.addRenderable(this.makeShape(shapefileRecord));
                    }
                }
                finally {
                    shapefile.close();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationTemplate.insertBeforePlacenames(WorkerThread.this.wwd, renderableLayer);
                        AppFrame.this.getLayerPanel().update(WorkerThread.this.wwd);
                    }
                });
                this.wwd.addSelectListener(new SelectListener(){

                    @Override
                    public void selected(SelectEvent selectEvent) {
                        if (selectEvent.getTopObject() instanceof ExtrudedPolygon) {
                            System.out.println("EXTRUDED POLYGON SELECTED");
                        }
                    }
                });
            }

            protected ExtrudedPolygon makeShape(ShapefileRecord shapefileRecord) {
                Double d = null;
                for (String string : this.heightKeys) {
                    Object object = shapefileRecord.getAttributes().getValue(string);
                    if (object == null) continue;
                    d = Double.parseDouble(object.toString());
                }
                ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon();
                VecBuffer vecBuffer = shapefileRecord.getPointBuffer(0);
                extrudedPolygon.setOuterBoundary(vecBuffer.getLocations(), d);
                return extrudedPolygon;
            }
        }
    }
}

