/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwindx.examples.Airspaces;

public class DeepPicking
extends Airspaces {
    public static void main(String[] stringArray) {
        DeepPicking.start("World Wind Deep Picking", AppFrame.class);
    }

    public static class AppFrame
    extends Airspaces.AppFrame {
        public AppFrame() {
            this.controller.aglAirspaces.setEnableBatchPicking(false);
            this.controller.amslAirspaces.setEnableBatchPicking(false);
            this.controller.getWwd().getSceneController().setDeepPickEnabled(true);
            this.controller.getWwd().addSelectListener(new SelectListener(){

                @Override
                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Hover") && selectEvent.getObjects() != null) {
                        System.out.printf("%d objects\n", selectEvent.getObjects().size());
                        if (selectEvent.getObjects().size() > 1) {
                            for (PickedObject pickedObject : selectEvent.getObjects()) {
                                System.out.println(pickedObject.getObject().getClass().getName());
                            }
                        }
                    }
                }
            });
        }
    }
}

