/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.ContourLine;
import gov.nasa.worldwind.render.ContourLinePolygon;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContourLines
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 44.23);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", 6.92);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 30000);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialPitch", 45);
        ApplicationTemplate.start("World Wind Contour Lines", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected ContourLine contourLine;

        public AppFrame() {
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Contour Lines");
            renderableLayer.setPickEnabled(false);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
            this.contourLine = new ContourLine();
            this.contourLine.setElevation(2125.0);
            renderableLayer.addRenderable(this.contourLine);
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(LatLon.fromDegrees(44.16, 6.82));
            arrayList.add(LatLon.fromDegrees(44.16, 7.09));
            arrayList.add(LatLon.fromDegrees(44.3, 6.95));
            arrayList.add(LatLon.fromDegrees(44.16, 6.82));
            for (int i = 0; i <= 3000; i += 250) {
                ContourLinePolygon contourLinePolygon = new ContourLinePolygon((double)i, arrayList);
                contourLinePolygon.setColor(new Color(0.2f, 0.2f, 0.8f));
                if (i % 1000 == 0) {
                    contourLinePolygon.setLineWidth(2.0);
                    contourLinePolygon.setColor(new Color(0.0f, 0.1f, 0.6f));
                }
                if (i % 500 == 0) {
                    contourLinePolygon.setLineWidth(2.0);
                }
                renderableLayer.addRenderable(contourLinePolygon);
            }
            this.getLayerPanel().add((Component)this.makeContourLineControlPanel(), "South");
        }

        protected JPanel makeContourLineControlPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Contour Line Elevation")));
            final JSlider jSlider = new JSlider(0, 3000, (int)this.contourLine.getElevation());
            jSlider.setMajorTickSpacing(1000);
            jSlider.setMinorTickSpacing(250);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.contourLine.setElevation(jSlider.getValue());
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel.add(jSlider);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(0, new JLabel("0km"));
            hashtable.put(1000, new JLabel("1km"));
            hashtable.put(2000, new JLabel("2km"));
            hashtable.put(3000, new JLabel("3km"));
            jSlider.setLabelTable(hashtable);
            return jPanel;
        }
    }
}

