/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ContextMenusOnShapes
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Context Menus on Shapes", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            RenderableLayer renderableLayer = new RenderableLayer();
            PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setAntiAliasHint(4353);
            pointPlacemarkAttributes.setLineMaterial(Material.WHITE);
            pointPlacemarkAttributes.setLineWidth(2.0);
            pointPlacemarkAttributes.setImageAddress("images/pushpins/push-pin-yellow.png");
            pointPlacemarkAttributes.setScale(0.6);
            pointPlacemarkAttributes.setImageOffset(new Offset(19.0, 11.0, "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.Pixels"));
            PointPlacemarkAttributes pointPlacemarkAttributes2 = new PointPlacemarkAttributes(pointPlacemarkAttributes);
            pointPlacemarkAttributes2.setScale(0.7);
            ContextMenuItemInfo[] contextMenuItemInfoArray = new ContextMenuItemInfo[]{new ContextMenuItemInfo("Do This"), new ContextMenuItemInfo("Do That"), new ContextMenuItemInfo("Do the Other Thing")};
            PointPlacemark pointPlacemark = new PointPlacemark(Position.fromDegrees(28.0, -102.0, 10000.0));
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            pointPlacemark.setHighlightAttributes(pointPlacemarkAttributes2);
            pointPlacemark.setAltitudeMode(1);
            pointPlacemark.setValue("ContextMenuInfo", new ContextMenuInfo("Placemark A", contextMenuItemInfoArray));
            renderableLayer.addRenderable(pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees(29.0, -104.0, 20000.0));
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            pointPlacemark.setHighlightAttributes(pointPlacemarkAttributes2);
            pointPlacemark.setAltitudeMode(2);
            pointPlacemark.setValue("ContextMenuInfo", new ContextMenuInfo("Placemark B", contextMenuItemInfoArray));
            renderableLayer.addRenderable(pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees(30.0, -104.5, 20000.0));
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            pointPlacemark.setHighlightAttributes(pointPlacemarkAttributes2);
            pointPlacemark.setAltitudeMode(2);
            pointPlacemark.setValue("ContextMenuInfo", new ContextMenuInfo("Placemark C", contextMenuItemInfoArray));
            renderableLayer.addRenderable(pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees(28.0, -104.5, 20000.0));
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            pointPlacemark.setHighlightAttributes(pointPlacemarkAttributes2);
            pointPlacemark.setAltitudeMode(2);
            pointPlacemark.setValue("ContextMenuInfo", new ContextMenuInfo("Placemark D", contextMenuItemInfoArray));
            renderableLayer.addRenderable(pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees(30.0, -103.5, 2000.0));
            pointPlacemark.setValue("ContextMenuInfo", new ContextMenuInfo("Placemark E", contextMenuItemInfoArray));
            renderableLayer.addRenderable(pointPlacemark);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
            ContextMenuController contextMenuController = new ContextMenuController();
            this.getWwd().addSelectListener(contextMenuController);
        }
    }

    public static class ContextMenuItemAction
    extends AbstractAction {
        protected ContextMenuItemInfo itemInfo;

        public ContextMenuItemAction(ContextMenuItemInfo contextMenuItemInfo) {
            super(contextMenuItemInfo.displayString);
            this.itemInfo = contextMenuItemInfo;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println(this.itemInfo.displayString);
        }
    }

    protected static class ContextMenuItemInfo {
        protected String displayString;

        public ContextMenuItemInfo(String string) {
            this.displayString = string;
        }
    }

    protected static class ContextMenuInfo {
        protected String menuTitle;
        protected ContextMenuItemInfo[] menuItems;

        public ContextMenuInfo(String string, ContextMenuItemInfo[] contextMenuItemInfoArray) {
            this.menuTitle = string;
            this.menuItems = contextMenuItemInfoArray;
        }
    }

    protected static class ContextMenu {
        public static final String CONTEXT_MENU_INFO = "ContextMenuInfo";
        protected ContextMenuInfo ctxMenuInfo;
        protected Component sourceComponent;
        protected JMenuItem menuTitleItem;
        protected ArrayList<JMenuItem> menuItems = new ArrayList();

        public ContextMenu(Component component, ContextMenuInfo contextMenuInfo) {
            this.sourceComponent = component;
            this.ctxMenuInfo = contextMenuInfo;
            this.makeMenuTitle();
            this.makeMenuItems();
        }

        protected void makeMenuTitle() {
            this.menuTitleItem = new JMenuItem(this.ctxMenuInfo.menuTitle);
        }

        protected void makeMenuItems() {
            for (ContextMenuItemInfo contextMenuItemInfo : this.ctxMenuInfo.menuItems) {
                this.menuItems.add(new JMenuItem(new ContextMenuItemAction(contextMenuItemInfo)));
            }
        }

        public void show(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.menuTitleItem);
            jPopupMenu.addSeparator();
            for (JMenuItem jMenuItem : this.menuItems) {
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.show(this.sourceComponent, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected static class ContextMenuController
    implements SelectListener {
        protected PointPlacemark lastPickedPlacemark = null;

        protected ContextMenuController() {
        }

        @Override
        public void selected(SelectEvent selectEvent) {
            try {
                if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                    this.highlight(selectEvent, selectEvent.getTopObject());
                } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.RightPress")) {
                    this.showContextMenu(selectEvent);
                }
            }
            catch (Exception exception) {
                Util.getLogger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
            }
        }

        protected void highlight(SelectEvent selectEvent, Object object) {
            if (this.lastPickedPlacemark == object) {
                return;
            }
            if (this.lastPickedPlacemark != null) {
                this.lastPickedPlacemark.setHighlighted(false);
                this.lastPickedPlacemark = null;
            }
            if (object != null && object instanceof PointPlacemark) {
                this.lastPickedPlacemark = (PointPlacemark)object;
                this.lastPickedPlacemark.setHighlighted(true);
            }
        }

        protected void showContextMenu(SelectEvent selectEvent) {
            if (!(selectEvent.getTopObject() instanceof PointPlacemark)) {
                return;
            }
            Object object = selectEvent.getTopObject();
            if (object instanceof AVList) {
                AVList aVList = (AVList)object;
                ContextMenuInfo contextMenuInfo = (ContextMenuInfo)aVList.getValue("ContextMenuInfo");
                if (contextMenuInfo == null) {
                    return;
                }
                if (!(selectEvent.getSource() instanceof Component)) {
                    return;
                }
                ContextMenu contextMenu = new ContextMenu((Component)selectEvent.getSource(), contextMenuInfo);
                contextMenu.show(selectEvent.getMouseEvent());
            }
        }
    }
}

