/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicBalloonAttributes;
import gov.nasa.worldwind.render.GlobeBrowserBalloon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.ScreenAnnotationBalloon;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.BalloonController;
import gov.nasa.worldwindx.examples.util.HotSpotController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.io.InputStream;

public class Balloons
extends ApplicationTemplate {
    protected static final String BROWSER_BALLOON_CONTENT_PATH = "gov/nasa/worldwindx/examples/data/BrowserBalloonExample.html";

    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 60);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -85);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 9500000);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialPitch", 45);
        ApplicationTemplate.start("World Wind Balloons", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected HotSpotController hotSpotController = new HotSpotController(this.getWwd());
        protected BalloonController balloonController = new BalloonController(this.getWwd());
        protected RenderableLayer layer = new RenderableLayer();

        public AppFrame() {
            super(true, true, false);
            this.layer.setName("Balloons");
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.layer);
            this.getLayerPanel().update(this.getWwd());
            this.makeAnnotationBalloon();
            this.makeBrowserBalloon();
            Dimension dimension = new Dimension(1200, 800);
            this.setPreferredSize(dimension);
            this.pack();
            WWUtil.alignComponent(null, this, "gov.nasa.worldwind.avkey.Center");
        }

        protected void makeAnnotationBalloon() {
            ScreenAnnotationBalloon screenAnnotationBalloon = new ScreenAnnotationBalloon("<b>AnnotationBalloon</b> attached to the screen", new Point(50, 300));
            BasicBalloonAttributes basicBalloonAttributes = new BasicBalloonAttributes();
            basicBalloonAttributes.setSize(Size.fromPixels(300, 50));
            basicBalloonAttributes.setOffset(new Offset(0.0, 0.0, "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.Pixels"));
            basicBalloonAttributes.setInsets(new Insets(10, 10, 10, 10));
            basicBalloonAttributes.setLeaderShape("gov.nasa.worldwind.avkey.ShapeNone");
            basicBalloonAttributes.setTextColor(Color.WHITE);
            basicBalloonAttributes.setInteriorMaterial(Material.BLACK);
            basicBalloonAttributes.setInteriorOpacity(0.6);
            basicBalloonAttributes.setOutlineMaterial(Material.WHITE);
            screenAnnotationBalloon.setAttributes(basicBalloonAttributes);
            this.layer.addRenderable(screenAnnotationBalloon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void makeBrowserBalloon() {
            String string = null;
            InputStream inputStream = null;
            try {
                inputStream = WWIO.openFileOrResourceStream(Balloons.BROWSER_BALLOON_CONTENT_PATH, this.getClass());
                string = WWIO.readStreamToString(inputStream, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                WWIO.closeStream(inputStream, Balloons.BROWSER_BALLOON_CONTENT_PATH);
            }
            if (string == null) {
                string = Logging.getMessage("generic.ExceptionAttemptingToReadFile", Balloons.BROWSER_BALLOON_CONTENT_PATH);
            }
            Position position = Position.fromDegrees(38.883056, -77.016389);
            GlobeBrowserBalloon globeBrowserBalloon = new GlobeBrowserBalloon(string, position);
            BasicBalloonAttributes basicBalloonAttributes = new BasicBalloonAttributes();
            basicBalloonAttributes.setSize(new Size("gov.nasa.worldwind.render.Size.NativeDimension", 0.0, null, "gov.nasa.worldwind.render.Size.NativeDimension", 0.0, null));
            globeBrowserBalloon.setAttributes(basicBalloonAttributes);
            PointPlacemark pointPlacemark = new PointPlacemark(position);
            pointPlacemark.setLabelText("Click to open balloon");
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.Balloon", globeBrowserBalloon);
            this.layer.addRenderable(globeBrowserBalloon);
            this.layer.addRenderable(pointPlacemark);
        }
    }
}

