/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.util.measuretool;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import gov.nasa.worldwindx.applications.worldwindow.util.measuretool.WWOMeasureTool;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class WWOMeasureDisplay
implements WWOMeasureTool.MeasureDisplay {
    protected WWOMeasureTool measureTool;
    protected ScreenAnnotation annotation;
    protected AnnotationAttributes annotationAttributes;
    protected AVListImpl avList = new AVListImpl();
    protected UnitsFormat unitsFormat = new UnitsFormat();

    public WWOMeasureDisplay(WWOMeasureTool wWOMeasureTool) {
        this.measureTool = wWOMeasureTool;
        this.annotationAttributes = new AnnotationAttributes();
        this.annotationAttributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeRectangle");
        this.annotationAttributes.setInsets(new Insets(10, 10, 10, 10));
        this.annotationAttributes.setDrawOffset(new Point(0, 10));
        this.annotationAttributes.setTextAlign("gov.nasa.worldwind.avkey.Center");
        this.annotationAttributes.setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
        this.annotationAttributes.setFont(Font.decode("Arial-Bold-14"));
        this.annotationAttributes.setTextColor(Color.WHITE);
        this.annotationAttributes.setBackgroundColor(new Color(0, 0, 0, 180));
        this.annotationAttributes.setSize(new Dimension(220, 0));
        this.annotation = new ScreenAnnotation("", new Point(0, 0), this.annotationAttributes);
        this.annotation.getAttributes().setVisible(false);
        this.annotation.getAttributes().setDrawOffset(null);
        this.setInitialLabels();
    }

    protected void setInitialLabels() {
        this.setLabel("MeasureTool.AccumulatedLabel", "Accumulated");
        this.setLabel("MeasureTool.AngleLabel", "Angle");
        this.setLabel("MeasureTool.AreaLabel", "Area");
        this.setLabel("MeasureTool.CenterLatitudeLabel", "Center Lat");
        this.setLabel("MeasureTool.CenterLongitudeLabel", "Center Lon");
        this.setLabel("MeasureTool.HeadingLabel", "Heading");
        this.setLabel("MeasureTool.HeightLabel", "Height");
        this.setLabel("MeasureTool.LatitudeLabel", "Lat");
        this.setLabel("MeasureTool.LongitudeLabel", "Lon");
        this.setLabel("MeasureTool.LengthLabel", "Length");
        this.setLabel("MeasureTool.MajorAxisLabel", "Major");
        this.setLabel("MeasureTool.MinorAxisLabel", "Minor");
        this.setLabel("MeasureTool.PerimeterLabel", "Perimeter");
        this.setLabel("MeasureTool.RadiusLabel", "Radius");
        this.setLabel("MeasureTool.WidthLabel", "Width");
    }

    @Override
    public void addToLayer(RenderableLayer renderableLayer) {
        renderableLayer.addRenderable(this.annotation);
    }

    @Override
    public void removeFromLayer(RenderableLayer renderableLayer) {
        renderableLayer.removeRenderable(this.annotation);
    }

    @Override
    public void setLabel(String string, String string2) {
        if (string != null && string.length() > 0) {
            this.avList.setValue(string, string2);
        }
    }

    @Override
    public String getLabel(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.LabelName");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = this.avList.getStringValue(string);
        return string3 != null ? string3 : this.measureTool.getUnitsFormat().getStringValue(string);
    }

    @Override
    public boolean isAnnotation(Object object) {
        return object == this.annotation;
    }

    @Override
    public void updateMeasureDisplay(Position position) {
        if (position == null) {
            this.annotation.getAttributes().setVisible(false);
            return;
        }
        String string = this.getDisplayString(position, this.measureTool);
        if (string == null) {
            this.annotation.getAttributes().setVisible(false);
            return;
        }
        this.annotation.setText(string);
        Vec4 vec4 = this.computeAnnotationPosition(position, this.measureTool);
        if (vec4 != null) {
            this.annotation.setScreenPoint(new Point((int)vec4.x, (int)vec4.y));
        }
        this.annotation.getAttributes().setVisible(true);
    }

    protected String getDisplayString(Position position, WWOMeasureTool wWOMeasureTool) {
        String string = null;
        String string2 = this.measureTool.getMeasureShapeType();
        Rectangle2D.Double double_ = this.measureTool.getShapeRectangle();
        if (position != null) {
            if (string2.equals("gov.nasa.worldwind.avkey.ShapeCircle") && double_ != null) {
                string = this.formatCircleMeasurements(position, wWOMeasureTool);
            } else if (string2.equals("gov.nasa.worldwind.avkey.ShapeSquare") && double_ != null) {
                string = this.formatSquareMeasurements(position, wWOMeasureTool);
            } else if (string2.equals("gov.nasa.worldwind.avkey.ShapeQuad") && double_ != null) {
                string = this.formatQuadMeasurements(position, wWOMeasureTool);
            } else if (string2.equals("gov.nasa.worldwind.avkey.ShapeEllipse") && double_ != null) {
                string = this.formatEllipseMeasurements(position, wWOMeasureTool);
            } else if (string2.equals("gov.nasa.worldwind.avkey.ShapeLine") || string2.equals("gov.nasa.worldwind.avkey.ShapePath")) {
                string = this.formatLineMeasurements(position, wWOMeasureTool);
            } else if (string2.equals("gov.nasa.worldwind.avkey.ShapePolygon")) {
                string = this.formatPolygonMeasurements(position, wWOMeasureTool);
            }
        }
        return string;
    }

    protected Vec4 computeAnnotationPosition(Position position, WWOMeasureTool wWOMeasureTool) {
        Vec4 vec4 = wWOMeasureTool.getWwd().getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude());
        if (vec4 == null) {
            Globe globe = wWOMeasureTool.getWwd().getModel().getGlobe();
            vec4 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), globe.getElevation(position.getLatitude(), position.getLongitude()));
        }
        return wWOMeasureTool.getWwd().getView().project(vec4);
    }

    protected String formatCircleMeasurements(Position position, WWOMeasureTool wWOMeasureTool) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().areaNL(wWOMeasureTool.getLabel("MeasureTool.AreaLabel"), wWOMeasureTool.getArea()));
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.PerimeterLabel"), wWOMeasureTool.getLength()));
        if (wWOMeasureTool.getShapeRectangle() != null) {
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.RadiusLabel"), wWOMeasureTool.getShapeRectangle().width / 2.0));
        }
        this.formatControlPoints(position, wWOMeasureTool, stringBuilder);
        return stringBuilder.toString();
    }

    protected String formatEllipseMeasurements(Position position, WWOMeasureTool wWOMeasureTool) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().areaNL(wWOMeasureTool.getLabel("MeasureTool.AreaLabel"), wWOMeasureTool.getArea()));
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.PerimeterLabel"), wWOMeasureTool.getLength()));
        if (wWOMeasureTool.getShapeRectangle() != null) {
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.MajorAxisLabel"), wWOMeasureTool.getShapeRectangle().width));
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.MinorAxisLabel"), wWOMeasureTool.getShapeRectangle().height));
        }
        if (wWOMeasureTool.getOrientation() != null) {
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().angleNL(wWOMeasureTool.getLabel("MeasureTool.HeadingLabel"), wWOMeasureTool.getOrientation()));
        }
        this.formatControlPoints(position, wWOMeasureTool, stringBuilder);
        return stringBuilder.toString();
    }

    protected String formatSquareMeasurements(Position position, WWOMeasureTool wWOMeasureTool) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().areaNL(wWOMeasureTool.getLabel("MeasureTool.AreaLabel"), wWOMeasureTool.getArea()));
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.PerimeterLabel"), wWOMeasureTool.getLength()));
        if (wWOMeasureTool.getShapeRectangle() != null) {
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.WidthLabel"), wWOMeasureTool.getShapeRectangle().width));
        }
        if (wWOMeasureTool.getOrientation() != null) {
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().angleNL(wWOMeasureTool.getLabel("MeasureTool.HeadingLabel"), wWOMeasureTool.getOrientation()));
        }
        this.formatControlPoints(position, wWOMeasureTool, stringBuilder);
        return stringBuilder.toString();
    }

    protected String formatQuadMeasurements(Position position, WWOMeasureTool wWOMeasureTool) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().areaNL(wWOMeasureTool.getLabel("MeasureTool.AreaLabel"), wWOMeasureTool.getArea()));
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.PerimeterLabel"), wWOMeasureTool.getLength()));
        if (wWOMeasureTool.getShapeRectangle() != null) {
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.WidthLabel"), wWOMeasureTool.getShapeRectangle().width));
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.HeightLabel"), wWOMeasureTool.getShapeRectangle().height));
        }
        if (wWOMeasureTool.getOrientation() != null) {
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().angleNL(wWOMeasureTool.getLabel("MeasureTool.HeadingLabel"), wWOMeasureTool.getOrientation()));
        }
        this.formatControlPoints(position, wWOMeasureTool, stringBuilder);
        return stringBuilder.toString();
    }

    protected String formatPolygonMeasurements(Position position, WWOMeasureTool wWOMeasureTool) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().areaNL(wWOMeasureTool.getLabel("MeasureTool.AreaLabel"), wWOMeasureTool.getArea()));
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.PerimeterLabel"), wWOMeasureTool.getLength()));
        this.formatControlPoints(position, wWOMeasureTool, stringBuilder);
        return stringBuilder.toString();
    }

    protected String formatLineMeasurements(Position position, WWOMeasureTool wWOMeasureTool) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.LengthLabel"), wWOMeasureTool.getLength()));
        Double d = this.computeAccumulatedLength(position, wWOMeasureTool);
        if (d != null && d >= 1.0 && !this.lengthsEssentiallyEqual(wWOMeasureTool.getLength(), d)) {
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().lengthNL(wWOMeasureTool.getLabel("MeasureTool.AccumulatedLabel"), d));
        }
        if (wWOMeasureTool.getOrientation() != null) {
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().angleNL(wWOMeasureTool.getLabel("MeasureTool.HeadingLabel"), wWOMeasureTool.getOrientation()));
        }
        this.formatControlPoints(position, wWOMeasureTool, stringBuilder);
        return stringBuilder.toString();
    }

    protected void formatControlPoints(Position position, WWOMeasureTool wWOMeasureTool, StringBuilder stringBuilder) {
        if (wWOMeasureTool.getCenterPosition() != null && this.areLocationsRedundant(wWOMeasureTool.getCenterPosition(), position, wWOMeasureTool.getUnitsFormat())) {
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().angleNL(wWOMeasureTool.getLabel("MeasureTool.CenterLatitudeLabel"), wWOMeasureTool.getCenterPosition().getLatitude()));
            stringBuilder.append(wWOMeasureTool.getUnitsFormat().angleNL(wWOMeasureTool.getLabel("MeasureTool.CenterLongitudeLabel"), wWOMeasureTool.getCenterPosition().getLongitude()));
        } else {
            for (int i = 0; i < wWOMeasureTool.getControlPoints().size(); ++i) {
                if (!this.areLocationsRedundant(position, wWOMeasureTool.getControlPoints().get(i).getPosition(), wWOMeasureTool.getUnitsFormat())) continue;
                stringBuilder.append(wWOMeasureTool.getUnitsFormat().angleNL(wWOMeasureTool.getLabel("MeasureTool.LatitudeLabel"), position.getLatitude()));
                stringBuilder.append(wWOMeasureTool.getUnitsFormat().angleNL(wWOMeasureTool.getLabel("MeasureTool.LongitudeLabel"), position.getLongitude()));
            }
        }
    }

    protected Double computeAccumulatedLength(LatLon latLon, WWOMeasureTool wWOMeasureTool) {
        double d;
        if (wWOMeasureTool.getPositions().size() < 2) {
            return null;
        }
        double d2 = wWOMeasureTool.getWwd().getModel().getGlobe().getRadius();
        double d3 = 0.0;
        int n = 0;
        LatLon latLon2 = wWOMeasureTool.getPositions().get(n);
        for (int i = 1; i < wWOMeasureTool.getPositions().size(); ++i) {
            LatLon latLon3 = wWOMeasureTool.getPositions().get(i);
            double d4 = LatLon.greatCircleDistance((LatLon)latLon2, (LatLon)latLon3).radians * d2;
            double d5 = LatLon.greatCircleDistance((LatLon)latLon2, (LatLon)latLon).radians * d2;
            double d6 = LatLon.greatCircleDistance((LatLon)latLon3, (LatLon)latLon).radians * d2;
            if (d5 <= d4 && d6 <= d4) {
                d3 += d5 / (d5 + d6) * d4;
                break;
            }
            d3 += d4;
            latLon2 = latLon3;
        }
        return d3 < (d = this.computePathLength(wWOMeasureTool)) ? Double.valueOf(wWOMeasureTool.getLength() * (d3 / d)) : null;
    }

    protected double computePathLength(WWOMeasureTool wWOMeasureTool) {
        double d = 0.0;
        LatLon latLon = null;
        for (LatLon latLon2 : wWOMeasureTool.getPositions()) {
            if (latLon != null) {
                d += LatLon.greatCircleDistance((LatLon)latLon, (LatLon)latLon2).radians;
            }
            latLon = latLon2;
        }
        return d * wWOMeasureTool.getWwd().getModel().getGlobe().getRadius();
    }

    protected Angle computeAngleBetween(LatLon latLon, LatLon latLon2, LatLon latLon3) {
        Vec4 vec4 = new Vec4(latLon2.getLatitude().radians - latLon.getLatitude().radians, latLon2.getLongitude().radians - latLon.getLongitude().radians, 0.0);
        Vec4 vec42 = new Vec4(latLon3.getLatitude().radians - latLon2.getLatitude().radians, latLon3.getLongitude().radians - latLon2.getLongitude().radians, 0.0);
        return vec4.angleBetween3(vec42);
    }

    protected boolean lengthsEssentiallyEqual(double d, double d2) {
        return Math.abs(d - d2) < 0.01;
    }

    protected boolean areLocationsRedundant(LatLon latLon, LatLon latLon2, UnitsFormat unitsFormat) {
        String string;
        if (latLon == null || latLon2 == null) {
            return false;
        }
        String string2 = unitsFormat.angleNL("", latLon.getLatitude());
        if (!string2.equals(string = unitsFormat.angleNL("", latLon2.getLatitude()))) {
            return false;
        }
        String string3 = unitsFormat.angleNL("", latLon.getLongitude());
        String string4 = unitsFormat.angleNL("", latLon2.getLongitude());
        return string3.equals(string4);
    }
}

