/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager;

import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.WMSLayerInfo;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerManager;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerPath;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeaturePanel;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerNode;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTree;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTreeGroupNode;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTreeModel;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTreeNode;
import gov.nasa.worldwindx.applications.worldwindow.util.PanelTitle;
import gov.nasa.worldwindx.applications.worldwindow.util.ShadedPanel;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LayerManagerPanel
extends AbstractFeaturePanel
implements LayerManager,
TreeModelListener {
    private static final String TOOL_TIP = "Select layers to add to the active layer list.";
    private static final String ICON_PATH = "gov/nasa/worldwindx/applications/worldwindow/images/layer-manager-64x64.png";
    private LayerTree layerTree;
    private boolean on = false;

    public LayerManagerPanel(Registry registry) {
        super("Layer Manager", "gov.nasa.worldwindx.applications.worldwindow.feature.LayerManager", ICON_PATH, new ShadedPanel(new BorderLayout()), registry);
    }

    @Override
    public void initialize(final Controller controller) {
        super.initialize(controller);
        LayerList layerList = controller.getWWd().getModel().getLayers();
        layerList.setDisplayName("Base Layers");
        this.layerTree = new LayerTree(new LayerTreeModel(layerList));
        this.layerTree.setOpaque(false);
        this.layerTree.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.layerTree.getModel().addTreeModelListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.layerTree);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        jPanel.add((Component)jScrollPane, "Center");
        PanelTitle panelTitle = new PanelTitle("Available Layers", 0);
        panelTitle.setToolTipText(TOOL_TIP);
        this.panel.add((Component)panelTitle, "North");
        this.panel.add((Component)jPanel, "Center");
        layerList.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() instanceof LayerList) {
                    ((LayerTreeModel)LayerManagerPanel.this.layerTree.getModel()).refresh((LayerList)propertyChangeEvent.getSource());
                    controller.redraw();
                } else if (propertyChangeEvent.getSource() instanceof Layer) {
                    LayerManagerPanel.this.layerTree.repaint();
                }
            }
        });
        this.panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                LayerManagerPanel.this.on = LayerManagerPanel.this.panel.isVisible() && ((LayerManagerPanel)LayerManagerPanel.this).panel.getSize().width > 0 && ((LayerManagerPanel)LayerManagerPanel.this).panel.getSize().height > 0;
                LayerManagerPanel.this.firePropertyChange("FeatureResized", null, LayerManagerPanel.this.panel.getSize());
            }
        });
    }

    protected LayerTreeModel getModel() {
        return (LayerTreeModel)this.layerTree.getModel();
    }

    @Override
    public void redraw() {
        this.layerTree.repaint();
    }

    @Override
    public boolean isTwoState() {
        return true;
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public void turnOn(boolean bl) {
        this.firePropertyChange("ShowLayerManager", this.on, bl);
        this.on = !this.on;
    }

    @Override
    public void scrollToLayer(Layer layer) {
        LayerTreeNode layerTreeNode = this.getModel().findLayer(layer, null);
        if (layerTreeNode == null || layerTreeNode == this.getModel().getRootNode()) {
            layerTreeNode = this.getModel().getDefaultGroupNode();
        }
        this.layerTree.scrollPathToVisible(new TreePath(layerTreeNode.getPath()));
    }

    @Override
    public void expandGroup(String string) {
        LayerTreeNode layerTreeNode = this.getModel().findByTitle(string);
        if (layerTreeNode != null) {
            this.layerTree.expandPath(new TreePath(layerTreeNode.getPath()));
        }
    }

    @Override
    public void expandPath(LayerPath layerPath) {
        LayerTreeNode layerTreeNode = (LayerTreeNode)this.getNode(layerPath);
        if (layerTreeNode != null) {
            this.layerTree.expandPath(new TreePath(layerTreeNode.getPath()));
        }
    }

    @Override
    public void enableGroupSelection(LayerPath layerPath, boolean bl) {
        LayerTreeNode layerTreeNode = this.getModel().getLastNode(layerPath);
        if (layerTreeNode != null) {
            layerTreeNode.setEnableSelectionBox(bl);
            this.layerTree.repaint();
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        if (objectArray != null && objectArray.length > 0) {
            LayerList layerList = this.controller.getWWd().getModel().getLayers();
            if (layerList == null) {
                return;
            }
            for (Object object : objectArray) {
                if (object == null || !(object instanceof LayerNode)) continue;
                if (object instanceof LayerTreeGroupNode) {
                    this.handleGroupSelection((LayerTreeGroupNode)object, layerList);
                    continue;
                }
                this.handleLayerSelection((LayerTreeNode)object, layerList);
            }
            this.updateGroupSelections();
            this.layerTree.repaint();
            this.controller.redraw();
        }
    }

    protected void handleLayerSelection(LayerTreeNode layerTreeNode, LayerList layerList) {
        if (layerTreeNode.getLayer() == null) {
            this.createLayer(layerTreeNode);
        }
        if (layerTreeNode.getLayer() == null) {
            Util.getLogger().warning("Unable to create the layer named " + layerTreeNode.getTitle());
            return;
        }
        if (layerTreeNode.isSelected() && !layerList.contains(layerTreeNode.getLayer())) {
            this.performSmartInsertion(layerTreeNode, layerList);
            layerTreeNode.getLayer().setEnabled(true);
        } else if (!layerTreeNode.isSelected() && layerList.contains(layerTreeNode.getLayer())) {
            layerList.remove(layerTreeNode.getLayer());
        }
    }

    protected void updateGroupSelections() {
        Enumeration<TreeNode> enumeration = ((LayerTreeModel)this.layerTree.getModel()).getRootNode().depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LayerTreeNode layerTreeNode = (LayerTreeNode)enumeration.nextElement();
            if (!(layerTreeNode instanceof LayerTreeGroupNode)) continue;
            this.updateGroupSelection(layerTreeNode);
        }
    }

    protected void updateGroupSelection(LayerTreeNode layerTreeNode) {
        if (layerTreeNode == null || layerTreeNode == ((LayerTreeModel)this.layerTree.getModel()).getDefaultGroupNode()) {
            return;
        }
        for (int i = 0; i < layerTreeNode.getChildCount(); ++i) {
            if (!((LayerNode)((Object)layerTreeNode.getChildAt(i))).isSelected()) continue;
            layerTreeNode.setSelected(true);
            return;
        }
        layerTreeNode.setSelected(false);
    }

    protected void handleGroupSelection(LayerTreeNode layerTreeNode, LayerList layerList) {
        Enumeration<TreeNode> enumeration = layerTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof LayerNode) || treeNode instanceof LayerTreeGroupNode) continue;
            LayerTreeNode layerTreeNode2 = (LayerTreeNode)treeNode;
            layerTreeNode2.setSelected(layerTreeNode.isSelected());
            this.handleLayerSelection(layerTreeNode2, layerList);
        }
    }

    protected void performSmartInsertion(LayerTreeNode layerTreeNode, LayerList layerList) {
        if (this.insertAfterPreviousSibling(layerTreeNode, layerList)) {
            return;
        }
        if (this.insertBeforeSubsequentSibling(layerTreeNode, layerList)) {
            return;
        }
        layerList.add(layerTreeNode.getLayer());
    }

    protected boolean insertAfterPreviousSibling(LayerTreeNode layerTreeNode, LayerList layerList) {
        for (LayerTreeNode layerTreeNode2 = (LayerTreeNode)layerTreeNode.getPreviousSibling(); layerTreeNode2 != null; layerTreeNode2 = (LayerTreeNode)layerTreeNode2.getPreviousSibling()) {
            int n = layerList.indexOf(layerTreeNode2.getLayer());
            if (n < 0) continue;
            layerList.add(n + 1, layerTreeNode.getLayer());
            return true;
        }
        return false;
    }

    protected boolean insertBeforeSubsequentSibling(LayerTreeNode layerTreeNode, LayerList layerList) {
        for (LayerTreeNode layerTreeNode2 = (LayerTreeNode)layerTreeNode.getNextSibling(); layerTreeNode2 != null; layerTreeNode2 = (LayerTreeNode)layerTreeNode2.getNextSibling()) {
            int n = layerList.indexOf(layerTreeNode2.getLayer());
            if (n < 0) continue;
            layerList.add(n, layerTreeNode.getLayer());
            return true;
        }
        return false;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public String getDefaultGroupName() {
        return this.getModel().getDefaultGroupNode().getTitle();
    }

    @Override
    public LayerPath getDefaultGroupPath() {
        return new LayerPath(this.getDefaultGroupName(), new String[0]);
    }

    @Override
    public void addGroup(LayerPath layerPath) {
        this.createPath(layerPath);
    }

    @Override
    public boolean containsPath(LayerPath layerPath) {
        return this.getNode(layerPath) != null;
    }

    @Override
    public LayerNode getNode(LayerPath layerPath) {
        return this.getModel().getLastNode(layerPath);
    }

    @Override
    public void selectLayer(Layer layer, boolean bl) {
        this.getModel().selectLayer(layer, bl);
    }

    @Override
    public Layer findLayerByTitle(String string, String string2) {
        LayerTreeNode layerTreeNode = this.getModel().findByTitle(string, string2);
        return layerTreeNode != null ? layerTreeNode.getLayer() : null;
    }

    @Override
    public void addLayer(Layer layer, LayerPath layerPath) {
        if (layer == null) {
            String string = "Layer is null";
            Util.getLogger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LayerTreeNode layerTreeNode = new LayerTreeNode(layer);
        this.addLayer(layerTreeNode, layerPath);
    }

    public void addLayer(LayerNode layerNode, LayerPath layerPath) {
        if (layerNode == null || layerNode.getLayer() == null) {
            String string = "LayerNode or Layer is null";
            Util.getLogger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LayerTreeNode layerTreeNode = LayerPath.isEmptyPath(layerPath) ? this.getModel().getRootNode() : this.getModel().getLastNode(layerPath);
        LayerTreeNode layerTreeNode2 = this.getModel().findByTitle(layerNode.getLayer().getName(), layerTreeNode);
        if (layerTreeNode2 != null) {
            this.removeLayer(layerTreeNode2.getLayer());
        }
        LayerTreeNode layerTreeNode3 = this.createPath(layerPath);
        layerNode.setAllowsChildren(false);
        this.getModel().insertNodeInto((LayerTreeNode)layerNode, layerTreeNode3, layerTreeNode3.getChildCount());
    }

    protected LayerTreeNode createPath(LayerPath layerPath) {
        LayerTreeNode layerTreeNode = this.getModel().getRootNode();
        if (LayerPath.isEmptyPath(layerPath)) {
            return layerTreeNode;
        }
        for (String string : layerPath) {
            LayerTreeNode layerTreeNode2 = this.getModel().findChild(string, layerTreeNode);
            if (layerTreeNode2 == null) {
                layerTreeNode2 = new LayerTreeGroupNode(string);
                this.getModel().insertNodeInto(layerTreeNode2, layerTreeNode, layerTreeNode.getChildCount());
                layerTreeNode = layerTreeNode2;
                continue;
            }
            if (layerTreeNode2 instanceof LayerTreeGroupNode) {
                layerTreeNode = layerTreeNode2;
                continue;
            }
            throw new IllegalArgumentException("Path element is not a group");
        }
        return layerTreeNode;
    }

    @Override
    public void removeLayer(Layer layer) {
        List<LayerTreeNode> list = this.getModel().findLayerInstances(layer, null);
        if (list == null) {
            return;
        }
        for (LayerNode layerNode : list) {
            if (layerNode == null) continue;
            this.removeLayer(layerNode);
        }
    }

    public void removeLayer(LayerNode layerNode) {
        LayerTreeNode layerTreeNode;
        if (layerNode == null) {
            return;
        }
        TreeNode[] treeNodeArray = ((LayerTreeNode)layerNode).getPath();
        this.getModel().removeNodeFromParent((LayerTreeNode)layerNode);
        for (int i = treeNodeArray.length - 2; i >= 1 && (layerTreeNode = (LayerTreeNode)treeNodeArray[i]) != this.getModel().getDefaultGroupNode(); --i) {
            if (layerTreeNode.getChildCount() != 0) continue;
            this.getModel().removeNodeFromParent(layerTreeNode);
        }
        if (layerNode.getLayer() != null) {
            LayerList layerList = this.controller.getWWd().getModel().getLayers();
            if (layerList != null) {
                layerList.remove(layerNode.getLayer());
            }
            layerNode.setLayer(null);
        }
    }

    @Override
    public void removeLayers(LayerList layerList) {
        Object object;
        if (layerList == null) {
            return;
        }
        LayerTreeGroupNode layerTreeGroupNode = this.getModel().getRootNode();
        if (WWUtil.isEmpty(layerList.getDisplayName()) && (object = this.getModel().findChild(layerList.getDisplayName(), this.getModel().getRootNode())) != null && object instanceof LayerTreeGroupNode) {
            layerTreeGroupNode = (LayerTreeGroupNode)object;
        }
        for (Layer layer : layerList) {
            LayerTreeNode layerTreeNode = this.getModel().findLayer(layer, layerTreeGroupNode);
            if (layerTreeNode == null) continue;
            this.removeLayer(layerTreeNode);
        }
    }

    @Override
    public void removeLayer(LayerPath layerPath) {
        LayerTreeNode layerTreeNode = this.getModel().getLastNode(layerPath);
        if (layerTreeNode != null) {
            this.removeLayer(layerTreeNode);
        }
    }

    @Override
    public Layer getLayerFromPath(LayerPath layerPath) {
        LayerTreeNode layerTreeNode = this.getModel().getLastNode(layerPath);
        return layerTreeNode != null && layerTreeNode.getLayer() != null ? layerTreeNode.getLayer() : null;
    }

    protected void createLayer(LayerNode layerNode) {
        if (layerNode == null) {
            String string = "LayerNode is null";
            Util.getLogger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (layerNode.getWmsLayerInfo() != null) {
            WMSLayerInfo wMSLayerInfo = layerNode.getWmsLayerInfo();
            AVList aVList = wMSLayerInfo.getParams().copy();
            aVList.setValue("gov.nasa.worldwind.avkey.URLConnectTimeout", 30000);
            aVList.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", 30000);
            aVList.setValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", 60000);
            Factory factory = (Factory)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.LayerFactory");
            Layer layer = (Layer)factory.createFromConfigSource(wMSLayerInfo.getCaps(), aVList);
            layerNode.setLayer(layer);
        }
    }
}

