/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.SurfaceSquare;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeaturePanel;
import gov.nasa.worldwindx.applications.worldwindow.util.PanelTitle;
import gov.nasa.worldwindx.applications.worldwindow.util.ShadedPanel;
import gov.nasa.worldwindx.applications.worldwindow.util.measuretool.WWOMeasureTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class MeasurementPanel
extends AbstractFeaturePanel {
    private static final String NAME = "Measurement";
    private WWOMeasureTool measureTool;
    private RenderableLayer shapeLayer;
    private RenderableLayer controlPointsLayer;
    private PropertyChangeListener toolListener;
    private JButton newButton;
    private JButton pauseButton;
    private JButton endButton;
    private JComboBox pathTypeCombo;
    private JComboBox shapeCombo;
    private Color lineColor = Color.WHITE;
    private Color fillColor = Color.WHITE;
    private String pathType = "gov.nasa.worldwind.avkey.GreatCircle";
    private static final String LINE = "Line";
    private static final String PATH = "Path";
    private static final String POLYGON = "Polygon";
    private static final String CIRCLE = "Circle";
    private static final String ELLIPSE = "Ellipse";
    private static final String SQUARE = "Square";
    private static final String RECTANGLE = "Rectangule";
    private static final String FREEHAND = "Freehand";
    private static final String GREAT_CIRCLE = "Great Circle";
    private static final String RHUMB = "Rhumb";
    private static final String LINEAR = "Linear";

    public MeasurementPanel(Registry registry) {
        super("Measurement Panel", "gov.nasa.worldwindx.applications.worldwindow.feature.MeasurementPanel", new ShadedPanel(new BorderLayout()), registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        this.createComponents(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.add((Component)jPanel, "Center");
        this.getJPanel().setOpaque(false);
        this.getJPanel().add((Component)jPanel2, "Center");
        this.getJPanel().setToolTipText("Measure distance or area");
        this.getJPanel().putClientProperty("gov.nasa.worldwindx.applications.worldwindow.FeatureOwnerProperty", this);
        this.getJPanel().add((Component)new PanelTitle(NAME, 0), "North");
        this.makeToolListener();
    }

    public void setLayers(RenderableLayer renderableLayer, RenderableLayer renderableLayer2) {
        this.shapeLayer = renderableLayer;
        this.controlPointsLayer = renderableLayer2;
        this.shapeCombo.setSelectedItem(LINE);
    }

    public RenderableLayer getShapeLayer() {
        return this.shapeLayer;
    }

    public Renderable getShape() {
        return this.measureTool != null ? this.measureTool.getShape() : null;
    }

    @Override
    public JComponent[] getDialogControls() {
        return null;
    }

    public WWOMeasureTool getMeasureTool() {
        return this.measureTool;
    }

    public void clearPanel() {
        this.disposeCurrentMeasureTool();
        this.shapeCombo.setSelectedItem(LINE);
    }

    public void deletePanel() {
        this.disposeCurrentMeasureTool();
    }

    public void setLineColor(Color color) {
        if (color == null || this.measureTool == null || this.measureTool.getShape() == null) {
            return;
        }
        this.lineColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(0.3 * (double)color.getAlpha()));
        this.setShapeColor(this.measureTool.getShape(), this.lineColor, this.fillColor);
    }

    public void setFillColor(Color color) {
        if (color == null || this.measureTool == null || this.measureTool.getShape() == null) {
            return;
        }
        this.fillColor = color;
        this.setShapeColor(this.measureTool.getShape(), this.lineColor, this.fillColor);
    }

    public void setShapeColor(Renderable renderable, Color color, Color color2) {
        if (renderable instanceof Polyline) {
            ((Polyline)renderable).setColor(color);
        }
        if (renderable instanceof SurfaceShape) {
            SurfaceShape surfaceShape = (SurfaceShape)renderable;
            ShapeAttributes shapeAttributes = surfaceShape.getAttributes();
            if (shapeAttributes == null) {
                shapeAttributes = new BasicShapeAttributes();
            }
            shapeAttributes.setInteriorMaterial(new Material(color2));
            shapeAttributes.setInteriorOpacity(0.3);
            shapeAttributes.setDrawOutline(false);
            surfaceShape.setAttributes(shapeAttributes);
        }
    }

    protected void setPathType(String string) {
        if (string == null || this.measureTool == null || this.measureTool.getShape() == null) {
            return;
        }
        this.pathType = string;
        if (this.measureTool.getShape() instanceof Polyline) {
            ((Polyline)this.measureTool.getShape()).setPathType(string);
        } else if (this.measureTool.getShape() instanceof SurfaceShape) {
            ((SurfaceShape)this.measureTool.getShape()).setPathType(string);
        }
    }

    protected void installNewMeasureTool(String string) {
        Renderable renderable = this.makeMeasureShape(string);
        this.measureTool = new WWOMeasureTool(this.controller.getWWd(), renderable, string.equals(PATH) || string.equals(FREEHAND) ? "gov.nasa.worldwind.avkey.ShapePath" : null, this.controlPointsLayer);
        if (string.equals(FREEHAND)) {
            this.measureTool.setFreeHand(true);
        }
        this.measureTool.setUnitsFormat(this.controller.getUnits());
        this.setShapeColor(this.measureTool.getShape(), this.lineColor, this.fillColor);
        this.updatePanelValues();
        this.newButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.endButton.setEnabled(false);
        this.measureTool.addPropertyChangeListener(this.toolListener);
    }

    protected void disposeCurrentMeasureTool() {
        if (this.measureTool == null) {
            return;
        }
        this.shapeLayer.removeRenderable(this.measureTool.getShape());
        if (this.measureTool.getShape() instanceof Disposable) {
            ((Disposable)((Object)this.measureTool.getShape())).dispose();
        }
        this.measureTool.removePropertyChangeListener(this.toolListener);
        this.measureTool.dispose();
        this.measureTool = null;
    }

    private Renderable makeMeasureShape(String string) {
        if (string.equals(LINE) || string.equals(PATH) || string.equals(FREEHAND)) {
            Polyline polyline = new Polyline();
            polyline.setFollowTerrain(true);
            polyline.setLineWidth(string.equals(FREEHAND) ? 2.0 : 4.0);
            return polyline;
        }
        if (string.equals(CIRCLE)) {
            return new SurfaceCircle();
        }
        if (string.equals(ELLIPSE)) {
            return new SurfaceEllipse();
        }
        if (string.equals(SQUARE)) {
            return new SurfaceSquare();
        }
        if (string.equals(RECTANGLE)) {
            return new SurfaceQuad();
        }
        if (string.equals(POLYGON)) {
            return new SurfacePolygon();
        }
        return null;
    }

    private boolean layerContains(RenderableLayer renderableLayer, Renderable renderable) {
        for (Renderable renderable2 : renderableLayer.getRenderables()) {
            if (renderable2 != renderable) continue;
            return true;
        }
        return false;
    }

    protected void makeToolListener() {
        this.toolListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("MeasureTool.Armed")) {
                    if (MeasurementPanel.this.getMeasureTool().isArmed()) {
                        MeasurementPanel.this.newButton.setEnabled(false);
                        MeasurementPanel.this.pauseButton.setText("Pause");
                        MeasurementPanel.this.pauseButton.setEnabled(true);
                        MeasurementPanel.this.endButton.setEnabled(true);
                        MeasurementPanel.this.controller.setCursor(Cursor.getPredefinedCursor(1));
                        ((Component)((Object)MeasurementPanel.this.controller.getWWd())).requestFocus();
                    } else {
                        MeasurementPanel.this.newButton.setEnabled(true);
                        MeasurementPanel.this.pauseButton.setText("Pause");
                        MeasurementPanel.this.pauseButton.setEnabled(false);
                        MeasurementPanel.this.endButton.setEnabled(false);
                        MeasurementPanel.this.controller.setCursor(Cursor.getDefaultCursor());
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("MeasureTool.AddPosition") && MeasurementPanel.this.getMeasureTool().getShape() != null && !MeasurementPanel.this.layerContains(MeasurementPanel.this.getShapeLayer(), MeasurementPanel.this.getMeasureTool().getShape())) {
                    MeasurementPanel.this.getShapeLayer().addRenderable(MeasurementPanel.this.getMeasureTool().getShape());
                }
            }
        };
    }

    protected void updatePanelValues() {
        if (this.pathType.equals("gov.nasa.worldwind.avkey.Linear")) {
            this.pathTypeCombo.setSelectedIndex(0);
        } else if (this.pathType.equals("gov.nasa.worldwind.avkey.RhumbLine")) {
            this.pathTypeCombo.setSelectedIndex(1);
        } else if (this.pathType.equals("gov.nasa.worldwind.avkey.GreatCircle")) {
            this.pathTypeCombo.setSelectedIndex(2);
        }
    }

    private void createComponents(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel2.setOpaque(false);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel2.add(new JLabel("Measurement Type:"));
        this.shapeCombo = new JComboBox<String>(new String[]{LINE, PATH, POLYGON, CIRCLE, ELLIPSE, SQUARE, RECTANGLE, FREEHAND});
        this.shapeCombo.setToolTipText("Choose a measurement type");
        this.shapeCombo.setOpaque(false);
        this.shapeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                MeasurementPanel.this.disposeCurrentMeasureTool();
                MeasurementPanel.this.installNewMeasureTool(string);
            }
        });
        jPanel2.add(this.shapeCombo);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel3.setOpaque(false);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel3.add(new JLabel("Route type:"));
        this.pathTypeCombo = new JComboBox<String>(new String[]{LINEAR, RHUMB, GREAT_CIRCLE});
        this.pathTypeCombo.setToolTipText("Choose a route type");
        this.pathTypeCombo.setOpaque(false);
        this.pathTypeCombo.setSelectedIndex(2);
        this.pathTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                if (string.equals(MeasurementPanel.LINEAR)) {
                    MeasurementPanel.this.setPathType("gov.nasa.worldwind.avkey.Linear");
                } else if (string.equals(MeasurementPanel.RHUMB)) {
                    MeasurementPanel.this.setPathType("gov.nasa.worldwind.avkey.RhumbLine");
                } else if (string.equals(MeasurementPanel.GREAT_CIRCLE)) {
                    MeasurementPanel.this.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
                }
                MeasurementPanel.this.controller.redraw();
            }
        });
        jPanel3.add(this.pathTypeCombo);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel4.setOpaque(false);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel4.setOpaque(false);
        this.newButton = new JButton("Start");
        this.newButton.setToolTipText("Start creating a measurement");
        this.newButton.setOpaque(false);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementPanel.this.getMeasureTool().clear();
                if (MeasurementPanel.this.shapeLayer != null && MeasurementPanel.this.measureTool.getShape() != null) {
                    MeasurementPanel.this.shapeLayer.removeRenderable(MeasurementPanel.this.measureTool.getShape());
                }
                MeasurementPanel.this.getMeasureTool().setArmed(true);
            }
        });
        jPanel4.add(this.newButton);
        this.newButton.setEnabled(true);
        this.pauseButton = new JButton("Pause");
        this.pauseButton.setToolTipText("Pause temporarily during measurement creation");
        this.pauseButton.setOpaque(false);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementPanel.this.getMeasureTool().setArmed(!MeasurementPanel.this.getMeasureTool().isArmed());
                MeasurementPanel.this.pauseButton.setText(!MeasurementPanel.this.getMeasureTool().isArmed() ? "Resume" : "Pause");
                MeasurementPanel.this.pauseButton.setEnabled(true);
                ((Component)((Object)MeasurementPanel.this.controller.getWWd())).setCursor(!MeasurementPanel.this.getMeasureTool().isArmed() ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(1));
            }
        });
        jPanel4.add(this.pauseButton);
        this.pauseButton.setEnabled(false);
        this.endButton = new JButton("Finish");
        this.endButton.setToolTipText("Press when measurement shape is complete");
        this.endButton.setOpaque(false);
        this.endButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementPanel.this.getMeasureTool().setArmed(false);
            }
        });
        jPanel4.add(this.endButton);
        this.endButton.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
    }
}

