/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.WWODialog;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.features.FeaturePanel;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class AbstractFeatureDialog
extends AbstractFeature
implements WWODialog {
    protected JDialog dialog;
    protected JPanel dialogPanel;
    protected JPanel leftButtonPanel;
    protected JPanel rightButtonPanel;
    protected JPanel centerButtonPanel;
    protected JButton closeButton;
    protected boolean positionInitialized = false;
    private int horizontalLocation = 0;
    private int verticalLocation = 0;

    protected AbstractFeatureDialog(String string, String string2, Registry registry) {
        super(string, string2, registry);
    }

    protected AbstractFeatureDialog(String string, String string2, String string3, Registry registry) {
        super(string, string2, string3, registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.dialog = new JDialog(this.controller.getFrame());
        this.dialog.setResizable(false);
        this.dialog.setModal(false);
        this.dialogPanel = this.createButtonPanel();
        this.dialog.getContentPane().add((Component)this.dialogPanel, "South");
        this.setTitle(this.getName());
    }

    @Override
    public JDialog getJDialog() {
        return this.dialog;
    }

    public void setTitle(String string) {
        this.dialog.setTitle(string != null ? string : "");
    }

    protected void setTaskPanel(FeaturePanel featurePanel) {
        this.setTaskComponent(featurePanel.getJPanel());
    }

    protected void setTaskPanel(String string) {
        FeaturePanel featurePanel = (FeaturePanel)this.controller.getRegisteredObject(string);
        if (featurePanel == null) {
            Util.getLogger().warning("Registrado ning\u00fan objeto para caracter\u00edstica " + string);
            return;
        }
        this.setTaskComponent(featurePanel.getJPanel());
        JComponent[] jComponentArray = featurePanel.getDialogControls();
        if (jComponentArray != null) {
            for (JComponent jComponent : jComponentArray) {
                this.insertDialogComponent(jComponent);
            }
        }
    }

    protected void setTaskComponent(JComponent jComponent) {
        this.dialog.getContentPane().add((Component)jComponent, "Center");
    }

    protected void insertLeftDialogComponent(JComponent jComponent) {
        int n = this.leftButtonPanel.getComponentCount();
        this.leftButtonPanel.add((Component)jComponent, n == 0 ? "West" : (n == 1 ? "Center" : "East"));
    }

    protected void insertRightDialogComponent(JComponent jComponent) {
        int n = this.rightButtonPanel.getComponentCount();
        this.rightButtonPanel.add((Component)jComponent, n == 0 ? "East" : (n == 1 ? "Center" : "West"));
    }

    protected void insertCenterDialogComponent(JComponent jComponent) {
        int n = this.centerButtonPanel.getComponentCount();
        this.centerButtonPanel.add((Component)jComponent, n == 0 ? "Center" : (n == 1 ? "East" : "West"));
    }

    protected void insertDialogComponent(JComponent jComponent) {
        this.insertRightDialogComponent(jComponent);
    }

    protected void setLocation(int n, int n2) {
        this.horizontalLocation = n;
        this.verticalLocation = n2;
        this.positionInitialized = false;
    }

    @Override
    public void turnOn(boolean bl) {
        this.setVisible(bl);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.dialog.pack();
        }
        if (bl && !this.positionInitialized) {
            Util.positionDialogInContainer(this.dialog, this.controller.getAppPanel().getJPanel(), this.horizontalLocation, this.verticalLocation);
            this.positionInitialized = true;
        }
        this.dialog.setVisible(bl);
    }

    private JPanel createButtonPanel() {
        this.leftButtonPanel = new JPanel(new BorderLayout(10, 5));
        this.rightButtonPanel = new JPanel(new BorderLayout(10, 5));
        this.centerButtonPanel = new JPanel(new BorderLayout(10, 5));
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(new EmptyBorder(10, 20, 10, 20));
        jPanel.add((Component)this.leftButtonPanel, "West");
        jPanel.add((Component)this.rightButtonPanel, "East");
        jPanel.add((Component)this.centerButtonPanel, "Center");
        this.closeButton = new JButton("Close");
        this.closeButton.setToolTipText("Close dialog");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractFeatureDialog.this.setVisible(false);
            }
        });
        this.rightButtonPanel.add((Component)this.closeButton, "East");
        return jPanel;
    }
}

