/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.segmentplane;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.geom.BilinearInterpolator;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlaneAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SegmentPlane
extends WWObjectImpl {
    public static final String ALTIMETER = "SegmentPlane.Altimeter";
    public static final String CONTROL_POINT_LOWER_LEFT = "SegmentPlane.ControlPointLowerLeft";
    public static final String CONTROL_POINT_LOWER_RIGHT = "SegmentPlane.ControlPointLowerRight";
    public static final String CONTROL_POINT_UPPER_RIGHT = "SegmentPlane.ControlPointUpperRight";
    public static final String CONTROL_POINT_TOP_EDGE = "SegmentPlane.ControlPointTopEdge";
    public static final String CONTROL_POINT_LEADING_EDGE = "SegmentPlane.ControlPointLeadingEdge";
    public static final String HORIZONTAL_AXIS_LABELS = "SegmentPlane.HorizontalAxisLabels";
    public static final String PLANE_ALTITUDES = "SegmentPlane.PlaneAltitudes";
    public static final String PLANE_BACKGROUND = "SegmentPlane.PlaneBackground";
    public static final String PLANE_BORDER = "SegmentPlane.PlaneBorder";
    public static final String PLANE_GRID = "SegmentPlane.PlaneGrid";
    public static final String PLANE_GRID_DIMENSIONS = "SegmentPlane.PlaneGridDimensions";
    public static final String PLANE_LOCATIONS = "SegmentPlane.PlaneLocations";
    public static final String PLANE_OUTLINE = "SegmentPlane.PlaneOutline";
    public static final String SEGMENT_BEGIN = "SegmentPlane.SegmentBegin";
    public static final String SEGMENT_END = "SegmentPlane.SegmentEnd";
    public static final String VERTICAL_AXIS_LABELS = "SegmentPlane.VerticalAxisLabels";
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    private boolean visible = true;
    private SegmentPlaneAttributes attributes = new SegmentPlaneAttributes();
    private double planeLowerAltitude = 0.0;
    private double planeUpperAltitude = 0.0;
    private LatLon planeLocation1 = LatLon.ZERO;
    private LatLon planeLocation2 = LatLon.ZERO;
    private double gridCellWidth = 1.0;
    private double gridCellHeight = 1.0;
    private int planeOutlineMask = 15;
    private int borderMask = 15;
    private Position segmentBeginPosition = Position.ZERO;
    private Position segmentEndPosition = Position.ZERO;
    private List<ControlPoint> controlPointList = new ArrayList<ControlPoint>();
    protected long serialNumber = 1L;

    public SegmentPlane() {
        this.addDefaultAttributes(PLANE_BACKGROUND);
        this.addDefaultAttributes(PLANE_GRID);
        this.addDefaultAttributes(PLANE_OUTLINE);
        this.addDefaultAttributes(PLANE_BORDER);
        this.addDefaultAttributes(SEGMENT_BEGIN);
        this.addDefaultAttributes(SEGMENT_END);
        this.addDefaultAttributes(ALTIMETER);
        this.addDefaultControlPoint(CONTROL_POINT_LOWER_RIGHT, 1.0, 0.0, true, "gov.nasa.worldwind.render.markers.Sphere");
        this.addDefaultControlPoint(CONTROL_POINT_UPPER_RIGHT, 1.0, 1.0, false, "gov.nasa.worldwind.render.markers.Sphere");
        this.addDefaultControlPoint(CONTROL_POINT_TOP_EDGE, 0.5, 1.0, false, "gov.nasa.worldwind.render.markers.Sphere");
        this.addDefaultControlPoint(CONTROL_POINT_LEADING_EDGE, 1.0, 0.5, true, "gov.nasa.worldwind.render.markers.Sphere");
    }

    protected void addDefaultAttributes(Object object) {
        this.getAttributes().setGeometryAttributes(object, new SegmentPlaneAttributes.GeometryAttributes());
        this.getAttributes().setLabelAttributes(object, new SegmentPlaneAttributes.LabelAttributes());
    }

    protected void addDefaultControlPoint(Object object, double d, double d2, boolean bl, String string) {
        this.addControlPoint(new ControlPoint(this, object, d, d2, bl, string));
        this.addDefaultAttributes(object);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public SegmentPlaneAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(SegmentPlaneAttributes segmentPlaneAttributes) {
        if (segmentPlaneAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = segmentPlaneAttributes;
    }

    public double[] getPlaneAltitudes() {
        return new double[]{this.planeLowerAltitude, this.planeUpperAltitude};
    }

    public void setPlaneAltitudes(double d, double d2) {
        double[] dArray = this.getPlaneAltitudes();
        this.planeLowerAltitude = d;
        this.planeUpperAltitude = d2;
        this.setStateExpired();
        this.firePropertyChange(PLANE_ALTITUDES, dArray, this.getPlaneAltitudes());
    }

    public LatLon[] getPlaneLocations() {
        return new LatLon[]{this.planeLocation1, this.planeLocation2};
    }

    public void setPlaneLocations(LatLon latLon, LatLon latLon2) {
        if (latLon == null) {
            String string = "nullValue.Location1IsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = "nullValue.Location2IsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon[] latLonArray = this.getPlaneLocations();
        this.planeLocation1 = latLon;
        this.planeLocation2 = latLon2;
        this.setStateExpired();
        this.firePropertyChange(PLANE_LOCATIONS, latLonArray, this.getPlaneLocations());
    }

    public double[] getGridCellDimensions() {
        return new double[]{this.gridCellWidth, this.gridCellHeight};
    }

    public void setGridCellDimensions(double d, double d2) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getGridCellDimensions();
        this.gridCellWidth = d;
        this.gridCellHeight = d2;
        this.setStateExpired();
        this.firePropertyChange(PLANE_GRID_DIMENSIONS, dArray, this.getGridCellDimensions());
    }

    public int getPlaneOutlineMask() {
        return this.planeOutlineMask;
    }

    public void setPlaneOutlineMask(int n) {
        this.planeOutlineMask = n;
        this.setStateExpired();
    }

    public int getBorderMask() {
        return this.borderMask;
    }

    public void setBorderMask(int n) {
        this.borderMask = n;
        this.setStateExpired();
    }

    public Position[] getSegmentPositions() {
        return new Position[]{this.segmentBeginPosition, this.segmentEndPosition};
    }

    public void setSegmentPositions(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.Position1IsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.Position2IsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setSegmentBeginPosition(position);
        this.setSegmentEndPosition(position2);
    }

    public void setSegmentBeginPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.segmentBeginPosition;
        this.segmentBeginPosition = position;
        this.firePropertyChange(SEGMENT_BEGIN, position2, this.segmentBeginPosition);
    }

    public void setSegmentEndPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.segmentEndPosition;
        this.segmentEndPosition = position;
        this.firePropertyChange(SEGMENT_END, position2, this.segmentEndPosition);
    }

    public List<ControlPoint> getControlPoints() {
        return Collections.unmodifiableList(this.controlPointList);
    }

    public void setControlPoints(Iterable<? extends ControlPoint> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.controlPointList.clear();
        for (ControlPoint controlPoint : iterable) {
            this.addControlPoint(controlPoint);
        }
        this.setStateExpired();
    }

    protected void addControlPoint(ControlPoint controlPoint) {
        if (controlPoint.getOwner() != this) {
            String string = Logging.getMessage("generic.OwnerIsInvalid", controlPoint.getOwner());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.controlPointList.add(controlPoint);
    }

    public Object getStateKey() {
        return new StateKey(this, this.serialNumber);
    }

    public Plane computeInfinitePlane(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BilinearInterpolator bilinearInterpolator = this.createPlaneInterpolator(globe);
        Vec4[] vec4Array = bilinearInterpolator.getCorners();
        Vec4 vec4 = vec4Array[1].subtract3(vec4Array[0]);
        Vec4 vec42 = vec4Array[3].subtract3(vec4Array[0]);
        Vec4 vec43 = vec4.cross3(vec42).normalize3();
        double d = -vec4Array[0].dot3(vec43);
        if (vec43.equals(Vec4.ZERO)) {
            return null;
        }
        return new Plane(vec43.x, vec43.y, vec43.z, d);
    }

    public BilinearInterpolator createPlaneInterpolator(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getPlaneAltitudes();
        LatLon[] latLonArray = this.getPlaneLocations();
        Vec4 vec4 = globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[0]);
        Vec4 vec42 = globe.computePointFromPosition(latLonArray[1].getLatitude(), latLonArray[1].getLongitude(), dArray[0]);
        Vec4 vec43 = globe.computePointFromPosition(latLonArray[1].getLatitude(), latLonArray[1].getLongitude(), dArray[1]);
        Vec4 vec44 = globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[1]);
        return new BilinearInterpolator(vec4, vec42, vec43, vec44);
    }

    protected void setStateExpired() {
        ++this.serialNumber;
    }

    protected static class StateKey {
        private final SegmentPlane segmentPlane;
        private final long serialNumber;

        public StateKey(SegmentPlane segmentPlane, long l) {
            this.segmentPlane = segmentPlane;
            this.serialNumber = l;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StateKey stateKey = (StateKey)object;
            return this.segmentPlane.equals(stateKey.segmentPlane) && this.serialNumber == stateKey.serialNumber;
        }

        public int hashCode() {
            int n = this.segmentPlane != null ? this.segmentPlane.hashCode() : 0;
            n = 31 * n + (int)(this.serialNumber ^ this.serialNumber >>> 32);
            return n;
        }
    }

    public static class ControlPoint {
        private Object owner;
        private Object key;
        private double uCoordinate;
        private double vCoordinate;
        private boolean relativeToSurface;
        private String shapeType;

        public ControlPoint(Object object, Object object2, double d, double d2, boolean bl, String string) {
            if (object == null) {
                String string2 = Logging.getMessage("nullValue.OwnerIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            if (object2 == null) {
                String string3 = Logging.getMessage("nullValue.KeyIsNull");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            this.owner = object;
            this.key = object2;
            this.uCoordinate = d;
            this.vCoordinate = d2;
            this.relativeToSurface = bl;
            this.shapeType = string;
        }

        public Object getOwner() {
            return this.owner;
        }

        public Object getKey() {
            return this.key;
        }

        public double[] getCoordinates() {
            return new double[]{this.uCoordinate, this.vCoordinate};
        }

        public boolean isRelativeToSurface() {
            return this.relativeToSurface;
        }

        public String getShapeType() {
            return this.shapeType;
        }
    }
}

