/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.ScalebarLayer;
import gov.nasa.worldwind.layers.TerrainProfileLayer;
import gov.nasa.worldwind.util.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WWPanel
extends JPanel {
    private FocusablePanel panel;
    private WorldWindowGLCanvas wwd;
    private StatusBar statusBar;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "ElevationUnit") {
                WWPanel.this.updateElevationUnit(propertyChangeEvent.getNewValue());
            }
            if (propertyChangeEvent.getPropertyName() == "AngleFormat") {
                WWPanel.this.updateAngleFormat(propertyChangeEvent.getNewValue());
            }
        }
    };
    private final FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.focusChanged(focusEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusChanged(focusEvent);
        }

        protected void focusChanged(FocusEvent focusEvent) {
            WWPanel.this.repaint();
        }
    };

    public WWPanel() {
        super(new BorderLayout(0, 0));
        this.wwd = new WorldWindowGLCanvas();
        this.wwd.setPreferredSize(new Dimension(800, 800));
        Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
        this.wwd.setModel(model);
        this.wwd.addPropertyChangeListener(this.propertyChangeListener);
        this.wwd.addFocusListener(this.focusListener);
        this.wwd.setFocusable(true);
        this.statusBar = new StatusBar();
        this.statusBar.setEventSource(this.wwd);
        this.panel = new FocusablePanel((LayoutManager)new BorderLayout(0, 0), (Component)((Object)this.wwd));
        this.panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.panel.add((Component)((Object)this.wwd), "Center");
        this.add((Component)this.panel, "Center");
        this.add((Component)this.statusBar, "Last");
    }

    public WorldWindowGLCanvas getWwd() {
        return this.wwd;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    private void updateElevationUnit(Object object) {
        for (Layer layer : this.wwd.getModel().getLayers()) {
            if (layer instanceof ScalebarLayer) {
                if ("Imperial".equals(object)) {
                    ((ScalebarLayer)layer).setUnit("gov.nasa.worldwind.ScalebarLayer.Imperial");
                    continue;
                }
                ((ScalebarLayer)layer).setUnit("gov.nasa.worldwind.ScalebarLayer.Metric");
                continue;
            }
            if (!(layer instanceof TerrainProfileLayer)) continue;
            if ("Imperial".equals(object)) {
                ((TerrainProfileLayer)layer).setUnit("gov.nasa.worldwind.TerrainProfileLayer.Imperial");
                continue;
            }
            ((TerrainProfileLayer)layer).setUnit("gov.nasa.worldwind.TerrainProfileLayer.Metric");
        }
        if ("Imperial".equals(object)) {
            this.statusBar.setElevationUnit("gov.nasa.worldwind.StatusBar.Imperial");
        } else {
            this.statusBar.setElevationUnit("gov.nasa.worldwind.StatusBar.Metric");
        }
    }

    private void updateAngleFormat(Object object) {
        this.statusBar.setAngleFormat((String)object);
    }

    protected static class FocusablePanel
    extends JPanel {
        private Component focusContext;

        public FocusablePanel(LayoutManager layoutManager, Component component) {
            super(layoutManager);
            this.focusContext = component;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.focusContext.isFocusOwner()) {
                Rectangle rectangle = this.getBounds();
                BasicGraphicsUtils.drawDashedRect(graphics, 0, 0, rectangle.width, rectangle.height);
            }
        }
    }
}

